#include <string.h>
#include <stdio.h>
#include "getHome.h"

void help(){
  fprintf(stderr,"\n");
  fprintf(stderr,"getHome: obtains the home path of the given user.\n");
  fprintf(stderr,"         Nowadays it actually works with local users\n");
  fprintf(stderr,"         (that is, those in /etc/passwd, not in NIS).\n");
  fprintf(stderr,"Usage: getHome <user_login>\n");
  fprintf(stderr,"Returns the path to the user home in stdout, empty\n");
  fprintf(stderr,"string if not found\n");
  fprintf(stderr,"\n");
}


int main(int argc, char *argv[]){
  char home[MAXPATHLEN];

  if (argc != 2){
    help();
    exit(1);
  }
  if ( (!strncmp(argv[1], "--help", 6)) ||
       (!strncmp(argv[1], "-h", 2)) ){
    help();
    exit(0);
  }

  if (getHome(argv[1], home) == -1){
    exit(1);
  }
  printf("%s\n", home);
  exit(0);
}
