
#include <curses.h>
#include <signal.h>
#include <panel.h>
#include <sys/types.h>
#include <sys/wait.h>

#include "dialog/dialog.h"
#include "ppaSetBase.h"

#ifndef DIALOGPROGRAM
#define DIALOGPROGRAM "/usr/bin/dialog"
#endif

#define DDD(s) fprintf(stderr, "%s\n", s);

#define HEIGHT LINES-2
#define WIDTH COLS-2
ppaSet_t settings;

// They are defined in dialog/dialog.c
extern char *lock_refresh;
extern char *lock_tailbg_exit;
extern char *lock_tailbg_refreshed;

/* Error reporting function: exits if v != 0 */
void _eee_(char *s, int v){
  fprintf(stderr, "%s", s);
  if (v != 0)
    exit(v);
}

int showHelp(){
  char helpPath[MAXPATHLEN];
  char h[10];
  char w[10];
  int pid;
  int status;
  strcpy(helpPath, BASEDIR);
  strcat(helpPath, "/HELP");
  dialog_textbox("nPpaSet: Help", helpPath, HEIGHT, WIDTH);
  return 0;
}

void typeBasicGUI(){
  char *typeBasicRadio[18] = {
    "1", "HP 710", "off",
    "2", "HP 712", "off",
    "3", "HP 720", "off",
    "4", "HP 722", "off",
    "5", "HP 820", "off",
    "6", "HP 1000", "off"
  };
  int err;
  char *on = "on";
  char option[2]; // The number and the ending 0

  switch (settings.type) {
  case TYPE_HP710:
    typeBasicRadio[2] = on;
    break;
  case TYPE_HP712:
    typeBasicRadio[5] = on;
    break;
  case TYPE_HP720:
    typeBasicRadio[8] = on;
    break;
  case TYPE_HP722:
    typeBasicRadio[11] = on;
    break;
  case TYPE_HP820:
    typeBasicRadio[14] = on;
    break;
  case TYPE_HP1000:
    typeBasicRadio[17] = on;
    break;
  default:
    typeBasicRadio[8] = on;
    break;
  }

  err = dialog_checklist("nPpaSet: Basic: Type", "Select a type", HEIGHT, WIDTH, 6, 6, (char**)typeBasicRadio, FALSE, TRUE, option);
  if (err < 0){
    // ESC, ^C or Cancel were used
  } else {
    switch (option[0]){
    case '1':
      settings.type = TYPE_HP710;
      break;
    case '2':
      settings.type = TYPE_HP712;
      break;
    case '3':
      settings.type = TYPE_HP720;
      break;
    case '4':
      settings.type = TYPE_HP722;
      break;
    case '5':
      settings.type = TYPE_HP820;
      break;
    case '6':
      settings.type = TYPE_HP1000;
      break;
    default:
      settings.type = TYPE_HP720;
      break;
    }
  }
  return;
}

void colorBasicGUI(){
  char *colorBasicRadio[9] = {
    "1", "Full color", "off",
    "2", "Greyscale", "off",
    "3", "Black & White", "off",
  };
  int err;
  char *on = "on";
  char option[2]; // The number and the ending 0

  switch (settings.color) {
  case COLOR_COLOR:
    colorBasicRadio[2] = on;
    break;
  case COLOR_GREYSCALE:
    colorBasicRadio[5] = on;
    break;
  case COLOR_BLACKWHITE:
    colorBasicRadio[8] = on;
    break;
  default:
    colorBasicRadio[2] = on;
    break;
  }

  err = dialog_checklist("nPpaSet: Basic: Color", "Select a color mode", HEIGHT, WIDTH, 3, 3, (char**)colorBasicRadio, FALSE, TRUE, option);
  if (err < 0){
    // ESC, ^C or Cancel were used
  } else {
    switch (option[0]){
    case '1':
      settings.color = COLOR_COLOR;
      break;
    case '2':
      settings.color = COLOR_GREYSCALE;
      break;
    case '3':
      settings.color = COLOR_BLACKWHITE;
      break;
    default:
      settings.color = COLOR_COLOR;
      break;
    }
  }
  return;
}

void ditherBasicGUI(){
  char *ditherBasicRadio[6] = {
    "1", "Floid-Steinberg dithering", "off",
    "2", "Fast dithering", "off",
  };
  int err;
  char *on = "on";
  char option[2]; // The number and the ending 0

  switch (settings.dither) {
  case DITHER_FS:
    ditherBasicRadio[2] = on;
    break;
  case DITHER_FAST:
    ditherBasicRadio[5] = on;
    break;
  default:
    ditherBasicRadio[2] = on;
    break;
  }

  err = dialog_checklist("nPpaSet: Basic: Dither", "Select a dithering mode", HEIGHT, WIDTH, 2, 2, (char**)ditherBasicRadio, FALSE, TRUE, option);
  if (err < 0){
    // ESC, ^C or Cancel were used
  } else {
    switch (option[0]){
    case '1':
      settings.dither = DITHER_FS;
      break;
    case '2':
      settings.dither = DITHER_FAST;
      break;
    default:
      settings.dither = DITHER_FS;
      break;
    }
  }
  return;
}

void qualityBasicGUI(){
  char *modeBasicRadio[9] = {
    "1", "Economic mode", "off",
    "2", "Normal mode", "off",
    "3", "Photo mode", "off",
  };
  int err;
  char *on = "on";
  char option[2]; // The number and the ending 0

  switch (settings.mode) {
  case MODE_ECO:
    modeBasicRadio[2] = on;
    break;
  case MODE_NORMAL:
    modeBasicRadio[5] = on;
    break;
  case MODE_PHOTO:
    modeBasicRadio[8] = on;
    break;
  default:
    modeBasicRadio[5] = on;
    break;
  }

  err = dialog_checklist("nPpaSet: Basic: Mode", "Select a quality mode", HEIGHT, WIDTH, 3, 3, (char**)modeBasicRadio, FALSE, TRUE, option);
  if (err < 0){
    // ESC, ^C or Cancel were used
  } else {
    switch (option[0]){
    case '1':
      settings.mode = MODE_ECO;
      break;
    case '2':
      settings.mode = MODE_NORMAL;
      break;
    case '3':
      settings.mode = MODE_PHOTO;
      break;
    default:
      settings.mode = MODE_NORMAL;
      break;
    }
  }
  return;
}

void basicGUI(){
  const char *basicMenu[8] = {
    "1", "Type of printer",
    "2", "Color mode",
    "3", "Dithering mode", 
    "4", "Quality mode"
  };
  int option = 0;

  option = dialog_menu("nPppaSet: Basic", "Select a group", HEIGHT, WIDTH, 4, 4,(char**)basicMenu);
  if (option < 0){ // ESC, ^C or Cancel were used
    return;
  } else {
    switch (option) {
    case 0: // Type
      typeBasicGUI();
      break;
    case 1: // Color
      colorBasicGUI();
      break;
    case 2: // Dither
      ditherBasicGUI();
      break;
    case 3: // Quality
      qualityBasicGUI();
      break;
    default:
	break;
    }
  }
}

void sizePaperGUI(){
  char *sizePaperRadio[12] = {
    "1", "A4", "off",
    "2", "A3", "off",
    "3", "US legal", "off",
    "4", "US letter", "off",
  };
  int err;
  char *on = "on";
  char option[2]; // The number and the ending 0

  switch (settings.paper) {
  case PAPER_A4:
    sizePaperRadio[2] = on;
    break;
  case PAPER_A3:
    sizePaperRadio[5] = on;
    break;
  case PAPER_LEGAL:
    sizePaperRadio[8] = on;
    break;
  case PAPER_LETTER:
    sizePaperRadio[11] = on;
    break;
  default:
    sizePaperRadio[2] = on;
    break;
  }

  err = dialog_checklist("nPpaSet: Paper: Size", "Select a paper size", HEIGHT, WIDTH, 4, 4, (char**)sizePaperRadio, FALSE, TRUE, option);
  if (err < 0){
    // ESC, ^C or Cancel were used
  } else {
    switch (option[0]){
    case '1':
      settings.paper = PAPER_A4;
      break;
    case '2':
      settings.paper = PAPER_A3;
      break;
    case '3':
      settings.paper = PAPER_LEGAL;
      break;
    case '4':
      settings.paper = PAPER_LETTER;
      break;
    default:
      settings.paper = PAPER_A4;
      break;
    }
  }
  return;
}

void omPaperGUI(){
  const char *omPaperMenu[12] = {
    "1", "X offset",
    "2", "Y offset",
    "3", "Top margin",
    "4", "Bottom margin",
    "5", "Left margin",
    "6", "Right margin",
  };
  char x[MAX_LEN];
  char xx[MAX_LEN];
  char y[MAX_LEN];
  char yy[MAX_LEN];
  char t[MAX_LEN];
  char tt[MAX_LEN];
  char b[MAX_LEN];
  char bb[MAX_LEN];
  char l[MAX_LEN];
  char ll[MAX_LEN];
  char r[MAX_LEN];
  char rr[MAX_LEN];
  int option = 0;

  sprintf(x, "X offset: %i", settings.xOffset);
  sprintf(xx, "%i", settings.xOffset);
  omPaperMenu[1] = x;
  sprintf(y, "Y offset: %i", settings.yOffset);
  sprintf(yy, "%i", settings.yOffset);
  omPaperMenu[3] = y;
  sprintf(t, "Top margin: %i", settings.topMargin);
  sprintf(tt, "%i", settings.topMargin);
  omPaperMenu[5] = t;
  sprintf(b, "Bottom margin: %i", settings.bottomMargin);
  sprintf(bb, "%i", settings.bottomMargin);
  omPaperMenu[7] = b;
  sprintf(l, "Left margin: %i", settings.leftMargin);
  sprintf(ll, "%i", settings.leftMargin);
  omPaperMenu[9] = l;
  sprintf(r, "Right margin: %i", settings.rightMargin);
  sprintf(rr, "%i", settings.rightMargin);
  omPaperMenu[11] = r;

  option = dialog_menu("nPppaSet: Paper: Offsets and marggins", "Select a value to change", HEIGHT, WIDTH, 6, 6,(char**)omPaperMenu);
  if (option < 0){ // ESC, ^C or Cancel were used
    return;
  } else {
    switch (option) {
    case 0:
      if (dialog_inputbox("nPpaSet: Paper: Offsets and margins", "X offset", HEIGHT, WIDTH, xx, 0) == 0){
	if (dialog_input_result[0] == 0){
	  // Do nothing. Let the old value	  
	} else {
	  settings.xOffset = atoi(dialog_input_result);
	}
      }
      break;
    case 1:
      if (dialog_inputbox("nPpaSet: Paper: Offsets and margins", "Y offset", HEIGHT, WIDTH, yy, 0) == 0){
	if (dialog_input_result[0] == 0){
	  // Do nothing. Let the old value	  
	} else {
	  settings.yOffset = atoi(dialog_input_result);
	}
      }
      break;
    case 2:
      if (dialog_inputbox("nPpaSet: Paper: Offsets and margins", "Top margin", HEIGHT, WIDTH, tt, 0) == 0){
	if (dialog_input_result[0] == 0){
	  // Do nothing. Let the old value	  
	} else {
	  settings.topMargin = atoi(dialog_input_result);
	}
      }
      break;
    case 3:
      if (dialog_inputbox("nPpaSet: Paper: Offsets and margins", "Bottom margin", HEIGHT, WIDTH, bb, 0) == 0){
	if (dialog_input_result[0] == 0){
	  // Do nothing. Let the old value	  
	} else {
	  settings.bottomMargin = atoi(dialog_input_result);
	}
      }
      break;
    case 4:
      if (dialog_inputbox("nPpaSet: Paper: Offsets and margins", "Left margin", HEIGHT, WIDTH, ll, 0) == 0){
	if (dialog_input_result[0] == 0){
	  // Do nothing. Let the old value	  
	} else {
	  settings.leftMargin = atoi(dialog_input_result);
	}
      }
      break;
    case 5:
      if (dialog_inputbox("nPpaSet: Paper: Offsets and margins", "Right margin", HEIGHT, WIDTH, rr, 0) == 0){
	if (dialog_input_result[0] == 0){
	  // Do nothing. Let the old value	  
	} else {
	  settings.rightMargin = atoi(dialog_input_result);
	}
      }
      break;
    default:
      // Do nothing... we mustn't reach here
      break;
    }
  }
}

void paperGUI(){
  const char *basicMenu[4] = {
    "1", "Paper size",
    "2", "Offsets and margins",
  };
  int option = 0;

  option = dialog_menu("nPppaSet: Paper options", "Select a group", HEIGHT, WIDTH, 2, 2,(char**)basicMenu);
  if (option < 0){ // ESC, ^C or Cancel were used
    return;
  } else {
    switch (option) {
    case 0:
      sizePaperGUI();
      break;
    case 1:
      omPaperGUI();
      break;
    default:
	break;
    }
  }
}

void biuniFineAdvancedGUI(){
  char *biuniFineAdvancedRadio[6] = {
    "1", "Unidirectional printing", "off",
    "2", "Bidirectional printing", "off",
  };
  int err;
  char *on = "on";
  char option[2]; // The number and the ending 0
  char defaultInput[MAX_LEN];

  switch (settings.biUni) {
  case BIUNI_UNI:
    biuniFineAdvancedRadio[2] = on;
    break;
  case BIUNI_BI:
    biuniFineAdvancedRadio[5] = on;
    break;
  default:
    biuniFineAdvancedRadio[2] = on;
    break;
  }

  err = dialog_checklist("nPpaSet: Advanced: Fine tunning", "Select a mode", HEIGHT, WIDTH, 2, 2, (char**)biuniFineAdvancedRadio, FALSE, TRUE, option);
  if (err < 0){
    // ESC, ^C or Cancel were used
  } else {
    switch (option[0]){
    case '1':
      settings.biUni = BIUNI_UNI;
      break;
    case '2':
      settings.biUni = BIUNI_BI;
      sprintf(defaultInput, "%i", settings.bwShearing);
      if (dialog_inputbox("nPpaSet: Advanced: Fine: Bidirectional", "Black&white shearing", HEIGHT, WIDTH, defaultInput, 0) == 0){
	if (dialog_input_result[0] == 0){
	  // Do nothing. Let the old value	  
	} else {
	  settings.bwShearing = atoi(dialog_input_result);
	}
      }
      sprintf(defaultInput, "%i", settings.colorShearing);
      if (dialog_inputbox("nPpaSet: Advanced: Fine: Bidirectional", "Color shearing", HEIGHT, WIDTH, defaultInput, 0) == 0){
	if (dialog_input_result[0] == 0){
	  // Do nothing. Let the old value	  
	} else {
	  settings.colorShearing = atoi(dialog_input_result);
	}
      }
      break;
    default:
      settings.biUni = BIUNI_UNI;
      break;
    }
  }
  return;  
}

void fineAdvancedGUI(){
  const char *fineAdvancedMenu[8] = {
    "1", "Bidirectional mode",
    "2", "X color offset",
    "3", "Y color offset",
    "4", "Blackness",
  };
  char xc[MAX_LEN];
  char xxcc[MAX_LEN];
  char yc[MAX_LEN];
  char yycc[MAX_LEN];
  char b[MAX_LEN];
  char bb[MAX_LEN];
  int option = 0;

  sprintf(xc, "X color offset: %i", settings.xOffsetColor);
  sprintf(xxcc, "%i", settings.xOffsetColor);
  fineAdvancedMenu[3] = xc;
  sprintf(yc, "Y color offset: %i", settings.yOffsetColor);
  sprintf(yycc, "%i", settings.yOffsetColor);
  fineAdvancedMenu[5] = yc;
  sprintf(b, "Blackness: %i", settings.blackness);
  sprintf(bb, "%i", settings.blackness);
  fineAdvancedMenu[7] = b;

  option = dialog_menu("nPppaSet: Advanced: Fine", "Select a value to change", HEIGHT, WIDTH, 4, 4,(char**)fineAdvancedMenu);
  if (option < 0){ // ESC, ^C or Cancel were used
    return;
  } else {
    switch (option) {
    case 0:
      biuniFineAdvancedGUI();
      break;
    case 1:
      if (dialog_inputbox("nPpaSet: Advanced: Fine tunning", "X color offset", HEIGHT, WIDTH, xxcc, 0) == 0){
	if (dialog_input_result[0] == 0){
	  // Do nothing. Let the old value	  
	} else {
	  settings.xOffsetColor = atoi(dialog_input_result);
	}
      }
      break;
    case 2:
      if (dialog_inputbox("nPpaSet: Advanced: Fine tunning", "Y color offset", HEIGHT, WIDTH, yycc, 0) == 0){
	if (dialog_input_result[0] == 0){
	  // Do nothing. Let the old value	  
	} else {
	  settings.yOffsetColor = atoi(dialog_input_result);
	}
      }
      break;
    case 3:
      if (dialog_inputbox("nPpaSet: Advanced: Fine tunning", "Blackness(0-4)", HEIGHT, WIDTH, bb, 0) == 0){
	if (dialog_input_result[0] == 0){
	  // Do nothing. Let the old value	  
	} else {
	  settings.blackness = atoi(dialog_input_result);
	  if (settings.blackness < 0){
	    settings.blackness = 0;
	  }
	  if (settings.blackness > 4){
	    settings.blackness = 4;
	  }
	}
      }
      break;
    default:
      // Do nothing... we mustn't reach here
      break;
    }
  }
}

void gammaAdvancedGUI(){
  char *gammaAdvancedRadio[15] = {
    "1", "System defaults", "off",
    "2", "None", "off",
    "3", "RGB correction (enhancements)", "off",
    "4", "RGB correction (indexes)", "off",
    "5", "RGB correction (file)", "off",
  };
  int err;
  char *on = "on";
  char option[2]; // The number and the ending 0
  char defaultInput[MAX_LEN];

  switch (settings.gammaMode) {
  case GAMMA_DEFAULT:
    gammaAdvancedRadio[2] = on;
    break;
  case GAMMA_NONE:
    gammaAdvancedRadio[5] = on;
    break;
  case GAMMA_ENH:
    gammaAdvancedRadio[8] = on;
    break;
  case GAMMA_INDEX:
    gammaAdvancedRadio[11] = on;
    break;
  case GAMMA_FILE:
    gammaAdvancedRadio[14] = on;
    break;
  default:
    gammaAdvancedRadio[8] = on;
    break;
  }

  err = dialog_checklist("nPpaSet: Advanced: Gamma", "Select a gamma mode", HEIGHT, WIDTH, 5, 5, (char**)gammaAdvancedRadio, FALSE, TRUE, option);
  if (err < 0){
    // ESC, ^C or Cancel were used
  } else {
    switch (option[0]){
    case '1':
      settings.gammaMode = GAMMA_DEFAULT;
      break;
    case '2':
      settings.gammaMode = GAMMA_NONE;
      break;
    case '3':
      settings.gammaMode = GAMMA_ENH;
      sprintf(defaultInput, "%f", settings.gammaEnhR);
      if (dialog_inputbox("nPpaSet: Advanced: Gamma (enhancements)", "Red enhancement", HEIGHT, WIDTH, defaultInput, 0) == 0){
	if (dialog_input_result[0] == 0){
	  // Do nothing. Let the old value	  
	} else {
	  settings.gammaEnhR = atof(dialog_input_result);
	}
      }
      sprintf(defaultInput, "%f", settings.gammaEnhG);
      if (dialog_inputbox("nPpaSet: Advanced: Gamma (enhancements)", "Green enhancement", HEIGHT, WIDTH, defaultInput, 0) == 0){
	if (dialog_input_result[0] == 0){
	  // Do nothing. Let the old value	  
	} else {
	  settings.gammaEnhG = atof(dialog_input_result);
	}
      }
      sprintf(defaultInput, "%f", settings.gammaEnhB);
      if (dialog_inputbox("nPpaSet: Advanced: Gamma (enhancements)", "Blue enhancement", HEIGHT, WIDTH, defaultInput, 0) == 0){
	if (dialog_input_result[0] == 0){
	  // Do nothing. Let the old value	  
	} else {
	  settings.gammaEnhB = atof(dialog_input_result);
	}
      }
      break;
    case '4':
      settings.gammaMode = GAMMA_INDEX;
      sprintf(defaultInput, "%i", settings.gammaIndexR);
      if (dialog_inputbox("nPpaSet: Advanced: Gamma (indexes)", "Red index", HEIGHT, WIDTH, defaultInput, 0) == 0){
	if (dialog_input_result[0] == 0){
	  // Do nothing. Let the old value	  
	} else {
	  settings.gammaIndexR = atoi(dialog_input_result);
	}
      }
      sprintf(defaultInput, "%i", settings.gammaIndexG);
      if (dialog_inputbox("nPpaSet: Advanced: Gamma (indexes)", "Green index", HEIGHT, WIDTH, defaultInput, 0) == 0){
	if (dialog_input_result[0] == 0){
	  // Do nothing. Let the old value	  
	} else {
	  settings.gammaIndexG = atoi(dialog_input_result);
	}
      }
      sprintf(defaultInput, "%i", settings.gammaIndexB);
      if (dialog_inputbox("nPpaSet: Advanced: Gamma (indexes)", "Blue index", HEIGHT, WIDTH, defaultInput, 0) == 0){
	if (dialog_input_result[0] == 0){
	  // Do nothing. Let the old value	  
	} else {
	  settings.gammaIndexB = atoi(dialog_input_result);
	}
      }
      break;
    case '5':
      settings.gammaMode = GAMMA_FILE;
      sprintf(defaultInput, "%s", settings.gammaFile);
      if (dialog_inputbox("nPpaSet: Advanced: Gamma (file)", "Gamma correction file", HEIGHT, WIDTH, defaultInput, 0) == 0){
	if (dialog_input_result[0] == 0){
	  // Do nothing. Let the old value	  
	} else {
	  strcpy(settings.gammaFile, dialog_input_result);
	}
      }
      break;
    default:
      settings.gammaMode = GAMMA_DEFAULT;
      break;
    }
  }
  return;

}

void advancedGUI(){
  const char *advancedMenu[4] = {
    "1", "Fine tunning",
    "2", "Gamma correction",
  };
  int option = 0;

  option = dialog_menu("nPppaSet: Advanced", "Select a group", HEIGHT, WIDTH, 2, 2,(char**)advancedMenu);
  if (option < 0){ // ESC, ^C or Cancel were used
    return;
  } else {
    switch (option) {
    case 0:
      fineAdvancedGUI();
      break;
    case 1:
      gammaAdvancedGUI();
      break;
    default:
	break;
    }
  }
}

void servicesGUI(){
  const char *basicMenu[12] = {
    "1", "Print a test page",
    "2", "Create a /tmp/pnm2ppa.conf file",
    "3", "Print calibration pages", 
    "4", "Create gamma reference file (/tmp/gamma.ppm)",
    "5", "Print a non-gamma-corrected page",
    "6", "Clean printer cartridges"
  };
  int option = 0;

  option = dialog_menu("nPppaSet: Services", "Select a service", HEIGHT, WIDTH, 6, 6,(char**)basicMenu);
  if (option < 0){ // ESC, ^C or Cancel were used
    return;
  } else {
    switch (option) {
    case 0:
      if (printTestPage(settings) == -1){
	fprintf(stderr, "nPpaSet: error printing test page\n");
      }
      break;
    case 1:
      if (createPnm2ppa_conf(settings) == 1){
	fprintf(stderr, "nPpaSet: error creating /tmp/pnm2ppa.conf\n");
      }
      break;
    case 2:
      if (printCalibrationPages(settings) == -1){
	fprintf(stderr, "nPpaSet: error printing calibration pages\n");
      }
      break;
    case 3:
      if (createGammaRef() == -1){
	fprintf(stderr, "nPpaSet: error creating gamma reference file\n");
      }
      break;
    case 4:
      if (printNoGamma(settings) == -1){
	fprintf(stderr, "nPpaSet: error printing non-gamma-corrected page\n");
      }
      break;
    case 5:
      if (cleanHeads(settings) == -1){
	fprintf(stderr, "nPpaSet: error cleaning cartridge heads\n");
      }
    default:
	break;
    }
  }
}

/* Well... it's not a GUI but... */
void mainGUI(){
  const char *mainMenu[20] = {
    "1", "Basic",
    "2", "Paper options",
    "3", "Advanced",
    "4", "Services",
    " ", " ",
    "5", "Save & exit",
    "6", "Aply once",
    "7", "System defaults",
    "8", "Remove",
    "9", "Help"
  };
  int option = 0;

  while (1){ // We'll use return
    option = dialog_menu("nPppaSet", "Select an option", HEIGHT, WIDTH, 10, 10,(char**)mainMenu);
    if (option < 0){ // ESC, ^C or Cancel were used
      return;
    } else {
      switch (option) {
      case 0: // Basic
	basicGUI();
	break;
      case 1: // Paper options
	paperGUI();
	break;
      case 2: // Advanced
	advancedGUI();
	break;
      case 3: // Services
	servicesGUI();
	break;
      case 4: // *******
	// Do nothing
	break;
      case 5: // Save & exit
	if (createPpaSetRC(settings) == -1){
	  fprintf(stderr, "nPpaSet: couldn't create .ppaSetRC* files at HOME\n");
	}
	return;
	break;
      case 6: // Aply once
	if (createPpaSet1RC(settings) == -1) {
	  fprintf(stderr, "nPpaSet: couldn't create .ppaSet1RC* files at HOME\n");
	}
	break;
      case 7: // System defaults
	getSystemDefaults(&settings);
	break;
      case 8: // Remove
	removePpaSetRC();
	break;
      case 9: // Help
	if (showHelp() == -1){
	  fprintf(stderr, "nPpaSet: error showing help\n");
	}
	break;
      default:
	// Do nothing... we mustn't reach here
	break;
      }
    }
  }
}


main(int argc, char *argv[]) {
  int confReaded = 0;

  init_dialog();

  /* Copied from dialog.c
     I know it's used to make lock (otherway, it doesn't work fine), but I haven't
     tried to understand the code ;-)
  */
  if ((lock_refresh = make_lock_filename("/tmp/.lock_fileXXXXXX")) == NULL ||
      (lock_tailbg_refreshed = make_lock_filename("/tmp/.lock_tailbgXXXXXX")) == NULL ||
      (lock_tailbg_exit = make_lock_filename("/tmp/.lock_exitXXXXXX")) == NULL)
    exiterr("\nInternal error: can't make lock files.\n");


  
  confReaded = getPpaSetRC(&settings);
  if (confReaded == 1) {
    // Files doesn't exists, so read system defaults
    if (getSystemDefaults(&settings) == -1){
      fprintf(stderr, "Couldn't read system default configuration\n");
      exit(-1);
    }
  } else if (confReaded == 0) {
    // Sucesfully readed.
    // Do nothing
  } else {
    // Error
    fprintf(stderr, "Couldn't read config files in HOME\n");
    exit(-1);
  }
  
  mainGUI();

  end_dialog();
}

