###################################################
##                                               ##
##          'Q'DVD-Author project file           ##
##                                               ##
##             Created using Kate by             ##
##                                               ##
##                   Varol Okan                  ##
##                                               ##
##                  December 2003                ##
##                                               ##
###################################################

unix {
  UI_DIR = .ui
  MOC_DIR = .moc
  OBJECTS_DIR = .obj
}

# Now we parse the env varaible IMAGE_LIB (set in the configurator GUI)
HAS_PLAYER_SUPPORT = false
HAS_MPLAYER_SUPPORT = $$(WITH_MPLAYER_SUPPORT)
HAS_XINE_SUPPORT = $$(WITH_XINE_SUPPORT)
HAS_VLC_SUPPORT = $$(WITH_VLC_SUPPORT)
WHICH_QT_LIB = $$(QT_LIB)
WHICH_PREFIX = $$(PREFIX)
WHICH_DEBUG = $$(DEBUG_QDVDAUTHOR)
INCLUDEPATH = $$(ADD_INCLUDEDIR)

# Sanity check if at least one library is set ...
isEmpty(HAS_MPLAYER_SUPPORT) {
	isEmpty(HAS_XINE_SUPPORT) {
		isEmpty(HAS_VLC_SUPPORT) {
			exists (../bin/configurator)	{
				system (../bin/configurator &)
			} else {
				system (cd ..; ./configure &)
			}
			error ( "Please use configurator or set all neccesary environment variables before calling qmake" )
		}
	}
}
isEmpty(WHICH_PREFIX)	{
	WHICH_PREFIX = /usr
}
# Here we create CONFIG.h according to the set-up ...
system (echo -e "\043ifndef CONFIG_H" | sed s/-e\ // > CONFIG.h )
system (echo -e "\043define CONFIG_H" | sed s/-e\ // >> CONFIG.h )
system (echo -e "\043define PREFIX_DIRECTORY \"$$WHICH_PREFIX\"" | sed s/-e\ // >> CONFIG.h )
system (echo -e "\043endif // CONFIG_H" | sed s/-e\ // >> CONFIG.h )

# Next we create the MEDIA_CONFIG.h - file
system (echo -e "\043ifndef MEDIA_CONFIG_H" | sed s/-e\ // > qplayer/MEDIA_CONFIG.h )
system (echo -e "\043define MEDIA_CONFIG_H" | sed s/-e\ // >> qplayer/MEDIA_CONFIG.h )
contains ( HAS_MPLAYER_SUPPORT, 1 ) { 
	system (echo -e "\043define MPLAYER_SUPPORT $$(WITH_MPLAYER_SUPPORT)" | sed s/-e\ // >> qplayer/MEDIA_CONFIG.h ) 
}
contains ( HAS_XINE_SUPPORT, 1 )    { 
	system (echo -e "\043define XINE_SUPPORT  $$(WITH_XINE_SUPPORT)" | sed s/-e\ // >> qplayer/MEDIA_CONFIG.h ) 
}
contains ( HAS_VLC_SUPPORT, 1 )     { 
	system (echo -e "\043define VLC_SUPPORT  $$(WITH_VLC_SUPPORT)" | sed s/-e\ // >> qplayer/MEDIA_CONFIG.h ) 
}
system (echo -e "\043endif // MEDIA_CONFIG_H" | sed s/-e\ // >> qplayer/MEDIA_CONFIG.h )

SOURCES	+= main.cpp\
	log.cpp \
	utils.cpp\
	global.cpp\
	execute.cpp\
	dvdmenu.cpp \
	keyword.cpp  \
	dialogman.cpp \
	modifiers.cpp  \
	importsrt.cpp   \
	exportsrt.cpp    \
	subtitles.cpp     \
	importsub.cpp      \
	dialogfont.cpp      \
	qdvdauthor.cpp       \
	undobuffer.cpp\
	menuobject.cpp \
	textobject.cpp  \
	dialogtemp.cpp   \
	importkino.cpp    \
	messagebox.cpp	   \
	dialogaudio.cpp     \
	dialogmovie.cpp      \
	frameobject.cpp       \
	imageobject.cpp        \
	movieobject.cpp         \
	dialogframe.cpp\
	menupreview.cpp \
	dialogsetup.cpp  \
	dialogalign.cpp   \
	dialogimage2.cpp   \
	dialogshadow.cpp    \
	subtitlesgui.cpp     \
	buttonobject.cpp      \
	dialogbutton.cpp       \
	qimagehelper.cpp        \
	shadowobject.cpp         \
	colortoolbar.cpp          \
	layoutwizard.cpp           \
	kimageeffect.cpp\
	dialogconvert.cpp\
	errormessages.cpp \
	listviewmedia.cpp  \
	sourcetoolbar.cpp   \
	buttonpreview.cpp    \
	xml_dvdauthor.cpp     \
	dialogexecute.cpp      \
	dialoglibrary.cpp       \
	templatewizard.cpp       \
	dialogtextfont.cpp        \
	qdvdauthorinit.cpp         \
	dialogthumbnail.cpp         \
	selectionobject.cpp\
	dialogmediainfo.cpp \
	dialoganimation.cpp  \
	dialogundostack.cpp   \
	sourcefileentry.cpp    \
	importdvdauthor.cpp     \
	exportdvdauthor.cpp      \
	smalldialogaudio.cpp      \
	objectcollection.cpp       \
	structuretoolbar.cpp        \
	templatedownload.cpp         \
	dvdmenuundoobject.cpp         \
	filepreviewdialog.cpp \
	listviewitemmedia.cpp  \
	dragndropcontainer.cpp  \
	animationattribute.cpp   \
	dialogcommandeditor.cpp   \
	dialogcreatetemplate.cpp   \
	qrender/startmenurender.cpp \
	qplayer/mediainfo.cpp        \
	qplayer/mediacreator.cpp      \
	qplayer/mediascanner.cpp       \
	qplayer/sourcefiledialog.cpp    \
	qplayer/startstopcontrol.cpp     \
	qplayer/listviewfileitem.cpp      \
	qplayer/engines/dummywidget.cpp    \
	qplayer/engines/mediainterface.cpp  \
	qslideshow/soundline.cpp\
	qslideshow/imageline.cpp \
	qslideshow/slidertime.cpp \
	qslideshow/filterline.cpp  \
	qslideshow/dialogfilter.cpp \
	qslideshow/dialogcreate.cpp  \
	qslideshow/imagepreview.cpp   \
	qslideshow/xml_slideshow.cpp   \
	plugins/menuslide/menuslide.cpp

HEADERS	+= ../bugs_workaround.h \
	log.h \
	utils.h\
	global.h\
	xml_dvd.h\
	execute.h \
	dvdmenu.h  \
	keyword.h   \
	dialogman.h  \
	modifiers.h   \
	importsrt.h    \
	exportsrt.h     \
	subtitles.h      \
	importsub.h       \
	dialogfont.h       \
	qdvdauthor.h        \
	undobuffer.h         \
	importkino.h          \
	menuobject.h\
	textobject.h \
	dialogtemp.h  \
	messagebox.h   \
	dialogaudio.h   \
	dialogmovie.h    \
	frameobject.h     \
	imageobject.h      \
	movieobject.h       \
	dialogframe.h        \
	menupreview.h         \
	dialogsetup.h          \
	dialogalign.h           \
	subtitlesgui.h           \
	buttonobject.h\
	dialogbutton.h \
	qimagehelper.h  \
	shadowobject.h   \
	colortoolbar.h    \
	layoutwizard.h     \
	kimageeffect.h      \
	dialogshadow.h       \
	dialogimage2.h\
	errormessages.h\
	sourcetoolbar.h \
	buttonpreview.h  \
	listviewmedia.h   \
	xml_dvdauthor.h    \
	dialogexecute.h     \
	dialogconvert.h      \
	dialoglibrary.h       \
	dialogtextfont.h       \
	qdvdauthorinit.h        \
	templatewizard.h\
	dialogundostack.h\
	sourcefileentry.h \
	importdvdauthor.h  \
	exportdvdauthor.h   \
	dialoganimation.h    \
	selectionobject.h     \
	dialogmediainfo.h      \
	dialogthumbnail.h       \
	smalldialogaudio.h       \
	objectcollection.h        \
	structuretoolbar.h         \
	templatedownload.h\
	dvdmenuundoobject.h\
	listviewitemmedia.h \
	filepreviewdialog.h  \
	dragndropcontainer.h  \
	animationattribute.h   \
	dialogcommandeditor.h   \
	dialogcreatetemplate.h   \
	plugins/interface.h       \
	qrender/startmenurender.h  \
	qplayer/mediainfo.h         \
	qplayer/mediacreator.h       \
	qplayer/mediascanner.h        \
	qplayer/qplayer_global.h       \
	qplayer/sourcefiledialog.h      \
	qplayer/startstopcontrol.h       \
	qplayer/listviewfileitem.h        \
	qplayer/engines/dummywidget.h      \
	qplayer/engines/mediainterface.h    \
	qslideshow/soundline.h \
	qslideshow/imageline.h  \
	qslideshow/slidertime.h  \
	qslideshow/filterline.h   \
	qslideshow/dialogfilter.h  \
	qslideshow/dialogcreate.h   \
	qslideshow/imagepreview.h    \
	qslideshow/xml_slideshow.h \
	plugins/menuslide/menuslide.h

LIB_EXTRA=
# Next we take care of the media backend dependencies
contains ( HAS_XINE_SUPPORT, 1 )	{
	HAS_PLAYER_SUPPORT=true
	message ("Build with Xine Support")
	LIB_EXTRA += xine-config --cflags --libs 
	SOURCES	+=	qplayer/engines/xineinfo.cpp \
			qplayer/engines/xinewidget.cpp\
			qplayer/engines/kxinewidget.cpp\
			qplayer/engines/qxinewidget.cpp \
			qplayer/engines/kaffeineswidget.cpp
	HEADERS	+=	qplayer/engines/xineinfo.h \
			qplayer/engines/xinewidget.h\
			qplayer/engines/kxinewidget.h\
			qplayer/engines/qxinewidget.h \
			qplayer/engines/kaffeineswidget.h
	FORMS	+=	qplayer/engines/dialogqxinesetup.ui

}
contains( HAS_VLC_SUPPORT, 1) {
	HAS_PLAYER_SUPPORT=true
	message ("Build with VLC support")
	LIBS += -lvlc
	! isEmpty (LIB_EXTRA)	{
		LIB_EXTRA += &&
	}
	LIB_EXTRA += vlc-config --cxxflags --libs
	LIBS +=-L/usr/local/lib/vlc -lvlc -ldl -lavcodec -lavformat -lvlc -lmemcpymmx -li420_rgb_mmx -li422_yuy2_mmx -li420_ymga_mmx -li420_yuy2_mmx -lmemcpymmxext -lmemcpy3dn -lffmpeg -lstream_out_switcher -lpthread -lxvideo -lX11 -lXaw -lXv -lXinerama
	SOURCES	+=	qplayer/engines/vlcinfo.cpp \
			qplayer/engines/qvlcwidget.cpp \
			qplayer/engines/vlcwidget.cpp
	HEADERS	+=	qplayer/engines/vlcinfo.h \
			qplayer/engines/qvlcwidget.h \
			qplayer/engines/vlcwidget.h
}
contains( HAS_MPLAYER_SUPPORT, 1) {
	HAS_PLAYER_SUPPORT=true
	message ("Build with MPlayer support")
	# Note : mplayer has no library. Thus we don't need to add dependencies here.
	SOURCES +=	qplayer/engines/mplayerinfo.cpp  \
			qplayer/engines/mplayerwidget.cpp \
			qplayer/engines/qmplayerwidget.cpp \
			qplayer/engines/dialogmplayersetup.cpp
	HEADERS +=	qplayer/engines/xml_mplayer.h \
			qplayer/engines/mplayerinfo.h  \
			qplayer/engines/mplayerwidget.h \
			qplayer/engines/qmplayerwidget.h \
			qplayer/engines/dialogmplayersetup.h
	FORMS   +=	qplayer/engines/uidialogmplayersetup.ui
}
#Finally we check if at least one player engine has been enabled
contains( HAS_PLAYER_SUPPORT, false )	{
	message("You need to at least specify one media player engine. I will default to MPlayer (non-lib based)")
	SOURCES +=	qplayer/engines/mplayerinfo.cpp  \
			qplayer/engines/mplayerwidget.cpp \
			qplayer/engines/qmplayerwidget.cpp \
			qplayer/engines/dialogmplayersetup.cpp
	HEADERS +=	qplayer/engines/xml_mplayer.h \
			qplayer/engines/mplayerinfo.h  \
			qplayer/engines/mplayerwidget.h \
			qplayer/engines/qmplayerwidget.h \
			qplayer/engines/dialogmplayersetup.h
	FORMS   +=	qplayer/engines/uidialogmplayersetup.ui
}
# Add the ending quote.
LIBS += `$${LIB_EXTRA}`

DISTFILES = CONFIG.h \
	../TODO  \
	../README \
	../INSTALL \
	../COPYING  \
	../CHANGELOG \
	../clean.sh   \
	../configure   \
	../silence.mp2  \
	../doc/html/en/system_register.html \
	../doc/html/en/audio_streams.html

FORMS	+= formmain.ui       \
	qslideshow/dialogslide.ui \
	qslideshow/dialogimage.ui  \
	qslideshow/uidialogcreate.ui\
	qplayer/uisourcefiledialog.ui\
	qplayer/uistartstopcontrol.ui \
	uidialogsubtitle.ui \
	uitemptab.ui \
	uisubtitles.ui\
	uinewwizard.ui \
	uidialogfont.ui \
	dialogmatrix.ui\
	dialogresize.ui \
	uidialogimage.ui \
	uidialogmovie.ui  \
	uidialogabout.ui   \
	uidialogsetup.ui    \
	uidialogframe.ui     \
	uidialogaudio.ui      \
	uidialogalign.ui\
	uidialogshadow.ui\
	dialoggeometry.ui \
	uidialogbutton.ui  \
	uisourcewidget.ui   \
	uidialoglibrary.ui   \
	uicommandeditor.ui    \
	uidialogconvert.ui     \
	uicreatetemplate.ui     \
	uidialogtextfont.ui      \
	uitemplatewizard.ui\
	uidialogthumbnail.ui\
	uidialoganimation.ui \
	uistructurewidget.ui  \
	uidialogmediainfo.ui   \
	uitemplatedownload.ui   \
	uidialogextraction.ui    \
	uidialogrenderpreview.ui  \
	plugins/menuslide/uimenuslide.ui


IMAGES	= ./images/open.png ./images/new.png images/save.png images/redo images/undo images/editcut \
	images/save_as.png images/editcopy images/editpaste images/searchfind images/to_dvd2.png images/to_dvd.png \
	images/text_ccenter.png images/text_center.png images/text_cfit.png images/text_cjustify.png \
	images/text_cleft.png images/text_cright.png images/text_cstrikeout.png images/text_cunderline.png \
	images/text_cvcenter.png images/text_fit.png images/text_justify.png images/text_left.png \
	images/text_right.png images/text_strikeout.png images/text_underline.png images/text_vcenter.png \
	images/checkered.png images/add_audio.png images/add_image.png images/exit.png images/splash.jpg \
	images/sound_file.jpg images/please_wait.jpg images/error.jpg images/button_play.png images/button_cplay.png \
	images/button_stop.png images/button_cstop.png images/button_back.png images/button_cback.png \
	images/create_slideshow.jpg images/move_cursor.png images/stretch_lr_cursor.png images/stretch_ud_cursor.png \
	images/add_slideshow.png images/add_menuslide.png

# here we include the images from qplayer. needs to be done ...
IMAGES	+=	qplayer/images/desktop.png qplayer/images/documents.png qplayer/images/home.png qplayer/images/project.png \
		qplayer/images/root.png qplayer/images/babytux.png qplayer/images/play.png qplayer/images/pause.png \
		qplayer/images/temp.png qplayer/images/prev_chapter.png qplayer/images/next_chapter.png qplayer/images/play.png \
		qplayer/images/stop.png qplayer/images/faster.png qplayer/images/slower.png

contains( WHICH_QT_LIB, qt) {
	contains( WHICH_QT_LIB, qt-mt) {
		CONFIG += qt-mt
	}
		CONFIG += qt
}

isEmpty(WHICH_PREFIX) {
	WHICH_PREFIX +=/usr
}

# Here we handle the language file generation
!exists (./i18n/qdvdauthor_de.qm)	{
	LRELEASE=$$(QTDIR)/bin/lrelease
	!exists ( $${LRELEASE} ) {
		LRELEASE=lrelease
	}
	system ( $${LRELEASE} qdvdauthor.pro )
}

prefix.path = $${WHICH_PREFIX}/bin
prefix.files = ../bin/qdvdauthor

i18n.path = $${WHICH_PREFIX}/share/qdvdauthor
i18n.files = ./i18n/qdvdauthor_*.qm
#i18n.extra = $${LRELEASE} qdvdauthor.pro

help.path = $${WHICH_PREFIX}/share/qdvdauthor/html/en
help.files = ../doc/html/en/*.html

distrib.path = $${WHICH_PREFIX}/share/qdvdauthor
distrib.files = ../silence.mp2

# here we set the default type ...
isEmpty(WHICH_DEBUG)	{
	WHICH_DEBUG=release
}

TRANSLATIONS    = i18n/qdvdauthor_de.ts \
                  i18n/qdvdauthor_es.ts \
                  i18n/qdvdauthor_fr.ts \
                  i18n/qdvdauthor_pl.ts \
                  i18n/qdvdauthor_eo.ts \
                  i18n/qdvdauthor_it.ts

LIBS                   +=$$(LDFLAGS)
INSTALLS                = prefix i18n help distrib
DESTDIR	                =../bin
TEMPLATE                = app
CONFIG	               += thread warn_on $${WHICH_DEBUG}
QMAKE_CXXFLAGS_WARN_ON += -Wno-non-virtual-dtor
VERSION		     	    = 0.1.4
LANGUAGE                = C++


