/* 
 * Copyright (C) 2005  Network Applied Communication Laboratory Co., Ltd.
 *
 * This file is part of Rast.
 * See the file COPYING for redistribution information.
 *
 */

#ifndef RAST_PROPERTY_H
#define RAST_PROPERTY_H

/**
 * @file property.h property
 */

#include "rast/types.h"
#include "rast/macros.h"

RAST_EXTERN_C_BEGIN

/**
 * @defgroup property property
 * @{
 */

/** A structure that represents a property definition */
typedef struct {
    /** The name of the property */
    char *name;
    /** The type of the property */
    rast_type_e type;
    /**
     * The flags of the property
     *   - RAST_PROPERTY_FLAG_SEARCH
     *     - search by =,<,<=,>,>=
     *   - RAST_PROPERTY_FLAG_TEXT_SEARCH
     *     - search by :
     *   - RAST_PROPERTY_FLAG_FULL_TEXT_SEARCH
     *     - include to the index for full-text search
     *   - RAST_PROPERTY_FLAG_UNIQUE
     *     - property value should be unique
     *   - RAST_PROPERTY_FLAG_OMIT
     *     - not store property value
     */
    rast_uint_t flags;
} rast_property_t;

#define RAST_PROPERTY_FLAG_SEARCH           0x0001
#define RAST_PROPERTY_FLAG_TEXT_SEARCH      0x0002
#define RAST_PROPERTY_FLAG_FULL_TEXT_SEARCH 0x0004
#define RAST_PROPERTY_FLAG_UNIQUE           0x0008
#define RAST_PROPERTY_FLAG_OMIT             0x0010

/** @} */

RAST_EXTERN_C_END

#endif

/* vim: set filetype=c sw=4 expandtab : */
