dnl AM_PATH_DB([MAJOR], [MINOR], [PATCH])
dnl Adds support for Berkeley DB
AC_DEFUN([AM_PATH_DB],
[
  rast_lib_db_cppflags_orig="$CPPFLAGS"
  rast_lib_db_libs_orig="$LIBS"

  rast_lib_db_major="$1"
  rast_lib_db_minor="$2"
  rast_lib_db_patch="$3"
  rast_lib_db_version="$1.$2.$3"

  AC_ARG_WITH(db-includes,
  AC_HELP_STRING([--with-db-includes=ARG],
                 [include information for Berkeley DB]),
  [
    AC_MSG_RESULT(using $withval to include db.h)
    DB_INCLUDES="$withval"
  ])

  AC_ARG_WITH(db-libs,
  AC_HELP_STRING([--with-db-libs=ARG],
                 [libraries for Berkeley DB]),
  [
    AC_MSG_RESULT(using $withval to link Berkekeley DB)
    DB_LIBS="$withval"
  ])

  AC_SUBST(DB_INCLUDES)
  CPPFLAGS="$DB_INCLUDES $CPPFLAGS"

  if test -z "$DB_LIBS"; then
    AC_CHECK_LIB(db-4, main, [DB_LIBS=-ldb-4],
    [
      AC_CHECK_LIB(db4, main, [DB_LIBS=-ldb4],
      [
        AC_CHECK_LIB(db, main, [DB_LIBS=-ldb],
        [
          AC_MSG_ERROR(libdb not found)
        ])
      ])
    ])
  fi

  AC_SUBST(DB_LIBS)
  LIBS="$DB_LIBS $LIBS"

  AC_MSG_CHECKING([Berkeley DB version])
  AC_TRY_RUN(
  [
#include <db.h>

int
main()
{
    int major, minor, patch;

    db_version(&major, &minor, &patch);
    if (major != DB_VERSION_MAJOR ||
        minor != DB_VERSION_MINOR ||
        patch != DB_VERSION_PATCH) {
      return 1;
    }
    if (major < $rast_lib_db_major) {
      return 1;
    }
    if (major > $rast_lib_db_major) {
      return 0;
    }
    if (minor < $rast_lib_db_minor) {
      return 1;
    }
    if (minor > $rast_lib_db_minor) {
      return 0;
    }
    if (patch < $rast_lib_db_patch) {
      return 1;
    }
    return 0;
}
  ],
  [
    AC_MSG_RESULT([ok])
  ],
  [
    AC_MSG_ERROR([$rast_lib_db_version is required])
  ],
  [
    AC_MSG_RESULT([ok])
  ])

  CPPFLAGS="$rast_lib_db_cppflags_orig"
  LIBS="$rast_lib_db_libs_orig"
])
