%{!?python_sitelib: %define python_sitelib %(python -c "from distutils.sysconfig import get_python_lib; print get_python_lib()")}

Summary: Fedora "Spin" Graphical User Interface
Name: revisor
Version: 2.0.4.0
Release: 1%{?dist}
License: GPL
Group: Applications/System
URL: https://hosted.fedoraproject.org/projects/revisor
Source0: http://files.revisor.fedoraunity.org/%{name}-%{version}.tar.gz
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root
Requires: pygtk2 >= 2.9.2
Requires: pygtk2-libglade, yum >= 3, comps-extras, rhpl, system-config-kickstart
Requires: gnome-python2-gconf, notify-python, pungi, usermode, pam
Requires: squashfs-tools, anaconda-runtime, createrepo, busybox-anaconda, fedora-release >= 7
Requires: livecd-tools
BuildArch: noarch
ExcludeArch: ppc ppc64
BuildRequires: intltool, gettext, python, desktop-file-utils

%description
Revisor provides a set of graphical tools for building customized, updated
Fedora "Spins". This tool has been built around two other projects. First
is pungi, which builds the installation media. The other is livecd-tools,
which builds the live image.

#%package -n revisor-cobbler
#Summary:    Revisor Cobbler Integration
#Group:      Applications/System
#Requires:   cobbler, koan, revisor = %{version}-%{release}

#%description -n revisor-cobbler
#Revisor Integration with Cobbler for having Revisor do DHCP, PXE,
#Xen and KVM stuff.

#%package -n revisor-delta
#Summary:    Revisor Deltarpm Integration
#Group:      Applications/System
#Requires:   deltarpm, revisor = %{version}-%{release}

#%description -n revisor-delta
#Revisor Integration with deltarpm for generating delta ISO images.


%prep
%setup -q

%build
%configure
make

%install
rm -rf $RPM_BUILD_ROOT
make install DESTDIR=$RPM_BUILD_ROOT
desktop-file-install --vendor="fedora"              \
  --delete-original                                 \
  --dir=%{buildroot}%{_datadir}/applications        \
  %{buildroot}/%{_datadir}/applications/revisor.desktop

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root,-)
%doc README NEWS AUTHORS COPYING
%dir %{python_sitelib}/revisor
%{python_sitelib}/revisor/*.py
%{python_sitelib}/revisor/*.pyc
%{python_sitelib}/revisor/*.pyo
%{_bindir}/*
%{_sbindir}/*
%dir %{_sysconfdir}/revisor
%dir %{_sysconfdir}/revisor/conf.d
%config(noreplace) %{_sysconfdir}/revisor/comps-fc6.xml
%config(noreplace) %{_sysconfdir}/revisor/comps-f7.xml
%config(noreplace) %{_sysconfdir}/revisor/revisor.conf
%config(noreplace) %{_sysconfdir}/revisor/conf.d/*
%config(noreplace) %{_sysconfdir}/pam.d/*
%config(noreplace) %{_sysconfdir}/security/console.apps/*
%{_datadir}/applications/*.desktop
%{_datadir}/locale/*/LC_MESSAGES/revisor.mo
%dir %{_datadir}/revisor
%dir %{_datadir}/revisor/ui
%dir %{_datadir}/revisor/pixmaps
%{_datadir}/revisor/ui/*
%{_datadir}/revisor/pixmaps/*
%{_datadir}/pixmaps/*

#%files -n revisor-cobbler
#%defattr(-,root,root,-)
#%dir %{python_sitelib}/revisor/cobbler
#%{python_sitelib}/revisor/cobbler/*.py
#%{python_sitelib}/revisor/cobbler/*.pyc
#%{python_sitelib}/revisor/cobbler/*.pyo

#%files -n revisor-delta
#%defattr(-,root,root,-)
#%dir %{python_sitelib}/revisor/delta
#%{python_sitelib}/revisor/delta/*.py
#%{python_sitelib}/revisor/delta/*.pyc
#%{python_sitelib}/revisor/delta/*.pyo


%changelog
* Wed Jun 27 2007 Jonathan Steffan <jon a fedoraunity.org> 2.0.4.0-1
- Bugfixes from 2.0.3.x
- Start of all the new features of 2.0.4

* Sun Jun 24 2007 Jeroen van Meeuwen <kanarip a fedoraunity.org> 2.0.3.12-1
- Removed excludearchs ppc, ppc64 and added some logic to the spec file
  including a patch to disable livecd composure.
- Fixed bug in repository configuration
- Re-enabled CLI

* Sat Jun 23 2007 Jeroen van Meeuwen <kanarip a fedoraunity.org> 2.0.3.11-1
- Adding comps-f7 to our distribution
- Removing pungi configuration files
- Fixed a major bug in unlinking / unmounting the left-overs of a previous
  live media run.
- Enabled translation
- Added ExcludeArch: ppc, ppc64. Our dependency livecd-tools is not available
  for these archs.

* Sun Jun 17 2007 Jonathan Steffan <jon a fedoraunity.org> 2.0.3.10-1
- Final round of fixes for 2.0.3.x
- Added requirement for fedora-release >= 7

* Sun Jun 10 2007 Jeroen van Meeuwen <kanarip a fedoraunity.org> 2.0.3.9-1
- Bugfixes, more bugfixes

* Thu Jun 07 2007 Jonathan Steffan <jon a fedoraunity.org> 2.0.3.8-1
- Updated to 2.0.3.8
- More major bugfixes

* Tue Jun 05 2007 Jeroen van Meeuwen <kanarip a fedoraunity.org> 2.0.3.7-1
- Major bugfixes and speed improvements - tagging for reference purposes
- Added /etc/revisor/comps-fc6.xml as a %%config file

* Thu May 31 2007 Jonathan Steffan <jon a fedoraunity.org> 2.0.3.6-1
- Updated with all combined changes for release
- Fixed up configs
- Added fc6 comps data
- Bug fixes from LinuxTag

* Wed May 30 2007 Jeroen van Meeuwen <kanarip a fedoraunity.org> 2.0.3-1
- Repackage for release

* Thu May 24 2007 Jonathan Steffan <jon a fedoraunity.org> 2.0.2-3
- Added desktop-file-install and needed BR
- Updated for COPYING
- Updated revisor.desktop

* Thu May 17 2007 Jeroen van meeuwen <kanarip a fedoraunity.org> 2.0.2-2
- Rebuild

* Tue May 08 2007 Jeroen van Meeuwen <kanarip a fedoraunity.org> 2.0.2-1
- Final beta version for RH Summit 2007, San Diego

* Mon May 07 2007 Jeroen van Meeuwen <kanarip a fedoraunity.org> 2.0.1-5
- Fixed configuration files
- New files added

* Mon Apr 30 2007 Jonathan Steffan <jon a fedoraunity.org> 2.0.1-4
- Fixed symlink to consolehelper relative path instead of aboslute
  path in Makefile, rather then specfile
- Added missing s-c-kickstart dep
- Fixed shipped config files to be more targeted for end users

* Tue Apr 17 2007 Jef Spaleta <jspaleta@gmail.com> 2.0.1-3
- Specfile cleanup for fedora package submission review
- remove makeinstall macro
- add usermode and pam requires
- removed desktop-update-database scriptlets and associated deps

* Mon Apr 16 2007 Jeroen van Meeuwen <kanarip a fedoraunity.org> 2.0.1-2
- Corrected some file locations
- Build for F7

* Wed Apr 11 2007 Jonathan Steffan <jon a fedoraunity.org> 2.0.1-1
- Updated for the new revisor 2.x

* Sat Feb 17 2007 Jonathan Steffan <jon a fedoraunity.org> 1.0.2-1
- Updated config (in)sanity
- Added some configuration options

* Thu Feb 15 2007 Jonathan Steffan <jon a fedoraunity.org> 1.0.1-1
- Added a "Select All" button to help ease full distro Re-Spins

* Wed Feb 14 2007 Jonathan Steffan <jon a fedoraunity.org> 1.0-2
- Cleaned up code to include as little duplicate Pirut code as
  possible.
- Updated config file to default to mirrorlist

* Mon Feb 12 2007 Jonathan Steffan <jon a fedoraunity.org> 1.0-1
- Initial build based on pirutspin 1.0-1

