#
# Copyright 2007 Fedora Unity
#
# Jonathan Steffan <jon a fedoraunity.org>
# Jeroen van Meeuwen <kanarip a fedoraunity.org>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 2 only
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Library General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

import sys
import pykickstart
import tempfile
import time
import traceback
import subprocess
import shutil
import yum

from revisor import pilgrim
#from revisor import build_media
import revisor.progress
#from revisor import lm_install_callback
from revisor.errors import *

# Import constants
from revisor.constants import *

# Translation
from rhpl.translate import _, N_, getDefaultLangs
import rhpl.translate as translate

class LMOptical(pilgrim.InstallationTarget):
    def __init__(self, base):
        self.ayum = GnaGnaGna()
        self.gui = base.mode
        self.base = base
        self.log = base.log
        self.cfg = base.cfg

        if self.cfg.revisorUseGUI:
            import gtk
            import gtk.glade
            import gobject
            import gtk.gdk as gdk

        self.ksparser = {'handler': self.cfg.kshandler}
        self.skip_compression = False
        self.skip_prelink = False

    def installPackages(self, pbar = None):
        """install packages into target file system"""

        self.cfg.check_package_selection()

        self.runInstall(pbar = pbar)
        return True

    def transactionErrors(self, errs):
        self.log.error(_("""Error encountered during installation of the software you selected:

%s""") % (errs), recoverable = False)

    def runInstall(self, pbar = None):

        self.log.debug(_("Running package installation"))

        (res, resmsg) = self.cfg.yumobj.buildTransaction()
        if res != 2:
            msg = _("Unable to build transaction")
            for m in resmsg:
                msg = "%s %s" % (msg,m)
            self.log.error(msg)
        else:
            self.log.debug(_("Succesfully built transaction: ret %s, msg %s") % (res, ' '.join(resmsg)))

        self.gui.cfg.yumobj.ts.check()
        self.gui.cfg.yumobj.ts.order()

        if not pbar: pbar = self.base.progress_bar(_("Installing Software to Live Media"))

        if self.cfg.revisorUseGUI:
            tsprog = revisor.progress.TransactionProgressGUI(pbar, log = self.log)
        else:
            tsprog = revisor.progress.TransactionProgressCLI(pbar, log = self.log)

        del self.cfg.yumobj.ts
        self.cfg.yumobj.initActionTs() # make a new, blank ts to populate
        self.cfg.yumobj.populateTs(keepold=0)
        self.cfg.yumobj.ts.check() #required for ordering
        self.cfg.yumobj.ts.order() # order

        tsprog.tsInfo = self.cfg.yumobj.tsInfo

        try:
            tserrors = self.cfg.yumobj.runTransaction(tsprog)

        except yum.Errors.YumBaseError, err:
            self.log.debug("yum.Errors.YumBaseError: %s" % err)
            pbar.destroy()
            self.transactionErrors(err)

        except RevisorError, err:
            self.log.debug("RevisorError: %s" % err)
            pbar.destroy()
            self.transactionErrors(err)

        pbar.destroy()

    def configureSystem(self):
        instroot = "%s/install_root" %(self.build_dir,)

        # FIXME: this is a bit ugly, but with the current pykickstart
        # API, we don't really have a lot of choice.  it'd be nice to
        # be able to do something different, but so it goes

        # set up the language
        lang = self.cfg.kshandler.lang.lang or "en_US.UTF-8"
        self.log.debug(_("Setting language to: %s") % (lang))
        try: os.makedirs("%s/etc/sysconfig/" %(instroot,))
        except: pass
        f = open("%s/etc/sysconfig/i18n" %(instroot,), "w+")
        f.write("LANG=\"%s\"\n" %(lang,))
        f.close()

        # next, the keyboard
        # FIXME: should this impact the X keyboard config too???
        # or do we want to make X be able to do this mapping

        self.log.debug(_("Setting keyboard to: %s") % (self.cfg.kshandler.keyboard.keyboard))

        import rhpl.keyboard
        k = rhpl.keyboard.Keyboard()
        if self.cfg.kshandler.keyboard.keyboard:
            k.set(self.cfg.kshandler.keyboard.keyboard)
        k.write(instroot)

        # next up is timezone
        tz = self.cfg.kshandler.timezone.timezone or "America/New_York"
        utc = self.cfg.kshandler.timezone.isUtc

        self.log.debug(_("Setting timezone to: %s Using UTC: %s") % (tz, utc))

        f = open("%s/etc/sysconfig/clock" %(instroot,), "w+")
        f.write("ZONE=\"%s\"\n" %(tz,))
        f.write("UTC=%s\n" %(utc,))
        f.close()

        hostname = self.cfg.lm_hostname or "localhost.localdomain"
        # FIXME: we should handle network bits better

        self.log.debug(_("Setting hostname to: %s") % (hostname))

        f = open("%s/etc/sysconfig/network" %(instroot,), "w+")
        f.write("NETWORKING=yes\n")
        f.write("HOSTNAME=%s\n" %(hostname,))
        f.close()

        self.log.debug(_("Setting up default hosts file..."))

        f = open("%s/etc/hosts" %(instroot,), "w+")
        f.write("127.0.0.1\t\t%s  localhost\n" % (hostname))
        f.write("::1\t\tlocalhost6.localdomain6 localhost6\n")
        f.close()

        self.log.debug(_("Setting up authentication..."))

        # do any authconfig bits
        auth = self.cfg.kshandler.authconfig.authconfig or "--useshadow --enablemd5"
        if os.path.exists("%s/usr/sbin/authconfig" %(instroot,)):
            args = ["/usr/sbin/authconfig", "--update", "--nostart"]
            args.extend(auth.split())
            try:
                subprocess.call(args, preexec_fn=self.run_in_root)
            except:
                pass

            if "--useshadow" in args:
                self.log.debug(_("Running pwconv and grpconv"))
                subprocess.call("/usr/sbin/pwconv", preexec_fn=self.run_in_root)

        # firewall.  FIXME: should handle the rest of the options
        if self.cfg.kshandler.firewall.enabled and os.path.exists("%s/usr/sbin/lokkit" %(instroot,)):
            subprocess.call(["/usr/sbin/lokkit", "-f", "--quiet",
                             "--nostart", "--enabled"],
                            preexec_fn=self.run_in_root)

        # selinux
        f = open("%s/etc/sysconfig/selinux" %(instroot,), "w+")
        if self.cfg.kshandler.selinux.selinux == SELINUX_DISABLED:
            f.write("SELINUX=disabled")
        elif self.cfg.kshandler.selinux.selinux == SELINUX_ENABLED:
            f.write("SELINUX=enforcing")
        else:
            f.write("SELINUX=permissive")
        f.write("SELINUXTYPE=targeted")
        f.close()

# Root Password
        # Set the root password
        if self.cfg.kshandler.rootpw.isCrypted:
            subprocess.call(["/usr/sbin/usermod", "-p", self.cfg.kshandler.rootpw.password, "root"], preexec_fn=self.run_in_root)
        elif self.cfg.kshandler.rootpw.password == "":
            # Root password is not set and not crypted, empty it
            subprocess.call(["/usr/bin/passwd", "-d", "root"], preexec_fn=self.run_in_root)
        else:
            # Root password is set and not crypted
            p1 = subprocess.Popen(["/bin/echo", self.cfg.kshandler.rootpw.password], stdout=subprocess.PIPE, preexec_fn=self.run_in_root)
            p2 = subprocess.Popen(["/usr/bin/passwd", "--stdin", "root"], stdin=p1.stdout, stdout=subprocess.PIPE, preexec_fn=self.run_in_root)
            output = p2.communicate()[0]

# Live Media User Configuration
        if self.cfg.lm_user_configuration:
            subprocess.call(["/usr/sbin/useradd", "-c", self.cfg.lm_user_comment, self.cfg.lm_user_name], preexec_fn=self.run_in_root)
            p1 = subprocess.Popen(["/bin/echo", self.cfg.lm_user_password], stdout=PIPE, preexec_fn=self.run_in_root)
            p2 = subprocess.Popen(["/usr/bin/passwd", "--stdin", self.cfg.lm_user_name], stdin=p1.stdout, stdout=PIPE, preexec_fn=self.run_in_root)
            output = p2.communicate()[0]
            print output
            if self.cfg.lm_user_wheel:
                subprocess.call(["/usr/bin/gpasswd", "-a", self.cfg.lm_user_name, "wheel"], preexec_fn=self.run_in_root)
            if self.cfg.lm_wheel_sudo_no_passwd:
                subprocess.call(["/bin/sed", "-i", "-e", "s/^# %wheel.*ALL=(ALL).*NOPASSWD: ALL.*/%wheel ALL=(ALL) NOPASSWD: ALL/g", "/etc/sudoers"], preexec_fn=self.run_in_root)

            # Also have root's mail forwarded to this user
            subprocess.call(["/bin/sed", "-i", "-e", "s/^#root:.*marc.*/root: " + self.cfg.lm_user_name + "/g", "/etc/aliases"], preexec_fn=self.run_in_root)


        # enable/disable services appropriately
        if os.path.exists("%s/sbin/chkconfig" %(instroot,)):
            for s in self.cfg.kshandler.services.enabled:
                subprocess.call(["/sbin/chkconfig", s, "on"], preexec_fn=self.run_in_root)
            for s in self.cfg.kshandler.services.disabled:
                subprocess.call(["/sbin/chkconfig", s, "off"], preexec_fn=self.run_in_root)

        self.log.debug(_("Xorg is installed: %s") % (self.cfg.package_Xorg))
        # Init 5 if we have Xorg and it is enabled (Enabled Default: True; Installed Default: False)
        if self.cfg.kshandler.xconfig.startX and self.cfg.package_Xorg:
            f = open("%s/etc/inittab" %(instroot,), "rw+")
            buf = f.read()
            buf = buf.replace("id:3:initdefault", "id:5:initdefault")
            f.seek(0)
            f.write(buf)
            f.close()

        self.log.debug(_("Default desktop is %s") % (self.cfg.kshandler.xconfig.defaultdesktop))
        self.log.debug(_("Gnome is installed: %s") % (self.cfg.package_windowmanager_gnome))
        self.log.debug(_("KDE is installed: %s") % (self.cfg.package_windowmanager_kde))
        self.log.debug(_("XFCE is installed: %s") % (self.cfg.package_windowmanager_xfce))

        # Setup our default desktop
        if len(self.cfg.kshandler.xconfig.defaultdesktop) > 0:
            f = open("%s/etc/sysconfig/desktop" %(instroot,), "w")
            buf = "DESKTOP=%s\n" % (self.cfg.kshandler.xconfig.defaultdesktop)
            f.write(buf)
            f.close()
        else: # At least set something? (Default: GNOME)
            f = open("%s/etc/sysconfig/desktop" %(instroot,), "w")
            buf = "DESKTOP=GNOME\n"
            f.write(buf)
            f.close()

        # Setup Xorg.conf
        if self.cfg.package_Xorg:
            keyboard = "us"
            driver = "vesa"
            if len(self.cfg.kshandler.keyboard.keyboard) > 0: keyboard = self.cfg.kshandler.keyboard.keyboard
            if len(self.cfg.kshandler.xconfig.driver) > 0: driver = self.cfg.kshandler.xconfig.driver
            f = open("%s/etc/X11/xorg.conf" %(instroot,), "w")
            xorg_config = self.cfg.default_xorg_config % ("us", "vesa")
            f.write(xorg_config)
            f.close()

        # and now, for arbitrary %post scripts
        for s in filter(lambda s: s.type == pykickstart.parser.KS_SCRIPT_POST,
                        self.cfg.kshandler.scripts):
            # we can only safely run scripts in the chroot
            if not s.inChroot:
                self.log.error(_("Not running script outside of chroot"))
                continue

            (fd, path) = tempfile.mkstemp("", "ks-script-", "%s/tmp" %(instroot,))
            os.write(fd, s.script)
            os.close(fd)
            os.chmod(path, 0700)

            try:
                subprocess.call([s.interp, "/tmp/%s" %(os.path.basename(path),)],
                                preexec_fn = self.run_in_root)
            except OSError, (err, msg):
                os.unlink(path)
                raise InstallationError(_("Failed to execute %%post script with '%s' : %s") % (s.interp, msg))
            os.unlink(path)

    def createIso(self, callback):
        """write out the live CD ISO"""
        # Check if the destination directory is there
        if not os.access(os.path.join(self.cfg.destination_directory,"live"), os.R_OK):
            os.makedirs(os.path.join(self.cfg.destination_directory,"live"))

        self.callback = callback

        # Just disabled so I can actually do a screencast

#        self._doRunCommand(["/usr/bin/mkisofs", "-o", os.path.join(self.cfg.destination_directory,"live","%s.iso" % self.fs_label),
#                            "-b", "isolinux/isolinux.bin",
#                            "-c", "isolinux/boot.cat",
#                            "-no-emul-boot", "-boot-load-size", "4",
#                            "-boot-info-table", "-J", "-r", "-hide-rr-moved",
#                            "-V", "%s" % self.fs_label, "%s/out" % self.build_dir])

        subprocess.call(["/usr/bin/mkisofs", "-o", "%s.iso" % os.path.join(self.cfg.destination_directory,"live",self.fs_label),
                         "-b", "isolinux/isolinux.bin",
                         "-c", "isolinux/boot.cat",
                         "-no-emul-boot", "-boot-load-size", "4",
                         "-boot-info-table", "-J", "-r", "-hide-rr-moved",
                         "-V", "%s" % self.fs_label, "%s/out" % (self.build_dir)])

        # implant an isomd5sum
        if os.path.exists("/usr/lib/anaconda-runtime/implantisomd5"):
            subprocess.call(["/usr/lib/anaconda-runtime/implantisomd5",
                             "%s.iso" % os.path.join(self.cfg.destination_directory,"live",self.fs_label)])
        else:
            print >> sys.stderr, _("anaconda-runtime not installed; not setting up mediacheck")

    def createSquashFS(self, callback):
        """create compressed squashfs file system"""
        # FIXME: mksquashfs segfaults if PWD isn't set in the environment
        #self._doRunCommand(["/sbin/mksquashfs", "%s/data/os.img" % (self.build_dir), "%s/data/sysroot" % (self.build_dir),
        #                    "%s/out/squashfs.img" % (self.build_dir)],
        #                    inshell=True,
        #                    rundir="%s/data" % (self.build_dir),
        #                    env={"PWD": "%s/data" % (self.build_dir)})
        subprocess.call(["/sbin/mksquashfs", "os.img", "sysroot",
                             "../out/squashfs.img"],
#                             stdout=subprocess.PIPE,
#                             stderr=subprocess.STDOUT,
                             cwd="%s/data" %(self.build_dir,),
                             env={"PWD": "%s/data" %(self.build_dir,)})


    def _doRunCommand(self, command, rundir='/tmp', output=subprocess.PIPE, error=subprocess.STDOUT, inshell=False, env=None):
        """Run a command and log the output."""

        self.log.debug(_("Running command: %s") % ' '.join(command))
        self.log.debug(_("Extra information: %s %s %s") % (rundir, inshell, env))
        # I've get ERROR: Error - Unable to open file /srv/revisor/Live/livecd-20070615.iso if /srv/revisor/Live/livecd-20070615.iso
        # doesn't exist and I use this function
        workaround = True

        if output == subprocess.PIPE and not workaround:
            p1 = subprocess.Popen(command, cwd=rundir, stdout=output, stderr=error, shell=inshell, env=env)

            while p1.poll() == None:
                try:
                    returncode = int(p1.poll())
                except:
                    if output == subprocess.PIPE:
                        try:
                            line = p1.stdout.readline()
                            if not line == "":
                                callback.parse_line(command, line)
                        except:
                            pass
        else:
            p1 = subprocess.Popen(command, cwd=rundir, stdout=output, stderr=error)
            (out, err) = p1.communicate()

class GnaGnaGna:
    """A GnaGnaGna class laughs at you"""
    def __init__(self,*args):
        print "BWUHAHAHAHAHAHA"

    def setup(self, *args):
        print "BWUHAHAHAHAHAHA"
