require 'rubygems'
require 'date'

SPEC = Gem::Specification.new do |s|
  s.name              = 'ruby-postgres'
  s.rubyforge_project = 'ruby-postgres'
  s.version           = "0.7.1.#{Date.today}".tr('-', '.')
  s.summary           = 'Ruby extension library providing an API to PostgreSQL'
  s.author            = 'Yukihiro Matsumoto, Eiji Matsumoto, Noboru Saitou, Dave Lee'
  s.email             = 'davelee.com@gmail.com'
  s.homepage          = 'http://ruby.scripting.ca/postgres/'
  s.requirements      = 'PostgreSQL libpq library and headers'
  s.has_rdoc          = true
  s.require_path      = '.'
  s.autorequire       = 'postgres'

  if File.exists? 'postgres.so' and PLATFORM =~ /mingw|mswin/
    s.platform        = Gem::Platform::WIN32
  else
    s.platform        = Gem::Platform::RUBY
    s.extensions      = 'extconf.rb'
  end

  s.files             = Dir.chdir(File.exists?('_darcs') ? '_darcs/current' : '.') do
    Dir['**/*'].reject { |file| file =~ /\.gem$/ }
  end

end

if $0 == __FILE__
  Gem::manage_gems
  Gem::Builder.new(SPEC).build
end
