/* Copyright(C) 2004 Brazil

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include "sym.h"

#define NUL             '\0'
#define NL              '\n'

#define WITH_SIS

char buffer[65536];
char symbuf[8192];

#ifdef WITH_SIS
static int
sis_deletable(sen_id tid, void *arg)
{
  return 1;
}
#endif

void
doit(int argc, char **argv)
{
  int value;
  int i;
  sen_sym *sym;
  char *p, *p2;
  FILE *fp;
  char *filename;

  filename = argv[3];

  if (!(sym = sen_sym_open(filename))) {
#ifdef WITH_SIS
    sym = sen_sym_create(filename, 0, SEN_SYM_WITH_SIS, sen_enc_euc_jp);
#else /* WITH_SIS */
    sym = sen_sym_create(filename, 0, 0, sen_enc_euc_jp);
#endif
  }
  if (!sym) {
    puts("error...");
    return;
  }

  if (strcmp(argv[1], "get")) {
    fp = fopen(argv[2], "r");
    i = 1;
    while ((p = fgets(buffer, 65535, fp))) {
      for (p2 = p; *p2 && *p2 != NL; p2++);
      *p2 = NUL;
      value = sen_sym_get(sym, p);
#ifndef WITH_SIS
      if (i != value) {
        printf("put: %s: %d!=%d\n", p, i, value);
      }
#endif
      i++;
    }
    fclose(fp);
  }

  if (strcmp(argv[1], "put")) {
    fp = fopen(argv[2], "r");
    i = 1;
    while ((p = fgets(buffer, 65535, fp))) {
      for (p2 = p; *p2 && *p2 != NL; p2++);
      *p2 = NUL;
      value = sen_sym_at(sym, p);
#ifndef WITH_SIS
      if (i++ != value) {
        sen_sym_key(sym, value, symbuf, 8192);
        printf("get: %s: %s\n", p, symbuf);
      }
#endif
    }
    fclose(fp);
  }

  /*

  {
    sprintf(buffer, "/proc/%d/status", getpid());
    fp = fopen(buffer, "r");
    buffer[fread(buffer, 1, 65536, fp)] = NUL;
    puts(buffer);
    fclose(fp);
  }

  */
  {
    int j, n = sen_sym_size(sym);
    // printf("nrec=%d\n", n);
    for (i = n; i >= 1; i--) {
      sen_sym_key(sym, i, symbuf, 8192);
      j = sen_sym_at(sym, symbuf);
      if (j == i) {
#ifdef WITH_SIS
        sen_sym_del_with_sis(sym, j, sis_deletable, NULL);
#else /* WITH_SIS */
        sen_sym_del(sym, symbuf);
        if (i + sen_sym_size(sym) != n) {
          printf("oho!!, i=%d, s=%d, n=%d\n", i, sen_sym_size(sym), n);
          return;
        }
#endif
      }
      /*
      if (!(i % 10000)) {
        printf("deleting(%d) %s->%d\n", i, key, sen_sym_at(sym, key));
      }
      */
    }

    printf("deleted all records. i=%d, nrec=%d, nrec0=%d\n", i, sen_sym_size(sym), n);
    for (i = 1; i < n; i++) {
      sen_sym_key(sym, i, symbuf, 8192);
      if (sen_sym_at(sym, symbuf)) {
        printf("%d->%d (%s)\n", i, sen_sym_at(sym, symbuf), symbuf);
      }
    }

    puts("checked..");

    return;

    fp = fopen(argv[2], "r");
    i = 1;
    while ((p = fgets(buffer, 65535, fp))) {
      for (p2 = p; *p2 && *p2 != NL; p2++);
      *p2 = NUL;
      value = sen_sym_get(sym, p);
      if (i + n != value) {
        //      printf("%s: %d\n", p, value);
      }
      i++;
    }
    fclose(fp);

    fp = fopen(argv[2], "r");
    i = 1;
    while ((p = fgets(buffer, 65535, fp))) {
      for (p2 = p; *p2 && *p2 != NL; p2++);
      *p2 = NUL;
      value = sen_sym_at(sym, p);
      if (n + i++ != value) {
        /*
          sen_sym_key(sym, value, symbuf, 8192);
          printf("%s: %s\n", p, symbuf);
        */
      }
    }
    fclose(fp);
    printf("registered again.. i=%d, nrec=%d, nrec0=%d\n", i, sen_sym_size(sym), n);

  }
  sen_sym_close(sym);
}

int
main(int argc, char **argv)
{
  if (argc < 4) {
    puts("Usage: ttest get|put|whole datafile symfilename");
    return 1;
  }
  doit(argc, argv);
  return 0;
}
