/***************************************************************************
    smb4kbookmark.h  - A bookmark container.
                             -------------------
    begin                : Feb 04 2004
    copyright            : (C) 2004 by Franck Babin
                           (C) 2005 by Alexander Reinholdt
    email                : babinfranck@yahoo.ca
                           dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/

#ifndef SMB4KBOOKMARK_H
#define SMB4KBOOKMARK_H

// Qt includes
#include <qstring.h>

/**
 * This class is a container for a set bookmark on a samba share
 */

class Smb4KBookmark
{
  public:
    /**
     * The constructor.
     *
     * @param hostname  The host name.
     *
     * @param sharename The share name.
     *
     * @param workgroup The workgroup/domain where the share is located.
     *
     * @param ip        The IP address of the host
     *
     * @param type      The type of the share, i.e. "disk" or "printer".
     */
    Smb4KBookmark( const QString &hostname, const QString &sharename, const QString &workgroup, const QString &ip, const QString &type );

    /**
     * The empty constructor.
     */
    Smb4KBookmark() {}

    /**
     * The destructor.
     */
    ~Smb4KBookmark();

    /**
     * This function returns the share name.
     *
     * @returns         The share name
     */
    const QString &share();

    /**
     * This function returns the workgroup/domain the share is located in.
     *
     * @returns         The workgroup
     */
    const QString &workgroup();

    /**
     * This function returns the IP address of the host that carries the
     * share.
     *
     * @returns         The IP address
     */
    const QString &ip();

    /**
     * This function returns the type of the share, i.e. either "Disk" or
     * "Printer"/"Print" and "IPC".
     *
     * @returns         The type of the share
     */
    const QString &type();

    /**
     * This function sets the share name of the bookmark. It is normally not
     * necessary to use it, because all data should be passed to the constructor.
     * In case of homes shares, however, this function is useful.
     *
     * @param name      The share name
     */
    void setShareName( const QString &name );

    /**
     * This function returns the bookmark name.
     *
     * @returns         The name of the bookmark
     */
    const QString &bookmark();

    /**
     * This function returns the host name.
     *
     * @returns         The name of the host
     */
    const QString &host();

    /**
     * This function sets the IP address.
     *
     * @param ip        The IP address
     */
    void setIP( const QString &ip );


  private:
    /**
     * The host name.
     */
    QString m_host;

    /**
     * The share name.
     */
    QString m_share;

    /**
     * The workgroup
     */
    QString m_workgroup;

    /**
     * The IP address
     */
    QString m_ip;

    /**
     * The type of the share;
     */
    QString m_type;

    /**
     * The bookmark string.
     */
    QString m_bookmark;
};

#endif
