/***************************************************************************
    smb4kdefs.h  -  Definitions for Smb4K
                             -------------------
    begin                : Mo M� 15 2004
    copyright            : (C) 2004 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/


#ifndef SMB4KDEFS_H
#define SMB4KDEFS_H


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// Run states
#define SCANNER_INIT                          0
#define SCANNER_OPENING_WORKGROUP             1
#define SCANNER_OPENING_HOST                  2
#define SCANNER_RETRIEVING_INFO               3
#define SCANNER_RETRIEVING_PREVIEW            4
#define SCANNER_SEARCHING                     5
#define SCANNER_RETRYING_OPENING_HOST         6
#define SCANNER_STOP                          7
#define MOUNTER_MOUNTING                      8
#define MOUNTER_UNMOUNTING                    9
#define MOUNTER_UNMOUNTING_ALL               10
#define MOUNTER_STOP                         11
#define PRINT_START                          12
#define PRINT_STOP                           13
#define CORE_STOP                            14
#define SYNCER_START                         15
#define SYNCER_STOP                          16

// Error codes:
#define ERROR_GETTING_BROWSELIST            100
#define ERROR_GETTING_MEMBERS               101
#define ERROR_GETTING_SHARES                102
#define ERROR_GETTING_PREVIEW               103
#define ERROR_OPENING_WALLET_FAILED         104
#define ERROR_GETTING_PERMISSIONS           105
#define ERROR_UNMOUNTING_NOT_ALLOWED        106
#define ERROR_MOUNTING_SHARE                107
#define ERROR_UNMOUNTING_SHARE              108
#define ERROR_FILE_NOT_FOUND                109
#define ERROR_READING_FILE                  110
#define ERROR_UNKNOWN                       111
#define ERROR_GETTING_HOSTNAME              112
#define ERROR_MISSING_PROGRAMS              113
#define ERROR_LOCKED                        114
#define ERROR_MKDIR_FAILED                  115
#define ERROR_WRITING_FILE                  116
#define ERROR_GETTING_USAGE                 117
#define ERROR_MOUNTPOINT_EMPTY              118
#define ERROR_WRONG_KERNEL                  119
#define ERROR_FEATURE_NOT_ENABLED           120
#define ERROR_BOOKMARK_PRINTER              121
#define ERROR_IP_CANNOT_BE_USED             122
#define ERROR_IMPORTING_SHARES              123
#define ERROR_COMMAND_NOT_FOUND             124
#define ERROR_PRINTING                      125
#define ERROR_CREATING_TEMP_DIR             126
#define ERROR_CREATING_TEMP_FILE            127
#define ERROR_DIRECTORY_NOT_FOUND           128
#define ERROR_LOCK_FILE_IS_SYMLINK          129
#define ERROR_SYNCHRONIZING                 130
#define ERROR_OPENING_FILE		              131
#define ERROR_NET_COMMAND                   132
#define ERROR_PROGRAM_MISSING               133
#define ERROR_GETTING_GIDS                  134

// Warning codes:
/* None defined yet. use 200 ff. for that */

// Information codes:
#define INFO_MIMETYPE_NOT_SUPPORTED         300
#define INFO_DISABLE_SUID_FEATURE           301

// Other definitions
#define TIMER_INTERVAL                       50
#define THREAD_WAITING_TIME                 100
#define TEMPPATHLEN                          18

#endif
