/***************************************************************************
    smb4knetworkitems  -  Network items used by the Smb4KScanner class
    to pass and store data.
                             -------------------
    begin                : Mi Jun 2 2004
    copyright            : (C) 2004 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/

// KDE includes
#include <klocale.h>

// application specific includes
#include "smb4knetworkitems.h"


/****************************************************************************
   Constructor for the Smb4KWorkgroupItem class.
****************************************************************************/

Smb4KWorkgroupItem::Smb4KWorkgroupItem( const QString &name, const QString &master, const QString &masterIP )
: m_name( name ), m_master( master ), m_ip( masterIP )
{
  m_pseudo = false;
}

/****************************************************************************
   Destructor for the Smb4KWorkgroupItem class.
****************************************************************************/

Smb4KWorkgroupItem::~Smb4KWorkgroupItem()
{
}


/****************************************************************************
   Set the pseudo value to TRUE.
****************************************************************************/

void Smb4KWorkgroupItem::setPseudo()
{
  m_pseudo = true;
}


/****************************************************************************
  Sets the master's IP address
****************************************************************************/

void Smb4KWorkgroupItem::setMasterIPAddress( const QString &ip )
{
  m_ip = ip;
}


/****************************************************************************
  Sets the master's name and IP address
****************************************************************************/

void Smb4KWorkgroupItem::setMaster( const QString &name, const QString &ip )
{
  m_master = name;
  m_ip = ip;
}

/****************************************************************************
   Constructors for the Smb4KHostItem class.
****************************************************************************/

Smb4KHostItem::Smb4KHostItem( const QString &workgroup, const QString &name, const QString &comment, const QString &ip )
: m_workgroup( workgroup ), m_name( name ), m_comment( comment ), m_ip( ip ), m_master( false ),
  m_info_checked( false )
{
  m_ip_checked = m_ip.stripWhiteSpace().isEmpty() ? false : true;
}


/****************************************************************************
   Destructor for the Smb4KHostItem class.
****************************************************************************/

Smb4KHostItem::~Smb4KHostItem()
{
}


/****************************************************************************
  Sets the server string of this host.
****************************************************************************/

void Smb4KHostItem::setServerString( const QString &server )
{
  m_server_string = server;
}


/****************************************************************************
  Sets the OS string of this host.
****************************************************************************/

void Smb4KHostItem::setOSString( const QString &os )
{
  m_os_string = os;
}


/****************************************************************************
   Determines if this host is a master browser
****************************************************************************/

void Smb4KHostItem::setMaster( bool master )
{
  m_master = master;
}


/****************************************************************************
   Sets the IP address
****************************************************************************/

void Smb4KHostItem::setIPAddress( const QString &ip )
{
  m_ip = ip;
}


/****************************************************************************
   Sets the comment
****************************************************************************/

void Smb4KHostItem::setComment( const QString &comment )
{
  m_comment = comment;
}


/****************************************************************************
   Used if one has checked for the IP address.
****************************************************************************/

void Smb4KHostItem::setIPAddressChecked( bool yes )
{
  m_ip_checked = yes;
}


/****************************************************************************
   Used if one has checked for the information
****************************************************************************/

void Smb4KHostItem::setInfoChecked( bool yes )
{
  m_info_checked = yes;
}


/****************************************************************************
   Constructor for the Smb4KShareItem class.
****************************************************************************/

Smb4KShareItem::Smb4KShareItem( const QString &workgroup, const QString &host, const QString &name, const QString &type, const QString &comment )
: m_workgroup( workgroup ), m_host( host ), m_name( name ), m_type( type ), m_comment( comment )
{
}


/****************************************************************************
   Destructor for the Smb4KShareItem class.
****************************************************************************/

Smb4KShareItem::~Smb4KShareItem()
{
}


/****************************************************************************
   Returns a translated version of the share type
****************************************************************************/

const QString Smb4KShareItem::translatedType() const
{
  QString return_string;

  if ( QString::compare( m_type, "Disk" ) == 0 )
  {
    return_string = i18n( "Disk" );
  }
  else if ( QString::compare( m_type, "Print" ) == 0 || QString::compare( m_type, "Printer" ) == 0 )
  {
    return_string = i18n( "Printer" );
  }
  else
  {
    return_string = m_type;
  }

  return return_string;
}


/****************************************************************************
   Is the share a hidden one?
****************************************************************************/

bool Smb4KShareItem::isHidden() const
{
  return m_name.stripWhiteSpace().endsWith( "$" );
}


/****************************************************************************
   Is the share a printer?
****************************************************************************/

bool Smb4KShareItem::isPrinter() const
{
  return (QString::compare( m_type, "Print" ) == 0 || QString::compare( m_type, "Printer" ) == 0);
}


/****************************************************************************
   Is the share an IPC$ share?
****************************************************************************/

bool Smb4KShareItem::isIPC() const
{
  return (QString::compare( m_name.stripWhiteSpace(), "IPC$" ) == 0);
}


/****************************************************************************
   Is the share an ADMIN$ share?
****************************************************************************/

bool Smb4KShareItem::isADMIN() const
{
  return (QString::compare( m_name.stripWhiteSpace(), "ADMIN$" ) == 0);
}


/****************************************************************************
   Constructor for the Smb4KPreviewItem class.
****************************************************************************/

Smb4KPreviewItem::Smb4KPreviewItem( const QString &host, const QString &share, const QString &path, const QString &name, bool file )
: m_host( host ), m_share( share ), m_path( path ), m_name( name ), m_isFile( file )
{
}


/****************************************************************************
   Destructor for the Smb4KPreviewItem class.
****************************************************************************/

Smb4KPreviewItem::~Smb4KPreviewItem()
{
}


/****************************************************************************
   Sets the item to be a file or directory.
****************************************************************************/

void Smb4KPreviewItem::setIsFile( bool sw )
{
  m_isFile = sw;
}
