/***************************************************************************
                          smb4ksynchronizer  -  description
                             -------------------
    begin                : Mo Jul 4 2005
    copyright            : (C) 2005 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/

#ifndef SMB4KSYNCHRONIZER_H
#define SMB4KSYNCHRONIZER_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// KDE includes
#include <kprocess.h>
#include <kdialogbase.h>

// Qt includes
#include <qobject.h>
#include <qstring.h>

// application specific includes
#include "smb4kshare.h"


class Smb4KSynchronizer : public QObject
{
  Q_OBJECT

  public:
    /**
     * The constructor of the synchronizer.
     *
     * @param parent      The parent of this object
     *
     * @param name        The name of this object
     */
    Smb4KSynchronizer( QObject *parent = 0, const char *name = 0 );

    /**
     * The destructor.
     */
    ~Smb4KSynchronizer();

    /**
     * This function synchronizes a share with a local copy or vice versa.
     *
     * @param share       The share that is involved in the synchronization.
     *
     * @param parent      The parent widget of the dialogs that will be shown.
     */
    void synchronize( Smb4KShare *share, QWidget *parent );

    /**
     * This function reports if the synchronizer is running or not.
     *
     * @returns           TRUE if the synchronizer is running an FALSE otherwise.
     */
    bool isRunning() { return m_working; }

  public slots:
    /**
     * This function aborts the synchronization, i.e. the sync process is killed.
     */
    void abort();

  signals:
    /**
     * This signal emits the run state.
     *
     * @param state       The so-called run state. There are several defined
     *                    in the smb4kdefs.h header file.
     */
    void state( int state );

  protected slots:
    /**
     * Reimplemented from KProcess.
     *
     * @param proc        The process that exited
     */
    void slotProcessExited( KProcess *proc );

    /**
     * Reimplemented from KProcess.
     *
     * @param proc        The process from which output was received on stdout
     *
     * @param buf         The buffer that contains the output
     *
     * @param len         The length of the buffer
     */
    void slotReceivedStdout( KProcess *proc, char *buf, int len );

    /**
     * Reimplemented from KProcess.
     *
     * @param proc        The process from which output was received on stderr
     *
     * @param buf         The buffer that contains the output
     *
     * @param len         The length of the buffer
     */
    void slotReceivedStderr( KProcess *proc, char *buf, int len );

    /**
     * This slot swap the locations in the chooser dialog.
     */
    void slotSwapURLs();

    /**
     * This slot is connected to KApplication::shutDown() signal.
     * It aborts the running KProcess if necessary.
     */
    void slotShutdown();

  private:
    /**
     * The process object for this class.
     */
    KProcess *m_proc;

    /**
     * This booian is TRUE if the synchronizer is working and FALSE otherwise.
     */
    bool m_working;

    /**
     * This function reads the options, that the user chose to use with rsync.
     *
     * @returns     an option string
     */
    const QString readRsyncOptions();

    /**
     * The dialog where you can choose the locations.
     */
    KDialogBase *m_chooser;

    /**
     * The progress dialog.
     */
    KDialogBase *m_dialog;

    /**
     * The buffer for the output.
     *
     * NOTE: The buffer is not to contain error messages, that are received
     * via slotReceivedStderr()!
     */
    QString m_buffer;

    /**
     * Total number of files to transfer
     */
    QString m_total_files;
};

#endif
