/***************************************************************************
    smb4ksharewidget.h  -  The widget, that displays the mounted shares.
                             -------------------
    begin                : Sam M� 1 2003
    copyright            : (C) 2003 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/

#ifndef SMB4KSHAREWIDGET_H
#define SMB4KSHAREWIDGET_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// KDE includes
#include <kiconview.h>
#include <kprocess.h>
#include <kactioncollection.h>
#include <kactionclasses.h>
#include <kaction.h>
#include <kurldrag.h>

// Application includes
#include "../core/smb4kshare.h"
#include "smb4ksharetooltip.h"
#include "smb4kshareactionmenu.h"


class Smb4KShareWidgetItem;

/**
 * This class provides the ability display the mounted shares
 * and manipulate them.
 */
class Smb4KShareWidget : public KIconView
{
  Q_OBJECT

  friend class Smb4KShareWidgetItem;

  public:
    /**
     * The constructor.
     *
     * @param parent      The parent widget.
     *
     * @param name        The name of the widget.
     */
    Smb4KShareWidget( QWidget *parent = 0, const char *name = 0 );

    /**
     * The destructor.
     */
    ~Smb4KShareWidget();

    /**
     * Reads the options.
     */
    void readOptions();

    /**
     * This function returns a pointer to the action collection of this class.
     * You should use it to include the action into the action collection of the
     * main action collection (e.g. KMainWindow::actionCollection()).
     *
     * The entries in this action collection are members of the group "ShareWidget".
     *
     * @returns           a pointer to the action collection of this class
     */
    KActionCollection *action_collection() { return m_collection; }

    /**
     * This function can be used to adjust the size (etc.) of the list view icons on
     * the fly after the user changed the settings in kcontrol.
     */
    void changeIcons();

  protected:
    /**
     * This function has been reimplemented from QIconView. In addition
     * to the stuff QIconView::contentsMouseMoveEvent() does it also
     * manages the showing of the information about the share.
     *
     * @param e           A pointer to the QMouseEvent object.
     */
    void contentsMouseMoveEvent( QMouseEvent *e );

    /**
     * Reimplemented (sort of) from QIconView to enable dragging. As QDragObject
     * a KURLDrag will be returned.
     *
     * @returns a KURLDrag object.
     */
    KURLDrag *dragObject();

    /**
     * Reimplemented from QIconView to allow some actions to be carried
     * out before the drag begins.
     */
    void startDrag();

    /**
     * Reimplemented from QIconView.
     */
    void contentsDropEvent( QDropEvent *e );

  protected slots:
    /**
     * Is called by the menu. Does the unmounting.
     */
    void slotUnmountShare();

    /**
     * Is called by the menu. Unmounts all shares at once.
     */
    void slotUnmountAllShares();

    /**
     * Is called by the menu. Forces the unmount of a share.
     */
    void slotForceUnmountShare();

    /**
     * Is called to import mounted shares into the share view.
     */
    void slotMountedShares();

    /**
     * Is called, when a share is to be opened with the filemanager.
     * This slot behaves exactly the same as slotItemExecuted(), except
     * this is an external one.
     */
    void slotOpenFilemanager();

    /**
     * Is called when any mouse button was pressed.
     */
    void slotMouseButtonPressed( int button, QIconViewItem *item, const QPoint &pos );

    /**
     * Is called when the current item changed.
     *
     * @param item        The current item
     */
    void slotSelectionChanged( QIconViewItem *item );

    /**
     * This slot is called to show the info tool tip.
     */
    void slotShowTooltip();

    /**
     * This slot starts the synchronization of a share with a local copy.
     */
    void slotSynchronize();

    /**
     * This slot is invoked when the user changes the icon size, etc. It is
     * connected to the signal KApplication::iconChanged().
     *
     * @param group       The icon group
     */
    void slotIconChanged( int group );

  private:
    /**
     * Holds the display style.
     */
    QString m_display;

    /**
     * Holds whether the mount point should be shown as description.
     */
    bool m_mountpoint;

    /**
     * Determines whether all shares that were mounted should be shown.
     */
    bool m_showExternal;

#ifdef __linux__
    /**
     * Determines whether the user wants to force the unmounting of
     * dead shares or not.
     */
    bool m_forcedUnmount;
#endif

    /**
     * This is the action collection of this class.
     */
    KActionCollection *m_collection;

    /**
     * This function initializes the actions that are provided by this class.
     */
    void initActions();

    /**
     * The unmount action.
     */
    KAction *m_unmount_action;

#ifdef __linux__
    /**
     * Action to force the unmount.
     */
    KAction *m_force_action;
#endif

    /**
     * The unmount all action
     */
    KAction *m_unmount_all_action;

    /**
     * The filemanager action
     */
    KAction *m_filemanager_action;

    /**
     * The synchronize action
     */
    KAction *m_sync_action;

    /**
     * The tooltip object
     */
    Smb4KShareTooltip *m_tooltip;

    /**
     * This boolean tells if the rsync binary is installed
     * and thus helps to decide whether the respective action
     * should be enabled.
     */
    bool m_rsync;

    /**
     * The action menu.
     */
    Smb4KShareActionMenu *m_menu;

    /**
     * The global position where the tool tip should be shown.
     */
    QPoint m_pos;

    /**
     * Allow dropping of things onto share icons.
     */
    bool m_allow_dropping;

    /**
     * Allow the dragging of share icons.
     */
    bool m_allow_dragging;
};

#endif
