/*
 * cfgfile.c
 * Thomas Nemeth, le 26.03.2005
 *
 *   Copyright (C) 1999  Thomas Nemeth
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "config.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <strings.h>
#include "defines.h"
#include "xmem.h"
#include "cfgfile.h"




static int get_bool(const char *value)
{
        if (strcasecmp(value, "1")     == 0) return TRUE;
        if (strcasecmp(value, "0")     == 0) return FALSE;
        if (strcasecmp(value, "true")  == 0) return TRUE;
        if (strcasecmp(value, "false") == 0) return FALSE;
        if (strcasecmp(value, "yes")   == 0) return TRUE;
        if (strcasecmp(value, "no")    == 0) return FALSE;
        if (strcasecmp(value, "on")    == 0) return TRUE;
        if (strcasecmp(value, "off")   == 0) return FALSE;
        return FALSE;
}


static void set_option(options option, char *value)
{
        switch (option.type)
        {
                case OPT_INT:
                        *((int *)option.value) = atoi(value);
                        break;
                case OPT_BOOL:
                        *((int *)option.value) = get_bool(value);
                        break;
                case OPT_REAL:
                        *((double *)option.value) = strtod(value, NULL);
                        break;
                case OPT_CHAR:
                        *((char *)option.value) = value[0];
                        break;
                case OPT_STR:
                        if (*((char **)option.value) == NULL)
                        {
                                *((char **)option.value) = xstrdup(value);
                        }
                        break;
                default: /* ERROR ! */
        }
}


void load_config(options *list, const char *filename)
{
        FILE *file;

        if ((file = fopen(filename, "r")) == NULL)
        {
                return;
        }
        while (! feof(file))
        {
                char  line[MAXSTRLEN];
                char *value;
                int   i;

                memset(line, 0, MAXSTRLEN);
                fgets(line, MAXSTRLEN, file);
                if ((line[0] == '\0') || (line[0] == '\n') || (line[0] == '#'))
                {
                        continue;
                }
                line[strlen(line) - 1] = '\0';
                value = strchr(line, '=') + 1;
                while (value && (value[0] == ' '))
                {
                        value++;
                }
                if (!value)
                {
                        continue;
                }
                for (i = 0 ; list[i].name ; i++)
                {
                        int l = strlen(list[i].name);
                        if ((strncmp(list[i].name, line, l) == 0)
                                && (list[i].value))
                        {
                                set_option(list[i], value);
                        }
                }
        }
        fclose(file);
}

