/*
 * printlog.c
 * Thomas Nemeth, le 15.10.2003
 *
 *   Copyright (C) 1999  Thomas Nemeth
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <stdio.h>
#ifdef OS_SunOS
#include <sys/varargs.h>
#else
#include <stdarg.h>
#endif
#include <string.h>
#include "config.h"
#include "defines.h"
#include "tmms.h"
#include "printlog.h"

FILE *logfile = NULL;

void printlog(int level, const char *format, ...)
{
        va_list ap;

        va_start(ap, format);
        if ((level != 0) && logfile && (
                    ((DEBUG_LEVEL > 0) && (level <= DEBUG_LEVEL)) ||
                    (level == -DEBUG_LEVEL) ) )
        {
                vfprintf(logfile, format, ap);
                fflush(logfile);
        }
        va_end(ap);
}

