.TH "TXT2TAGS" 1 "May, 2005" ""

.SH NOMBRE
.P
txt2tags \- Herramienta de formateo y conversin de texto

.SH SINOPSIS
.P
\fBtxt2tags\fR [\fIOPCIN\fR]... [\fIARCHIVO\fR]...

.SH DESCRIPCIN
.P
\fBtxt2tags\fR es una herramienta GLP de conversin de formatos, escrita en Pyton, que
genera documentos \fIHTML\fR, \fIXHTML\fR, \fISGML\fR, \fILaTeX\fR, \fILout\fR,
\fIMan Page\fR, \fIMoinMoin\fR, \fIMagicPoint\fR y \fIPageMaker\fR a partir de un simple
archivo de texto mnimamente marcado ( p.ej.: texto plano).

.P
El usuario slo precisa conocer unas pocas y sencillas reglas de marcado, propias de  de \fBtxt2tags\fR, 
y escribir sus archivos en texto plano. El programa se encarga de realizar todo el trabajo, aadiendo las marcas necesarias y 
arreglndose con los problemas que pueda presentar el archivo de salida.

.P
El mismo archivo de texto puede ser convertido a todos y cada uno de los formatos de salida,
sin necesidad de tener que editarlo cada vez. ste es el propsito de \fBtxt2tags\fR : UN archivo fuente, MLTIPLES archivos finales.

.P
Visitad la pgina del programa, que se encuentra en:
\fIhttp://txt2tags.sourceforge.net\fR.

.SH OPCIONES
.TP
 \fB\-C\fR, \fB\-\-config\-file\fR
Lee la configuracin desde un archivo externo (acta cmo %!includeconf)

.TP
     \fB\-\-css\-sugar\fR
Inserta CSS\-friendly tags para archivos de salida HTML y XHTML 

.TP
     \fB\-\-css\-inside\fR
Inserta el contenido de un archivo CSS en el encabezamiento HTML/XHTML 

.TP
     \fB\-\-dump\-config\fR
Imprime toda la configuracin encontrada y sle.

.TP
     \fB\-\-dump\-source\fR
Imprime el documento fuente, con las inclusiones expandidas

.TP
     \fB\-\-encoding\fR
Elige la codificacin del archivo de salida (UTF\-8, ISO\-8859\-1, etc)

.TP
     \fB\-\-gui\fR
Lanza la Interfaz Grfica TK

.TP
 \fB\-h\fR, \fB\-\-help\fR
Imprime la informacin de ayuda y sle

.TP
 \fB\-H\fR, \fB\-\-no\-headers\fR
Suprime el encabezamiento, ttulo y pi de pgina

.TP
     \fB\-\-headers\fR
Muestra el encabezamiento, ttulo y pi de pgina (por defecto, ON)

.TP
 \fB\-i\fR, \fB\-\-infile\fR=\fIFILE\fR
Toma FILE como nombre del archivo de entrada ('\-' para STDIN)

.TP
     \fB\-\-mask\-email\fR
Oculta email a los robots de spam. < x@y.z > se convierte en  < x (a) y z >

.TP
 \fB\-n\fR, \fB\-\-enum\-title\fR
Numera todos los ttulos: 1, 1.1, 1.1.1, etc

.TP
     \fB\-\-no\-dump\-config\fR
Desactiva dump config

.TP
     \fB\-\-no\-dump\-source\fR
Desactiva dump source 

.TP
     \fB\-\-no\-encoding\fR
Excluye la configuracin de encoding

.TP
     \fB\-\-no\-enum\-title\fR
Desactiva la numeracin de ttulos

.TP
     \fB\-\-no\-infile\fR
Suprime las anteriores declaraciones infile

.TP
     \fB\-\-no\-mask\-email\fR
Muestra emails. Desactiva la opcin \-\-mask\-email 

.TP
     \fB\-\-no\-outfile\fR
Suprime las anteriores declaraciones outfile

.TP
     \fB\-\-no\-quiet\fR
Muestra mensajes. Desactiva la opcin \-\-quiet 

.TP
     \fB\-\-no\-rc\fR
No lee el archivo de configuracin de usuario ~/.txt2tagsrc

.TP
     \fB\-\-no\-style\fR
Suprime la declaracin de estilo

.TP
     \fB\-\-no\-toc\fR
No aade ndice de contenidos TOC (Table of Contents) al documento final

.TP
     \fB\-\-no\-toc\-only\fR
Desactiva la opcin \-\-toc\-only 

.TP
 \fB\-o\fR, \fB\-\-outfile\fR=\fIFILE\fR
Toma FILE como el nombre del archivo de salida ('\-' para STDOUT)

.TP
 \fB\-q\fR, \fB\-\-quiet\fR
Modo silencioso, suprime todas las salidas (excepto errores)

.TP
     \fB\-\-rc\fR
Lee el archivo de configuracion de usuario ~/.txt2tagsrc (por defecto, ON)

.TP
     \fB\-\-style\fR=\fIFILE\fR
Usa FILE como documento de estilo (cmo HTML CSS)

.TP
\fB\-t\fR, \fB\-\-target\fR
Define el tipo de documento final. Actualmente las opciones son:
html, xhtml, sgml, tex, lout, man, mgp, moin, pm6, txt

.TP
     \fB\-\-toc\fR
Aade ndice de contenidos, TOC (Table of Contents) al documento final

.TP
     \fB\-\-toc\-level\fR=\fIN\fR
Define en N el nivel mximo (profundidad) del ndice de contenidos

.TP
     \fB\-\-toc\-only\fR
Imprime el ndice de contenidos (TOC) y sle

.TP
 \fB\-v\fR, \fB\-\-verbose\fR
Imprime los mensajes de informacin durante la conversin

.TP
 \fB\-V\fR, \fB\-\-version\fR
Imprime la versin del programa y sle

.P
Por defecto, el archivo de salida es salvado en 'file.<type>'.
Usar \-\-outfile para forzar un nombre de archivo de salida.
Si el archivo de entrada es '\-', lee de STDIN.
Si el archivo de salida es '\-', vuelca el archivo de salida en STDOUT.

.SH ESTRUCTURA
.P
Un archivo fuente txt2tags puede tener tres reas:

.TP
\fBEncabezamiento\fR
Las tres primeras lneas. Son usadas para la identificacin del documento.
Si no precisas encabezamientos, puedes dejar en blanco la primera lnea o mediante la
opcin  no\-header .

.TP
\fBConfiguraciones\fR
Se inician a partir de la cuarta lnea. Todas las configuraciones siguen el formato: \fB%!clave: valor\fR.
Las configuraciones tambin pueden hacerse mediante archivos de configuracin o lnea de comandos.

.TP
\fBCuerpo\fR
Es el documento en si. Es la nica rea imprescindible para tener un archivo txt2tags vlido.

.SH CONFIGURACIN
.P
La conversin de un archivo fuente puede personalizarse por dos vias: externa o interna.
Externamente, las configuraciones pueden ser tomadas de un archivo RC
(~/.txt2tagsrc) o importadas de otro archivo de configuracin definido por el usuario. Internamente,
la personalizacin se realiza mediante comandos de configuracin especiales en el mismo documento fuente.
En ambos mtodos se utiliza la misma sintaxis:

.TP
\fB%!target:\fR
Define el formato destino (target) principal

.TP
\fB%!options(target):\fR
Define las opciones de cada destino

.TP
\fB%!include: file.t2t\fR
Incluye un archivo txt2tags en el documento

.TP
\fB%!include: ``file.txt``\fR
Incluye un archivo de texto (verbatim) en el documento

.TP
\fB%!include: ''file.html''\fR
Incluye un archivo de forma "literal" en el documento, eso s, "tal cmo est"

.TP
\fB%!style:\fR
Define un archivo CSS (Cascading Style Sheets) para archivos finales del tipo XHTML y HTML
o para cargar los mdulos (\eusepackage) en un archivo destino tipo TEX

.TP
\fB%!encoding:\fR
Para elegir la codificacin de carcteres del archivo final (como ISO\-8859\-1) para usuarios de lengua no\-inglesa

.TP
\fB%!includeconf:\fR
Usado para incluir, el en archivo corriente, una configuracin a partir de un archivo externo.

.TP
\fB%!guicolors:\fR
Configuracin de los colores para la interfaz GUI (tk/tcl) 

.TP
\fB%!preproc:\fR
Para definir los propios filtros (macros) que sern procesados \fBANTES\fR de procesar el documento

.TP
\fB%!postproc:\fR
Para definir los propios filtros (macros) que sern procesados \fBDESPUS\fR de procesar el documento

.SS REGLAS DE LAS CONFIGURACIONES
.RS
.IP \(bu 3
Las configuraciones son slo vlidas en el rea de Configuracin 
y sern consideradas comentarios si se encuentran en el rea del Cuerpo
. Una excepcin es include, que es vlida en el Cuerpo.

.IP \(bu 3
Si aparece la misma palabra clave ms de una vez en una misma rea de Configuracin,
la ltima hallada ser la que se utilizar. Excepciones: options, preproc, postproc, que son acumulativas.
.RE

.RS
.IP \(bu 3
Una lnea de configuracin con una palabra clave invlida, ser considerada un comentario.

.IP \(bu 3
stas configuraciones tienen precedencia sobre el archivo txt2tagsrc, pero no sobre las opciones en lnea de comando.
.RE

.SH SINTAXIS
.P
Se utiliza una sencilla sintaxis de marcas en el archivo fuente ( el archivo de texto plano) para identificar las estructuras y el formato. sta es la lista completa:

.SS Bsicas
.nf
  Encabezamiento      Las primeras 3 lneas del archivo fuente
  Ttulo             = palabras =
  Ttulo numerado    + palabras +
  Prrafo            palabras
.fi


.SS Modificadores de Fuentes
.nf
  Negrita             **palabras**
  Italic (cursiva)    //palabras//
  Subrayado           __palabras__
  Monoespaciado       ``palabras``
.fi


.SS Bloques de Texto
.nf
  Cita                  <TAB>palabras
  Lista                 - palabras
  Lista numerada        + palabras
  Lista de definicin   : palabras
  Lnea verbatim        ``` palabras
  Zona verbatim         ```<Retono (/n)> lneas <Retorno (/n)>```
  Lnea raw             """ palabras
  Zona raw              """<Retorno (/n)> lines <Retorno (/n)>"""
  Tabla                 | celda1 | celda2 | celda3...
.fi


.SS Otras
.nf
  Lnea de separacin    -----------------------...
  Lnea gruesa           =======================...
  Enlaces (links)        [etiqueta url]
  Imagen                 [archivo.jpg]
  Texto raw              ""palabras""
  Comentario             % comentarios
.fi


.P
Leer la Gua del Usuario de txt2tags para una descripcin mas detallada de cada marca

.SH EJEMPLOS
.P
Asumiendo que hayas creado el archivo marcado file.t2t, veamos cmo operar para proceder a su conversin:

.TP
\fBConvertir a HTML  (archivo final: file.html)\fR
$ txt2tags \-t html file.t2t

.TP
\fBLo mismo, usando redireccionamiento\fR
$ txt2tags \-t html \-o \- file.t2t > file.html

.TP
\fBIncluyendo un ndice de Contenidos (TOC)\fR
$ txt2tags \-t html \-\-toc file.t2t

.TP
\fBIncluyendo TOC y ttulos numerados\fR
$ txt2tags \-t html \-\-toc \-\-enum\-title file.t2t

.TP
\fBVista rpida del ndice de Contenidos\fR
$ txt2tags \-\-toc\-only file.t2t

.TP
\fBComprobacin on\-line rpida atravs de STDIN\fR
$ (echo ; echo "**bold**") | txt2tags \-t html \-H \-

.TP
\fBUtilizacin de la interfaz grfica\fR
$ txt2tags \-\-gui file.t2t

.SH TRUCOS
.P
Existen algunos trucos que hacen de \fBtext2tags\fR una excelente herramienta para el tratamiento de documentos:

.P
Anclas

.P
Los ttulos pueden tener enlaces con anclas, lo que nos permitira llegar directamente a ellos, 
si el formato del documento final lo permite:

.nf
  Ttulo             = palabras =[ancla]
  Ttulo numerado   + palabras +[ancla]
.fi

.P
Archivos mltiples

.P
\fBtxt2tags\fR puede convertir a ms de un archivo a la vez : 

.nf
  txt2tags *.t2t
.fi


.SH MACROS
.TP
%%date
Permite incluir la fecha en curso, en el formato YYYYMMDD. Puede definirse un formato opcional utilizando la sintaxis:
%%date(cadena\-formato) 

.TP
%%infile
Utilizado para obtener informacin sobre el fichero fuente. Admite formatos opcionales especificados por la sintaxis:  %%infile(cadena\-formato) .

til como enlace a pi de pgina cmo [Ver archivo fuente %%infile], de este modo podrs cambiar el nombre del archivo
y la refencia ser actualizada.

.TP
%%mtime

Nos da informacin sobre la fecha de modificacin del archivo fuente. Utiliza el mismo formato que la macro   %%date.

.TP
%%outfile
Utilizado para obtener informacin sobre el archivo convertido. Admite formatos opcionales utilizando la sintaxis:  %%outfile(cadena\-formato) 

til para indicar cosas como: "Este es el archivo de salida  manpage\-es.man ",
Podemos cambiar el nombre del archivo y su referncia sera actualizada .

.TP
%%toc
%%toc  especifica donde se emplaza el ndice de matrias (TOC).
Puede situarse en cualquier lugar del documento.

NOTE: %%toc slo sera procesada con la opcin \-\-toc .

.SH AUTOR
.P
Escrito y mantenido por Aurelio Marinho Jargas <verde@aurelio.net>

.P
ste Manual fu escrito por Jose Inacio Coelho <jic@technologist.com>
como un fichero de texto, y convertido al formato man por \fBtxt2tags\fR!

.P
La traduccin al espaol fu realizada por Antoni Serra Devecchi <antoni.serra@gmail.com> 

.SH COPYRIGHT
.P
Copyright (C) 2001, 2002, 2003, 2004, 2005 Aurelio Marinho Jargas

.P
This is free software; see the source for copying conditions. There is
NO warranty; not even for MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.


.\" man code generated by txt2tags 2.4-dev (http://txt2tags.sf.net)
.\" cmdline: txt2tags manpage-es.t2t

