.\" shorthand for double quote that works everywhere.
.ds q \N'34'
.TH VIA __drivermansuffix__ __vendorversion__
.SH NAME
via \- VIA Unichrome video driver
.SH SYNOPSIS
.nf
.B "Section \*qDevice\*q"
.BI "  Identifier \*q"  devname \*q
.B  "  Driver \*qvia\*q"
\ \ ...
.B EndSection
.fi
.SH DESCRIPTION
.B via
is an __xservername__ driver for VIA Unichrome integrated graphics.
.PP
The
.B via
driver supports the following devices:
.nf
    VT3122:  CLE266 (CastleRock).
    VT7205:  KM400, KM400A, KN400, P4M800 (Unichrome).
    VT3108:  K8M800, K8N800, K8N800A (Unichrome Pro, aka Pro B).
    VT3118:  CN400, PM800, PM880, PN800 (Unichrome Pro A).
    VT3344:  VN800, P4M800Pro (Unichrome Pro).
    VT3157:  CX700 (Unichrome Pro - not yet released).
    VT3130:  K8M890 (Chrome9 IGP).
    VT3343:  P4M890 (Unichrome Pro - not yet released).
.PP
VT3118 through VT3343 support is currently non-existent, as the developer
has no direct access to this hardware yet.
.PP
This driver is being developed at http://unichrome.sourceforge.net/.
It is not endorsed or supported by VIA Technologies. For support, refer
to http://unichrome.sourceforge.net/ directly.

.PP
.SH CONFIGURATION DETAILS
Please refer to __xconfigfile__(__filemansuffix__) for general configuration
details.  This section only covers configuration details specific to this
driver.
.PP
The following driver
.B options
are supported
.TP
.BI "Option \*qActiveDevice\*q \*q" string \*q
Specify the active device combination. Any string containing \*qCRT\*q,
\*qDFP\*q (for Digital Flat Panel), \*qTV\*q should be possible. The default
is to use everything that is detected. The driver is currently unable to use
DFP and TV simultaneously, and will favour the DFP.
.TP
.BI "Option \*qNoAccel\*q \*q" boolean \*q
Disable or enable acceleration. Default: acceleration is enabled.
.TP
.BI "Option \*qHWCursor\*q \*q" boolean \*q
Disable or enable use of hardware cursors. The default is enabled.
.TP
.BI "Option \*qSWCursor\*q \*q" boolean \*q
Disable or enable the use of a software cursor. The default is disabled.
.TP
.BI "Option \*qShadowFB\*q \*q" boolean \*q
Use a shadow frame buffer. This is required when rotating the display,
but otherwise defaults to disabled.
.TP
.BI "Option \*qRotate\*q \*q" string \*q
Rotate the display either clockwise (\*qCW\*q) or counter clockwise (\*qCCW\*q).
Rotation is only supported unaccelerated.
.TP
.BI "Option \*qDisableVQ\*q \*q" boolean \*q
Disable or enable the use of VQ. VQ is enabled by default.
.TP
.BI "Option \*qDRIXINERAMA\*q \*q" boolean \*q
Set DRI Xinerama mode. Currently unsupported.
.TP
.BI "Option \*qDisableIRQ\*q \*q" boolean \*q
Disables Vblank IRQ. A workaround for some mainboards that have
problems with IRQs from the unichrome chip. With IRQ disabled,
DRI clients have no way to sync drawing to Vblank.
.TP
.BI "Option \*qEnableAGPDMA\*q \*q" boolean \*q
Enable the AGP DMA functionality in DRM. This requires that DRI is enabled
and will force 2D, and 3D acceleration to use AGP DMA. 
.TP
.BI "Option \*qNoAGPFor2D\*q \*q" boolean \*q
With this option on, 2D acceleration will not use AGP DMA even if it is enabled.
.TP
.BI "Option \*qUseDMACopy\*q \*q" boolean \*q
Use the DRM DMA blit to copy the Xv buffer to framebuffer, enabled per
default.

.SH "CRT Specific Options"
With CRT we mean every monitor that's connected to the analog-out meant for
CRTs. This irrespective of whether this monitor is plat panel based or not.

VT3122Cx (Rev 16 and up) and all other unichromes support CRT auto detection.
This seems to be missing or broken on VT3122Ax. This integer value should be
provided in kHz and should normally range somewhere between 20000 and 300000.

.TP
.BI "Option \*qCRTBandWidth\*q \*q" integer \*q
This specifies the maximum bandwidth a CRT allows and limits the mode's
dotclock. This integer value should be provided in kHz and should normally
range somewhere between 20000 and 300000. This information is usually
provided as part of DDC/EDID data and thus autodetected.

.SH "Panel Specific Options"
Unichromes have a built-in panel scaler and allow for either LVDS encoders or
directly (aka TTL) connected panels (DFP).

For VT3122 and VT7205 the support is extremely limited, as the hardware to fix
this code is simply not available. You should be able to get native resolution
working on your CLE266 or KM400 based laptop though, but don't expect it to be
smooth.

For VT3108, native resolution and centered modes are possible. Scaling will be
made possible when the secondary CRTC is properly implemented.

.TP
.BI "Option \*qPanelSize\*q \*q" string \*q
Specify the size (width x height) of the LCD panel attached to the
system. Sizes 640x480, 800x600, 1024x768, 1280x1024, and 1400x1050
are supported. This shouldn't be required as this usually is a BIOS
initialised value.


.SH "Supported TV Encoders"
Unichromes tend to be paired with several different TV Encoders. The presence
of these TV encoders is detected. They are automatically enabled when a TV is
attached.

.SH "Chrontel CH7011"
Supports the following modes: \*q640x480\*q, \*q800x600\*q, \*q1024x768\*q.
Use \*q640x480Over\*q, \*q800x600Over\*q and \*q1024x768Over\*q for vertical
overscan. These modes are made available by the driver and modelines provided
in __xconfigfile__ will be ignored when the TV encoder is used.

.TP
.BI "Option \*qTVOutput\*q \*q" string \*q
Specify which TV output to use. The driver supports \*qS-Video\*q,
\*qComposite\*q, \*qSC\*q, \*qRGB\*q and \*qYCbCr\*q outputs. The default is
to use the cable type that is detected.
.TP
.BI "Option \*qTVStandard\*q \*q" string \*q
Specify TV Standard. The CH7011 currently supports \*qNTSC\*q and
\*qPAL\*q.

.SH "VIA Technologies VT1622, VT1622A, VT1623"
Supports the following modes: \*q640x480\*q, \*q800x600\*q, \*q1024x768\*q,
\*q848x480\*q, \*q720x480\*q (NTSC only) and \*q720x576\*q (PAL only). Use
\*q640x480Over\*q, \*q800x600Over\*q, \*q1024x768Over\*q, \*q848x480Over\*q,
\*q720x480Over\*q (NTSC) and \*q720x576Over\*q (PAL) for vertical overscan.
The modes \*q720x480Noscale\*q (NTSC VT1622 only) and \*q720x576Noscale\*q
(PAL VT1622 and VT1622a only) provide cleaner TV output (unscaled with only minimal overscan).
These modes are made available by the driver and modelines provided in
__xconfigfile__ will be ignored when the TV encoder is used.

.TP
.BI "Option \*qTVDeflicker\*q \*q" integer \*q
Specify deflicker setting for TV output. Valid values are 0,1,2
0) No deflicker, 1) 1:1:1 deflicker, 2) 1:2:1 deflicker.
.TP
.BI "Option \*qTVDotCrawl\*q \*q" boolean \*q
Disable or enable dotcrawl. This is available for NTSC modes only.
.TP
.BI "Option \*qTVOutput\*q \*q" string \*q
Specify which TV output to use. The driver supports \*qS-Video\*q,
\*qComposite\*q, \*qSC\*q, \*qRGB\*q and \*qYCbCr\*q outputs. The default is
to use the cable type that is detected.
.TP
.BI "Option \*qTVStandard\*q \*q" string \*q
Specify TV Standard. The driver currently supports \*qNTSC\*q and
\*qPAL\*q.


.SH "BUGS"
Plenty. Feel free to file more at the http://unichrome.sf.net/ bug tracker.
.SH "SEE ALSO"
__xservername__(__appmansuffix__), __xconfigfile__(__filemansuffix__), xorgconfig(__appmansuffix__), Xserver(__appmansuffix__), X(__miscmansuffix__)
.SH AUTHORS
Authors include: Luc Verhaegen (libv@skynet.be)
