#ifndef PLAYERCTRL_H
#define PLAYERCTRL_H

#include <glib.h>

#define LIB_XMMS "xmms"
#define LIB_BEEP "beep"
#define LIB_AUDACIOUS "audacious"

#define CMD_XMMS "xmms"
#define CMD_BEEP "beep-media-player"
#define CMD_AUDACIOUS "audacious"

/**
 * used to player_control_load_library()
 */
typedef enum {
	PLAYER_XMMS,
	PLAYER_BEEP,
	PLAYER_AUDACIOUS
} Players;

// define functions
typedef void  (* _player_playlist) (gint session, gchar ** list, gint num, gboolean enqueue);
typedef gint  (* _player_get_version) (gint session);
typedef void  (* _player_playlist_add) (gint session, GList * list);
typedef void  (* _player_playlist_delete) (gint session, gint pos);
typedef void  (* _player_play) (gint session);
typedef void  (* _player_pause) (gint session);
typedef void  (* _player_stop) (gint session);
typedef gboolean  (* _player_is_playing) (gint session);
typedef gboolean  (* _player_is_paused) (gint session);
typedef gint  (* _player_get_playlist_pos) (gint session);
typedef void  (* _player_set_playlist_pos) (gint session, gint pos);
typedef gint  (* _player_get_playlist_length) (gint session);
typedef void  (* _player_playlist_clear) (gint session);
typedef gint  (* _player_get_output_time) (gint session);
typedef void  (* _player_jump_to_time) (gint session, gint pos);
typedef void  (* _player_get_volume) (gint session, gint * vl, gint * vr);
typedef gint  (* _player_get_main_volume) (gint session);
typedef gint  (* _player_get_balance) (gint session);
typedef void  (* _player_set_volume) (gint session, gint vl, gint vr);
typedef void  (* _player_set_main_volume) (gint session, gint v);
typedef void  (* _player_set_balance) (gint session, gint b);
typedef gchar * (* _player_get_skin) (gint session);
typedef void  (* _player_set_skin) (gint session, gchar * skinfile);
typedef gchar * (* _player_get_playlist_file) (gint session, gint pos);
typedef gchar * (* _player_get_playlist_title) (gint session, gint pos);
typedef gint  (* _player_get_playlist_time) (gint session, gint pos);
typedef void  (* _player_get_info) (gint session, gint * rate, gint * freq, gint * nch);
typedef void  (* _player_main_win_toggle) (gint session, gboolean show);
typedef void  (* _player_pl_win_toggle) (gint session, gboolean show);
typedef void  (* _player_eq_win_toggle) (gint session, gboolean show);
typedef gboolean  (* _player_is_main_win) (gint session);
typedef gboolean  (* _player_is_pl_win) (gint session);
typedef gboolean  (* _player_is_eq_win) (gint session);
typedef void  (* _player_show_prefs_box) (gint session);
typedef void  (* _player_toggle_aot) (gint session, gboolean ontop);
typedef void  (* _player_eject) (gint session);
typedef void  (* _player_playlist_prev) (gint session);
typedef void  (* _player_playlist_next) (gint session);
typedef void  (* _player_playlist_add_url_string) (gint session, gchar * string);
typedef gboolean  (* _player_is_running) (gint session);
typedef void  (* _player_toggle_repeat) (gint session);
typedef void  (* _player_toggle_shuffle) (gint session);
typedef gboolean  (* _player_is_repeat) (gint session);
typedef gboolean  (* _player_is_shuffle) (gint session);
typedef void  (* _player_get_eq) (gint session, gfloat * preamp, gfloat ** bands);
typedef gfloat  (* _player_get_eq_preamp) (gint session);
typedef gfloat  (* _player_get_eq_band) (gint session, gint band);
typedef void  (* _player_set_eq) (gint session, gfloat preamp, gfloat * bands);
typedef void  (* _player_set_eq_preamp) (gint session, gfloat preamp);
typedef void  (* _player_set_eq_band) (gint session, gint band, gfloat value);
/* Added in XMMS 1.2.1 */
typedef void  (* _player_quit) (gint session);
/* Added in XMMS 1.2.6 */
typedef void  (* _player_play_pause) (gint session);
typedef void  (* _player_playlist_ins_url_string) (gint session, gchar * string, gint pos);
/* Added in XMMS 1.2.11 */
typedef void  (* _player_playqueue_add) (gint session, gint pos);
typedef void  (* _player_playqueue_remove) (gint session, gint pos);
typedef gint  (* _player_get_playqueue_length) (gint session);
typedef void  (* _player_toggle_advance) (gint session);
typedef gboolean  (* _player_is_advance) (gint session);
/* Added in BMP 0.9.7 */
typedef void  (* _player_activate) (gint session);
/* Added in Audacious 1.1 */
typedef void  (* _player_show_jtf_box) (gint session);
typedef void  (* _player_playqueue_clear) (gint session);
typedef gboolean  (* _player_playqueue_is_queued) (gint session, gint pos);
typedef gint  (* _player_get_playqueue_position) (gint session, gint pos);
typedef gint  (* _player_get_playqueue_queue_position) (gint session, gint pos);

/**
 * player control functions
 * filled by zero if a player not support specific function
 * @see xmmsctrl.h or beepctrl.h
 */
typedef struct {
	/** internally used. do not use directory */
	GModule *library;

	// functions
	_player_playlist player_playlist;
	_player_get_version player_get_version;
	_player_playlist_add player_playlist_add;
	_player_playlist_delete player_playlist_delete;
	_player_play player_play;
	_player_pause player_pause;
	_player_stop player_stop;
	_player_is_playing player_is_playing;
	_player_is_paused player_is_paused;
	_player_get_playlist_pos player_get_playlist_pos;
	_player_set_playlist_pos player_set_playlist_pos;
	_player_get_playlist_length player_get_playlist_length;
	_player_playlist_clear player_playlist_clear;
	_player_get_output_time player_get_output_time;
	_player_jump_to_time player_jump_to_time;
	_player_get_volume player_get_volume;
	_player_get_main_volume player_get_main_volume;
	_player_get_balance player_get_balance;
	_player_set_volume player_set_volume;
	_player_set_main_volume player_set_main_volume;
	_player_set_balance player_set_balance;
	_player_get_skin player_get_skin;
	_player_set_skin player_set_skin;
	_player_get_playlist_file player_get_playlist_file;
	_player_get_playlist_title player_get_playlist_title;
	_player_get_playlist_time player_get_playlist_time;
	_player_get_info player_get_info;
	_player_main_win_toggle player_main_win_toggle;
	_player_pl_win_toggle player_pl_win_toggle;
	_player_eq_win_toggle player_eq_win_toggle;
	_player_is_main_win player_is_main_win;
	_player_is_pl_win player_is_pl_win;
	_player_is_eq_win player_is_eq_win;
	_player_show_prefs_box player_show_prefs_box;
	_player_toggle_aot player_toggle_aot;
	_player_eject player_eject;
	_player_playlist_prev player_playlist_prev;
	_player_playlist_next player_playlist_next;
	_player_playlist_add_url_string player_playlist_add_url_string;
	_player_is_running player_is_running;
	_player_toggle_repeat player_toggle_repeat;
	_player_toggle_shuffle player_toggle_shuffle;
	_player_is_repeat player_is_repeat;
	_player_is_shuffle player_is_shuffle;
	_player_get_eq player_get_eq;
	_player_get_eq_preamp player_get_eq_preamp;
	_player_get_eq_band player_get_eq_band;
	_player_set_eq player_set_eq;
	_player_set_eq_preamp player_set_eq_preamp;
	_player_set_eq_band player_set_eq_band;
	/* Added in XMMS 1.2.1 */
	_player_quit player_quit;
	/* Added in XMMS 1.2.6 */
	_player_play_pause player_play_pause;
	_player_playlist_ins_url_string player_playlist_ins_url_string;
	/* Added in XMMS 1.2.11 */
	_player_playqueue_add player_playqueue_add;
	_player_playqueue_remove player_playqueue_remove;
	_player_get_playqueue_length player_get_playqueue_length;
	_player_toggle_advance player_toggle_advance;
	_player_is_advance player_is_advance;
	/* Added in BMP 0.9.7 */
	_player_activate player_activate;
	/* Added in Audacious 1.1 */
	_player_show_jtf_box player_show_jtf_box;
	_player_playqueue_clear player_playqueue_clear;
	_player_playqueue_is_queued player_playqueue_is_queued;
	_player_get_playqueue_position player_get_playqueue_position;
	_player_get_playqueue_queue_position player_get_playqueue_queue_position;
} PlayerCtrl;

/**
 * get command name from ID
 */
gchar * player_control_get_command(Players id);

/**
 * load library from ID
 * @return returns NULL if library is not found
 */
PlayerCtrl * player_control_get_instance(Players id);

/**
 * unload library
 * must call this function after using PlayerCtrl instance
 * @see player_control_get_instance(), player_control_load_library()
 */
void player_control_close(PlayerCtrl *instance);

/**
 * check whether a library is exist or not
 */
gboolean player_control_has_library(gchar *libname);

/**
 * load library
 * @param lib_name player library name (Eg. "xmms", "beep", "audacious")
 * @return returns NULL if library is not found
 */
PlayerCtrl * player_control_load_library(gchar *libname);

#endif

/* <Leader>ere (create struct members)
File.open("/usr/include/audacious/beepctrl.h") {|file|
	buf = ""
	file.each() {|line|
		case line
		when /\s*.+(xmms_remote.+)\(.+/
			print "_player#{$1[11..-1]} player#{$1[11..-1]};"
		when /\/\*.*\*\//
			print(line.strip)
		end
	}
}
*/

/* <Leader>ere (create typedefs)
File.open("/usr/include/audacious/beepctrl.h") {|file|
buf = ""
	file.each() {|line|
		case line
		when /\s*(.+)(xmms_remote.+)(\(.+\);)/
			print "typedef #{$1} (* _player#{$2[11..-1]}) #{$3}"
		when /\s*(.+)(xmms_.+)(\(.+)/
			buf = "typedef #{$1} (* _player#{$2[11..-1]}) #{$3}"
		when /\);/
			print buf + " " + line.strip
		when /\/\*.*\*\//
			print(line.strip)
		end
	}
}
*/
