/*
 * Module for memory management.
 * Indeed, providing wrapper functions just for error check.
 *
 * Copyright INOUE Seiichiro <inoue@ainet.or.jp>, licensed under the GPL.
 */
#include <stdio.h>
#include <stdlib.h>

#include "mem.h"

/**
 * xmalloc:
 * Just for error check of malloc's return value.
 **/
void*
xmalloc(size_t size)
{
	void *p;

	if ((p = malloc(size)) == NULL) {
		perror("malloc");
		exit(1);
	}
	return p;
}

/**
 * xrealloc:
 * Just for error check of realloc's return value.
 **/
void*
xrealloc(void *ptr, size_t size)
{
	void *p;

	if ((p = realloc(ptr, size)) == NULL) {
		perror("realloc");
		exit(1);
	}
	return p;
}

/**
 * xcalloc:
 * Just for error check of calloc's return value.
 **/
void*
xcalloc(size_t nmemb, size_t size)
{
	void *p;

	if ((p = calloc(nmemb, size)) == NULL) {
		perror("calloc");
		exit(1);
	}
	return p;
}
