/*****************************************************************************/
/******************************** Documentation ******************************/
/*****************************************************************************/

/*****************************************************************************/
/******************************* Include Files *******************************/
/*****************************************************************************/

/*****************************************************************************/
/*********************************** Defines *********************************/
/*****************************************************************************/

#define DATABUF_FLAG_PRESERVE_HEAD (1 << 0)


/*****************************************************************************/
/******************************* Type Definitions ****************************/
/*****************************************************************************/

typedef struct Databuf {
    unsigned flags;
    size_t alloc_size;
    char *alloc_ptr;
    size_t offset;
    size_t len;
    size_t max_len;
} DataBuf;

/*****************************************************************************/
/*************************  External Global Variables  ***********************/
/*****************************************************************************/

/*****************************************************************************/
/*****************************  Inline Functions  ****************************/
/*****************************************************************************/

static inline char *databuf_beg(DataBuf *db)
{return (db->alloc_ptr == NULL) ? NULL : db->alloc_ptr+db->offset;}

static inline char *databuf_end(DataBuf *db)
{return (db->alloc_ptr == NULL) ? NULL : db->alloc_ptr+db->offset+db->len;}

static inline char *databuf_alloc_end(DataBuf *db)
{return (db->alloc_ptr == NULL) ? NULL : db->alloc_ptr+db->alloc_size;}

static inline int databuf_tail_size(DataBuf *db)
{return db->alloc_size - (db->offset+db->len);}

static inline int databuf_tail_available(DataBuf *db, size_t append_len)
{return append_len <= databuf_tail_size(db);}

static inline size_t databuf_free_size(DataBuf *db)
{return db->alloc_size-db->len;}

/*****************************************************************************/
/****************************  Exported Functions  ***************************/
/*****************************************************************************/

void databuf_print(DataBuf *db, int print_data, char *fmt, ...);
int databuf_init(DataBuf *db, size_t size, unsigned flags);
int databuf_free(DataBuf *db);
int databuf_append(DataBuf *db, const char *src, size_t src_size);
int databuf_advance(DataBuf *db, size_t advance);
int databuf_compress(DataBuf *db);
int databuf_reset(DataBuf *db);

