/* inv-ids.h: file inventory ids
 *
 ****************************************************************
 * Copyright (C) 2002, 2003 Tom Lord
 *
 * See the file "COPYING" for further information about
 * the copyright and warranty status of this work.
 */

#ifndef INCLUDE__LIBARCH__INV_IDS_H
#define INCLUDE__LIBARCH__INV_IDS_H


#include "hackerlab/machine/types.h"
#include "hackerlab/os/sys/stat.h"
#include "libawk/associative.h"
#include "libawk/relational.h"



enum arch_inventory_category
{
  arch_inventory_source = 1,
  arch_inventory_precious = 2,
  arch_inventory_backup = 4,
  arch_inventory_junk = 8,
  arch_inventory_tree = 16,
  arch_inventory_unrecognized = 32,
  arch_inventory_excludes = 64
};


#include "libarch/project-tree.h"


/* automatically generated __STDC__ prototypes */
extern t_uchar * arch_log_file_id (t_uchar * archive, t_uchar * revision);
extern assoc_table arch_filenames_ids (rel_table * file_list, arch_project_tree_t * tree);
extern t_uchar * arch_id_for_path(t_uchar const * const some_path, enum arch_id_tagging_method method);
extern t_uchar * arch_inventory_id (arch_project_tree_t * tree,
                                     t_uchar const * const path,
                                     struct stat * known_lstat);
extern t_uchar * arch_id_tagging_method_name (enum arch_id_tagging_method m);
extern enum arch_id_tagging_method arch_id_tagging_method_from_name (t_uchar * name);
extern t_uchar * arch_default_id_tagging_method_contents (enum arch_id_tagging_method method);
extern t_uchar * arch_tree_id_tagging_method_file (arch_project_tree_t * tree);
extern enum arch_id_tagging_method arch_tree_id_tagging_method (arch_project_tree_t * tree, enum arch_inventory_category * cat_var, int strict);
extern void arch_set_tree_id_tagging_method (arch_project_tree_t * tree,
                                          enum arch_id_tagging_method method);
extern t_uchar * arch_explicit_id_file_for (t_uchar * path);
extern t_uchar * arch_generate_id (void);
extern t_uchar * arch_choose_explicit_id (arch_project_tree_t * tree, t_uchar * path, t_uchar * id);
extern t_uchar * arch_add_id (t_uchar * path, t_uchar * id);
extern void arch_add_explicit_id (t_uchar * path, t_uchar * id);
extern void arch_delete_explicit_id (t_uchar * path);
extern void arch_move_explicit_id (t_uchar * from, t_uchar * to);
extern t_uchar * arch_strong_explicit_dflt_file (t_uchar * dir);
extern t_uchar * arch_weak_explicit_dflt_file (t_uchar * dir);
extern t_uchar * arch_dont_care_explicit_dflt_file (t_uchar * dir);
extern int arch_is_dont_care_explicit_dflt_dir (t_uchar * dir);
extern void arch_delete_strong_explicit_default (t_uchar * dir);
extern void arch_delete_weak_explicit_default (t_uchar * dir);
extern void arch_delete_dont_care_explicit_default (t_uchar * dir);
extern void arch_set_strong_explicit_default (t_uchar * dir, t_uchar * id);
extern void arch_set_weak_explicit_default (t_uchar * dir, t_uchar * id);
extern void arch_set_dont_care_explicit_default (t_uchar * dir);
extern t_uchar *arch_id_from_explicit_file (int *errn, t_uchar * path);
/* TODO: move to hackerlab */
extern int str_cmp_suffix_n(t_uchar * a_string, t_uchar * b_string, int length);
#endif  /* INCLUDE__LIBARCH__INV_IDS_H */


/* tag: Tom Lord Sat Jan  5 15:26:10 2002 (inv-tags.h)
 */
