#!/bin/sh
# -*- mode: sh; coding: utf-8 -*-
# Simple cachrevs
# Copyright © 2004 Canonical Ltd.
#
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.

set -e

arg0="$0"
srcdir=`dirname "$arg0"`

. ${srcdir}/test-framework

setup_with_somewhat_interesting_explicit_archives

test_class "cacherev"

commit_a_patch()
{
  DATA=$1

  tla get jane@example.com--2003/hello-world--mainline--1.0 foo-source
  cd foo-source
  TMP=`echo "$1" | sed -n 's/[^0-9A-Za-z]//gp'`
  echo $DATA >> $TMP
  tla add $TMP
  tla commit -s "Adding $TMP with info '$DATA'"
  cd ..
  rm -rf foo-source
}

commit_a_patch "get past patch-1"
commit_a_patch "senseless patch";
commit_a_patch "another senseless patch";

tla cache-config --disable

begin_test "patch-1 has been automatically cachereved."
  test "$(tla cachedrevs jane@example.com--2003/hello-world--mainline--1.0)" = "hello-world--mainline--1.0--patch-1" || test_fail "patch-1 has not been cachereved"
  tla uncacherev jane@example.com--2003/hello-world--mainline--1.0--patch-1
  test -z "$(tla cachedrevs jane@example.com--2003/hello-world--mainline--1.0)"
end_test 

begin_test "Cachereving a revision when not in a working tree"
  test -z "$(tla cachedrevs jane@example.com--2003/hello-world--mainline--1.0)"
  tla cacherev jane@example.com--2003/hello-world--mainline--1.0--patch-2
  test "$(tla cachedrevs jane@example.com--2003/hello-world--mainline--1.0)" = "hello-world--mainline--1.0--patch-2"
  tla uncacherev jane@example.com--2003/hello-world--mainline--1.0--patch-2
end_test


begin_test "Cachereving by using working tree tree-version"
  tla get jane@example.com--2003/hello-world--mainline--1.0--base-0 hello-world
  cd hello-world

  tla uncacherev jane@example.com--2003/hello-world--mainline--1.0--base-0

  test -z "$(tla cachedrevs jane@example.com--2003/hello-world--mainline--1.0)"

  tla cacherev

  test "$(tla cachedrevs jane@example.com--2003/hello-world--mainline--1.0)" = \
    "hello-world--mainline--1.0--base-0"

  tla uncacherev jane@example.com--2003/hello-world--mainline--1.0--base-0
 
  cd .. 
  rm -rf hello-world

end_test

begin_test "Specifying a revision to cacherev while in a working tree"

  test -z "$(tla cachedrevs jane@example.com--2003/hello-world--mainline--1.0)"

  tla get jane@example.com--2003/hello-world--mainline--1.0--base-0 hello-world

  cd hello-world

  tla cacherev jane@example.com--2003/hello-world--mainline--1.0--patch-2

  test "$(tla cachedrevs jane@example.com--2003/hello-world--mainline--1.0)" = \
    "hello-world--mainline--1.0--patch-2"

  tla uncacherev jane@example.com--2003/hello-world--mainline--1.0--patch-2

  cd ..
  rm -rf hello-world

end_test

begin_test "Specifing just a package to cacherev"

  test -z "$(tla cachedrevs jane@example.com--2003/hello-world--mainline--1.0)"

  tla cacherev jane@example.com--2003/hello-world--mainline

  test "$(tla cachedrevs jane@example.com--2003/hello-world--mainline--1.0)" = \
    "hello-world--mainline--1.0--patch-3"

  tla uncacherev jane@example.com--2003/hello-world--mainline--1.0--patch-3

  cd ..
  rm -rf hello-world

end_test


begin_test "Specifing just a version to cacherev"

  test -z "$(tla cachedrevs jane@example.com--2003/hello-world--mainline--1.0)"

  tla cacherev jane@example.com--2003/hello-world--mainline--1.0

  test "$(tla cachedrevs jane@example.com--2003/hello-world--mainline--1.0)" = \
    "hello-world--mainline--1.0--patch-3"

  tla uncacherev jane@example.com--2003/hello-world--mainline--1.0--patch-3

  cd ..
  rm -rf hello-world

end_test

begin_test "Specifying just a patchlevel to cacherev"
  tla get jane@example.com--2003/hello-world--mainline--1.0--base-0 hello-world
  cd hello-world
  test -z "$(tla cachedrevs)"
  tla cacherev patch-1
  test "$(tla cachedrevs)" = "hello-world--mainline--1.0--patch-1"
  tla uncacherev jane@example.com--2003/hello-world--mainline--1.0--patch-1
  cd .. 
  rm -rf hello-world
end_test

begin_test "cachedrevs in a project tree"
tla get jane@example.com--2003/hello-world--mainline--1.0 foo
cd foo
test -z "$(tla cachedrevs)"
end_test

clean_workdir

# tag: James Blackwell Wed Nov 10 23:43:28 EST 2004 (test-cacherev.sh)
