//  BMPx - The Dumb Music Player
//  Copyright (C) 2005 BMPx development team.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License Version 2
//  as published by the Free Software Foundation.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non-GPL compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#ifndef BMP_UI_PART_DOWNLOADS_HH
#define BMP_UI_PART_DOWNLOADS_HH

#include <gtkmm.h>
#include <libglademm.h>

#include <moo/types.hh>
#include <moo/driver.hh>

#include "playbacksource.hh"
#include "ui-part-base.hh"

namespace Bmp
{
  namespace UiPart
  {
    class Downloads : public Bmp::PlaybackSource, public Bmp::UiPart::Base
    {
      public:

          Downloads (Glib::RefPtr<Gnome::Glade::Xml> const& xml, Glib::RefPtr<Gtk::UIManager> ui_manager);
          ~Downloads ();

          typedef sigc::signal<void, Bmp::VUri&> SignalRequestImport;

          SignalRequestImport&
          signal_request_import () { return s_request_import_; }

      protected:

        virtual guint
        add_ui ();
       
        virtual Glib::ustring
        get_uri ();

        virtual Glib::ustring
        get_type () { return Glib::ustring(); }

        virtual bool
        go_next () { return false; }

        virtual bool
        go_prev () { return false; }

        virtual void
        stop () {}
  
        virtual void
        play () {}

        virtual void
        play_requested () {}

        virtual void
        restore_context () {}

        virtual GHashTable*
        get_metadata () { return NULL; }

      private:

        SignalRequestImport s_request_import_;

        struct SearchContext;
        typedef std::map<unsigned int, SearchContext*> SearchContextsT; 
        typedef std::map<int, SearchContext*> SearchContextsByTabT; 
        typedef std::map<Moo::XFERKey, Gtk::TreeModel::iterator> XFERMapT;

        class SearchCR
          : public Gtk::TreeModel::ColumnRecord
        {
          public:

            Gtk::TreeModelColumn<Glib::ustring> username;
            Gtk::TreeModelColumn<Glib::ustring> basename;
            Gtk::TreeModelColumn<unsigned int>  filesize;
            Gtk::TreeModelColumn<unsigned int>  slot;
            Gtk::TreeModelColumn<unsigned int>  speed;
            Gtk::TreeModelColumn<unsigned int>  queue;
            Gtk::TreeModelColumn<Glib::ustring> basepath;
            Gtk::TreeModelColumn<Glib::ustring> path;

            SearchCR ()
            {
              add (username);
              add (basename);
              add (filesize);
              add (slot);
              add (speed);
              add (queue);
              add (basepath);
              add (path);
            }
        };
        SearchCR cr_search;

        struct SearchContext
        {
          int                          m_tab;

          Glib::ustring                name;

          Gtk::Image                   image;
          Gtk::Label                   label;
          Gtk::Button                  button;
          Gtk::HBox                    hbox;
    
          Gtk::TreeView                treeview;
          Gtk::ScrolledWindow          sw;
          Glib::RefPtr<Gtk::ListStore> store;

          sigc::connection conn1;
          sigc::connection conn2;
          sigc::connection conn3;

          bool append;

          SearchContext (std::string const& search_name, const Gtk::TreeModel::ColumnRecord &record, int tab);
          ~SearchContext () {};
        };

        SearchContextsT contexts;
        SearchContextsByTabT contexts_by_tab;
        Glib::Mutex contexts_lock;

        // --- UI Callbacks
        void start_search    ();
        void cancel_search   (int tab, unsigned int ticket);
        void start_transfer  (const Gtk::TreeModel::Path&      path,
                              Gtk::TreeViewColumn             *column,
                              SearchContext                   *ctx); 
        void start_transfers ();
        void cancel ();
        void retry  ();

        bool popup_searches_menu    (GdkEvent *);

        bool popup_xfer_down_menu   (GdkEvent *);
        bool popup_xfer_up_menu     (GdkEvent *);

        void import_tracks_as_album ();

        // --- Moo Callbacks
        void s_search_callback (std::string name, unsigned int ticket);
        void s_search_result_callback (Moo::SearchResult result);
        void s_transfer_update_callback (Moo::XFERKey key, Moo::Transfer);

        // ---------- Transfers
        class TransferCR
          : public Gtk::TreeModel::ColumnRecord
        {
          public:

            Gtk::TreeModelColumn<Glib::ustring>       user;
            Gtk::TreeModelColumn<Glib::ustring>       basename;
            Gtk::TreeModelColumn<int>                 percentage;
            Gtk::TreeModelColumn<Glib::ustring>       size_str;
            Gtk::TreeModelColumn<Glib::ustring>       rate;
            Gtk::TreeModelColumn<Glib::ustring>       state_str;
            Gtk::TreeModelColumn<Glib::ustring>       basepath;
            Gtk::TreeModelColumn<Glib::ustring>       path;
            Gtk::TreeModelColumn<Moo::TransferState>  state;
            Gtk::TreeModelColumn<gint64>              position;
            Gtk::TreeModelColumn<gint64>              size;

            TransferCR ()
            {
              add (user);
              add (basename);
              add (percentage);
              add (size_str);
              add (rate);
              add (state_str);
              add (basepath);
              add (path);
              add (state);
              add (position);
              add (size);
            }
        };
        TransferCR cr_xfer;

        enum
        {
          DOWN,
          UP,
          N_WAYS
        };

        XFERMapT xfermap[N_WAYS];
        XFERMapT xfermap_schedule_remove[N_WAYS];

        enum RemoveAction
        {
          R_SELECTED,
          R_FINISHED,
          R_ABORTED,
          R_QUEUED,
          R_OFFLINE,
        };

        void remove (RemoveAction action);

        // -- Widgets+Etc

        Gtk::Entry                         *e_search;
        Gtk::Notebook                      *notebook_searches;
        Gtk::Notebook                      *notebook_transfers;

        void mcs_enable_mood_changed  (MCS_CB_DEFAULT_SIGNATURE);
        void mood_status_message      (bool server_peer, std::string message);
        void mood_server_state        (bool connected, std::string message);
        void mood_login               (bool ok, std::string message);
        void mood_disconnect          ();
        void mood_connect             ();

        Glib::RefPtr<Gtk::TextBuffer> mood_buffer;
        Glib::RefPtr<Gtk::TextTag>    tag_b;
        Glib::RefPtr<Gtk::TextTag>    tag_i;
        Gtk::ToggleButton            *mood_enable;
        Gtk::Adjustment              *mood_adjustment;
        Gtk::TextView                *mood_textview;

        int  n_tabs;

        Gtk::TreeView                      *xfer_view[N_WAYS];
        Glib::RefPtr<Gtk::ListStore>        xfer_store[N_WAYS];

        void uploads_row_inserted (const Gtk::TreeModel::Path&, const Gtk::TreeModel::iterator&);
        void uploads_row_deleted  (const Gtk::TreeModel::Path&);
        void uploads_selection_changed ();

        void downloads_row_inserted (const Gtk::TreeModel::Path&, const Gtk::TreeModel::iterator&);
        void downloads_row_deleted  (const Gtk::TreeModel::Path&);
        void downloads_selection_changed ();

        void 
        actions_set_sensitive (bool sensitive);
        void
        set_selection_based_controls_sensitive (bool sensitive);
        void
        notebook_transfers_switch_page (GtkNotebookPage *page, guint page);
        void
        notebook_searches_switch_page (GtkNotebookPage *p, guint page);

        Glib::RefPtr<Gtk::ActionGroup> m_actions;
    };
  }
} // !Bmp::

#endif // !BMP_UI_PART_DOWNLOADS_HH

