//  BMPx - The Dumb Music Player
//  Copyright (C) 2005 BMPx development team.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non-GPL compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtkmm.h>
#include <glibmm.h>
#include <libglademm.h>

#include "main.hh"
#include "paths.hh"
#include "stock.hh"
#include "network.hh"

#include "ui-part-shoutcast-streams.hh"
#include "streams-shoutcast.hh"

#include "x_play.hh"
#include "x_vfs.hh"

namespace
{
  void
  on_shoutcast_filter_changed (Bmp::Streams::Shoutcast::Streams *streams, Gtk::Entry *entry)
  {
    streams->filter (entry->get_text());
  }
}

namespace Bmp
{
  namespace UiPart
  {

    guint
    ShoutcastStreams::add_ui ()
    {
      return 0;
    };

    ShoutcastStreams::ShoutcastStreams (Glib::RefPtr<Gnome::Glade::Xml> const& xml, Glib::RefPtr<Gtk::UIManager> ui_manager)

          : Base (xml, ui_manager) 

    {
      if (!Network::check_host("www.gwww.shoutcast.com"))
        {
          m_ref_xml->get_widget ("vbox-shoutcast")->set_sensitive (false);
          return;
        }

      dynamic_cast<Gtk::Image *>(m_ref_xml->get_widget ("throbber-shoutcast"))->set
          (Glib::build_filename (BMP_IMAGE_DIR,BMP_THROBBER));

      m_ref_xml->get_widget_derived ("shoutcast-genres", shoutcast_genres);
      m_ref_xml->get_widget_derived ("shoutcast-streams", shoutcast_streams);

      shoutcast_genres->s_list_updated().connect
            (sigc::mem_fun (shoutcast_streams, &Bmp::Streams::Shoutcast::Streams::set_streams));

      Gtk::Notebook *notebook = dynamic_cast<Gtk::Notebook *>(m_ref_xml->get_widget ("notebook-shoutcast-streams"));

      shoutcast_genres->s_start().connect
            (sigc::bind (sigc::mem_fun (notebook, &Gtk::Notebook::set_current_page), 1));
      shoutcast_genres->s_stop().connect
            (sigc::bind (sigc::mem_fun (notebook, &Gtk::Notebook::set_current_page), 0));

      Gtk::Entry *entry = dynamic_cast<Gtk::Entry *>(m_ref_xml->get_widget ("shoutcast-filter"));

      entry->signal_changed().connect
            (sigc::bind (sigc::ptr_fun (&on_shoutcast_filter_changed), shoutcast_streams, entry));
                         
      shoutcast_streams->get_selection()->signal_changed().connect
            (sigc::mem_fun (this, &Bmp::UiPart::ShoutcastStreams::selection_changed));
      shoutcast_streams->signal_row_activated().connect
            (sigc::mem_fun (this, &Bmp::UiPart::ShoutcastStreams::activate_default));

      dynamic_cast<Gtk::Button *>(m_ref_xml->get_widget ("b_shoutcast_genre_refresh"))->signal_clicked().connect
            (sigc::bind (sigc::mem_fun (shoutcast_genres, &Bmp::Streams::Shoutcast::Genres::refresh), true));
    }

    void
    ShoutcastStreams::activate_default (Gtk::TreeModel::Path const& path, Gtk::TreeViewColumn* column)
    {
      dynamic_cast<Gtk::Window *>(m_ref_xml->get_widget ("main-ui"))->activate_default ();
    }

    void
    ShoutcastStreams::play_set_title (const char *title)
    {
      m_current_title = title;
      Glib::ustring _title;

      SimpleTrackInfo sti;

      sti.artist  = m_current_name;
      sti.title   = m_current_title;

      _title  .append (Glib::Markup::escape_text (m_current_title.get()))
              .append (" (<i>")
              .append (Glib::Markup::escape_text (m_current_name.get())
              .append ("</i>)"));

      s_track_info_.emit (_title, sti); 
    }

    void
    ShoutcastStreams::selection_changed ()
    {
      // Playbacksource
      if (shoutcast_streams->get_selection ()->count_selected_rows() == 1)
        m_caps = Caps (m_caps |  PlaybackSource::CAN_PLAY);
      else
        m_caps = Caps (m_caps & ~PlaybackSource::CAN_PLAY);

      s_caps_.emit (m_caps);
    }

    Glib::ustring
    ShoutcastStreams::get_uri ()
    {
      return m_current_uri.get();
    }

    bool
    ShoutcastStreams::go_next ()
    {
      return false;
    }

    bool
    ShoutcastStreams::go_prev ()
    {
      return false;
    }

    void
    ShoutcastStreams::stop ()
    {
      title_conn.disconnect ();

      if (m_current_title) m_current_title.reset();
      if (m_current_uri)   m_current_uri.reset();

      m_caps = Caps (m_caps & ~PlaybackSource::CAN_PAUSE);
      s_caps_.emit (m_caps); 
    }

    void
    ShoutcastStreams::play ()
    {
      using namespace Glib;

      title_conn = ::play->signal_title().connect
            (sigc::mem_fun (this, &Bmp::UiPart::ShoutcastStreams::play_set_title));

      ustring name, uri;
      shoutcast_streams->get_stream (name, uri);

      VUri list;
      VFS::Handle handle = VFS::Handle (uri);

      try {
        vfs->read (handle, list);
        }
      catch (VFS::Exception &cxe)
        {
          throw UnableToInitiatePlaybackError(cxe.what());
        }

      m_current_name  = name; 
      m_current_uri   = list[0];
      m_current_title = list[0];

      play_set_title (m_current_title.get().c_str());
      m_caps = Caps (m_caps | PlaybackSource::CAN_PAUSE);
      s_caps_.emit (m_caps); 
    }

    void
    ShoutcastStreams::restore_context ()
    {
    }
  }
}
