/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Enumeration;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPEntry;
import netscape.ldap.util.ByteBuf;
import netscape.ldap.util.MimeBase64Encoder;

public abstract class LDAPWriter
implements Serializable {
    protected PrintWriter m_pw;
    private static MimeBase64Encoder m_encoder = new MimeBase64Encoder();

    public LDAPWriter(PrintWriter printWriter) {
        this.m_pw = printWriter;
    }

    protected String getPrintableValue(byte[] byArray) {
        String string = "";
        ByteBuf byteBuf = new ByteBuf(byArray, 0, byArray.length);
        ByteBuf byteBuf2 = new ByteBuf();
        m_encoder.translate(byteBuf, byteBuf2);
        int n = byteBuf2.length();
        if (n > 0) {
            string = new String(byteBuf2.toBytes(), 0, n);
        }
        return string;
    }

    protected abstract void printAttribute(LDAPAttribute var1);

    public void printEntry(LDAPEntry lDAPEntry) throws IOException {
        this.printEntryStart(lDAPEntry.getDN());
        LDAPAttributeSet lDAPAttributeSet = lDAPEntry.getAttributeSet();
        Enumeration enumeration = lDAPAttributeSet.getAttributes();
        while (enumeration.hasMoreElements()) {
            LDAPAttribute lDAPAttribute = (LDAPAttribute)enumeration.nextElement();
            this.printAttribute(lDAPAttribute);
        }
        this.printEntryEnd(lDAPEntry.getDN());
    }

    protected abstract void printEntryEnd(String var1);

    protected abstract void printEntryStart(String var1);

    public void printSchema(LDAPEntry lDAPEntry) throws IOException {
        this.printEntry(lDAPEntry);
    }
}

