/*
 * Decompiled with CFR 0.152.
 */
package junit.runner;

import java.io.File;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import junit.runner.TestCollector;

public abstract class ClassPathTestCollector
implements TestCollector {
    static final int SUFFIX_LENGTH = ".class".length();

    protected String classNameFromFile(String classFileName) {
        String s = classFileName.substring(0, classFileName.length() - SUFFIX_LENGTH);
        String s2 = s.replace(File.separatorChar, '.');
        if (s2.startsWith(".")) {
            return s2.substring(1);
        }
        return s2;
    }

    void collectFilesInRoots(Vector roots, Vector result) {
        Enumeration e = roots.elements();
        while (e.hasMoreElements()) {
            this.gatherFiles(new File((String)e.nextElement()), "", result);
        }
    }

    public Enumeration collectTests() {
        String classPath = System.getProperty("java.class.path");
        String separator = System.getProperty("path.separator");
        Vector result = new Vector(100);
        this.collectFilesInRoots(this.splitClassPath(classPath, separator), result);
        return result.elements();
    }

    void gatherFiles(File classRoot, String classFileName, Vector result) {
        File thisRoot = new File(classRoot, classFileName);
        if (thisRoot.isFile()) {
            if (this.isTestClass(classFileName)) {
                result.addElement(this.classNameFromFile(classFileName));
            }
            return;
        }
        String[] contents = thisRoot.list();
        int i = 0;
        while (i < contents.length) {
            this.gatherFiles(classRoot, String.valueOf(classFileName) + File.separatorChar + contents[i], result);
            ++i;
        }
    }

    protected boolean isTestClass(String classFileName) {
        return classFileName.endsWith(".class") && classFileName.indexOf(36) < 0 && classFileName.indexOf("Test") > 0;
    }

    Vector splitClassPath(String classPath, String separator) {
        Vector<String> result = new Vector<String>();
        StringTokenizer tokenizer = new StringTokenizer(classPath, separator);
        while (tokenizer.hasMoreTokens()) {
            result.addElement(tokenizer.nextToken());
        }
        return result;
    }
}

