/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.adaptx.xpath;

import org.exolab.adaptx.xpath.XPathResult;

public final class StringResult
extends XPathResult {
    public static final StringResult EMPTY = new StringResult("");
    private final String _value;

    public StringResult() {
        this._value = "";
    }

    public StringResult(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Argument value is null");
        }
        this._value = string;
    }

    public boolean booleanValue() {
        return this._value.length() > 0;
    }

    public boolean equals(XPathResult xPathResult) {
        if (xPathResult == this) {
            return true;
        }
        if (xPathResult != null && xPathResult instanceof StringResult) {
            return ((StringResult)xPathResult)._value.equals(this._value);
        }
        return false;
    }

    public int getResultType() {
        return 2;
    }

    public Object javaObject() {
        return this._value;
    }

    public double numberValue() {
        try {
            Double d = Double.valueOf(this._value.trim());
            return d;
        }
        catch (NumberFormatException numberFormatException) {
            return Double.NaN;
        }
    }

    public String stringValue() {
        return this._value;
    }

    public String toString() {
        return this._value;
    }
}

