/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.adaptx.xpath.functions;

import java.text.DecimalFormat;
import org.exolab.adaptx.xpath.StringResult;
import org.exolab.adaptx.xpath.XPathContext;
import org.exolab.adaptx.xpath.XPathException;
import org.exolab.adaptx.xpath.XPathResult;
import org.exolab.adaptx.xpath.engine.FunctionCall;

public class FormatNumber
extends FunctionCall {
    private static final String FORMAT_NUMBER = "format-number";

    public FormatNumber() {
        super(FORMAT_NUMBER);
    }

    public XPathResult evaluate(XPathContext xPathContext) throws XPathException {
        int n = this.getParameterCount();
        if (n < 2 || n > 3) {
            throw new XPathException("invalid number of parameters for function: " + this);
        }
        XPathResult xPathResult = this.getParameter(0).evaluate(xPathContext);
        double d = xPathResult.numberValue();
        if (Double.isNaN(d)) {
            return new StringResult("NaN");
        }
        if (Double.isInfinite(d)) {
            return new StringResult("Infinite");
        }
        xPathResult = this.getParameter(1).evaluate(xPathContext);
        String string = xPathResult.stringValue();
        String string2 = null;
        if (n == 3) {
            xPathResult = this.getParameter(2).evaluate(xPathContext);
            string2 = xPathResult.stringValue();
        }
        DecimalFormat decimalFormat = new DecimalFormat(string);
        return new StringResult(decimalFormat.format(d));
    }
}

