/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.adaptx.xslt;

import java.util.Enumeration;
import java.util.Hashtable;
import org.exolab.adaptx.net.URILocation;
import org.exolab.adaptx.util.List;
import org.exolab.adaptx.util.Tokenizer;
import org.exolab.adaptx.xslt.AttributeSet;
import org.exolab.adaptx.xslt.Id;
import org.exolab.adaptx.xslt.Param;
import org.exolab.adaptx.xslt.TemplateRule;
import org.exolab.adaptx.xslt.Variable;
import org.exolab.adaptx.xslt.XSLException;
import org.exolab.adaptx.xslt.XSLImport;
import org.exolab.adaptx.xslt.XSLObject;
import org.exolab.adaptx.xslt.XSLOutput;
import org.exolab.adaptx.xslt.XSLScript;

public class XSLTStylesheet
extends XSLObject {
    public static final String XSLT_NAMESPACE = "http://www.w3.org/1999/XSL/Transform";
    private static final String XMLNS_DECL = "xmlns:";
    private static final String XMLNS_ATTR = "xmlns";
    private static final String QUOTE = "quote:";
    private static final String HTTP_PROTOCOL = "http:";
    private static final String FILE_PROTOCOL = "file:";
    private static final Hashtable _emptyHash = new Hashtable(1);
    private Hashtable attributeSets = new Hashtable();
    private Hashtable variables = null;
    private Hashtable parameters = null;
    private URILocation uriLocation = null;
    private Hashtable namedTemplates = null;
    private List extElementPrefixes = new List();
    private Hashtable ids = null;
    private List imports = null;
    private List whitespaceElements = null;
    private List templates = null;
    private List gScripts = new List();
    private StringBuffer error = null;
    private String resultDocType = null;
    private String xslNSPrefix = "xsl";
    private Hashtable namespaces = null;
    private Hashtable quotedns = null;
    private boolean allowImports = true;
    private Hashtable avtMap = null;
    private boolean preserveSpaceByDefault = true;
    XSLOutput output = null;

    public XSLTStylesheet() {
        super((short)31);
        this.ids = new Hashtable();
        this.imports = new List();
        this.namedTemplates = new Hashtable();
        this.namespaces = new Hashtable();
        this.whitespaceElements = new List();
        this.quotedns = new Hashtable();
        this.templates = new List();
        this.output = new XSLOutput();
        super.appendAction(this.output);
        this.ids.put("id", "*");
    }

    public void addAttributeSet(AttributeSet attributeSet) {
        String string = attributeSet.getName();
        AttributeSet attributeSet2 = (AttributeSet)this.attributeSets.get(string);
        this.attributeSets.put(string, attributeSet);
        if (attributeSet2 != null) {
            attributeSet.copyActions(attributeSet2);
            String string2 = attributeSet2.getUseAttributeSets();
            if (string2 != null) {
                if (attributeSet.getUseAttributeSets() != null) {
                    string2 = String.valueOf(string2) + ' ' + attributeSet.getUseAttributeSets();
                }
                attributeSet.setUseAttributeSets(string2);
            }
        }
    }

    public void addId(String string) {
        this.addId(string, "*");
    }

    public void addId(String string, String string2) {
        if (string2 == null) {
            string2 = "*";
        }
        if (!this.ids.contains(string)) {
            this.ids.put(string, string2);
            this.allowImports = false;
        }
    }

    public void addId(Id id) {
        String string = id.getIdAttribute();
        String string2 = id.getElementType();
        this.addId(string, string2);
        super.appendAction(id);
    }

    public void addParam(Param param) throws XSLException {
        this.addParam(param, false);
    }

    private void addParam(Param param, boolean bl) throws XSLException {
        String string = param.getName();
        if (string == null || string.length() == 0) {
            throw new XSLException("missing name for parameter.");
        }
        if (this.variables != null && this.variables.contains(string)) {
            String string2 = "A variable with the same name as the given parameter already exists : ";
            throw new XSLException(String.valueOf(string2) + string);
        }
        if (this.parameters != null && this.parameters.contains(string)) {
            String string3 = "A parameter with the same name as the given parameter already exists : ";
            throw new XSLException(String.valueOf(string3) + string);
        }
        if (this.parameters == null) {
            this.parameters = new Hashtable(5);
        }
        this.allowImports = false;
        this.parameters.put(string, param);
        if (!bl) {
            super.appendAction(param);
        }
    }

    public void addScript(XSLScript xSLScript) {
        this.gScripts.add(xSLScript);
        this.allowImports = false;
    }

    public void addTemplate(TemplateRule templateRule) throws XSLException {
        this.addTemplate(templateRule, false);
    }

    private void addTemplate(TemplateRule templateRule, boolean bl) throws XSLException {
        String string = templateRule.getAttribute("name");
        if (string != null) {
            if (this.namedTemplates.get(string) != null) {
                throw new XSLException("Duplicate template name found: " + string);
            }
            this.namedTemplates.put(string, templateRule);
        }
        this.templates.add(templateRule);
        this.allowImports = false;
        if (!bl) {
            super.appendAction(templateRule);
        }
    }

    public void addVariable(Variable variable) throws XSLException {
        this.addVariable(variable, false);
    }

    private void addVariable(Variable variable, boolean bl) throws XSLException {
        String string = variable.getName();
        if (string == null || string.length() == 0) {
            throw new XSLException("missing name for variable.");
        }
        if (this.variables != null && this.variables.contains(string)) {
            String string2 = "A variable with the same name as the given variable already exists : ";
            throw new XSLException(String.valueOf(string2) + string);
        }
        if (this.parameters != null && this.parameters.contains(string)) {
            String string3 = "A parameter with the same name as the given variable already exists : ";
            throw new XSLException(String.valueOf(string3) + string);
        }
        if (this.variables == null) {
            this.variables = new Hashtable();
        }
        this.allowImports = false;
        this.variables.put(string, variable);
        if (!bl) {
            super.appendAction(variable);
        }
    }

    public boolean appendAction(XSLObject xSLObject) {
        if (xSLObject == null) {
            return false;
        }
        try {
            boolean bl = true;
            switch (xSLObject.getType()) {
                case 25: {
                    this.mergeOutput((XSLOutput)xSLObject);
                    break;
                }
                case 32: {
                    this.addTemplate((TemplateRule)xSLObject);
                    bl = false;
                    break;
                }
                case 4: {
                    this.addAttributeSet((AttributeSet)xSLObject);
                    break;
                }
                case 26: {
                    this.addParam((Param)xSLObject, false);
                    bl = false;
                    break;
                }
                case 35: {
                    this.addVariable((Variable)xSLObject, false);
                    bl = false;
                    break;
                }
                case 15: {
                    this.addId((Id)xSLObject);
                    bl = false;
                    break;
                }
                case 39: {
                    this.addScript((XSLScript)xSLObject);
                    break;
                }
                case 17: {
                    this.importFrom((XSLImport)xSLObject);
                    break;
                }
                case 28: {
                    this.preserveSpace(xSLObject.getAttribute("elements"));
                    break;
                }
                case 30: {
                    this.stripSpace(xSLObject.getAttribute("elements"));
                    break;
                }
                default: {
                    return false;
                }
            }
            if (bl) {
                super.appendAction(xSLObject);
            }
        }
        catch (XSLException xSLException) {
            return false;
        }
        return true;
    }

    private void copyFromXSLStylesheet(XSLTStylesheet xSLTStylesheet) {
        this.copyHashtableInto(this.attributeSets, xSLTStylesheet.getAttributeSets(), true);
        try {
            Variable variable;
            Variable variable2;
            Enumeration enumeration = xSLTStylesheet.getVariables();
            while (enumeration.hasMoreElements()) {
                variable2 = (Variable)enumeration.nextElement();
                variable = this.getVariable(variable2.getName());
                if (variable != null) {
                    this.variables.remove(variable);
                }
                this.addVariable(variable2, true);
            }
            enumeration = xSLTStylesheet.getParameters();
            while (enumeration.hasMoreElements()) {
                variable2 = (Param)enumeration.nextElement();
                variable = this.getParameter(variable2.getName());
                if (variable != null) {
                    this.parameters.remove(variable);
                }
                this.addParam((Param)variable2);
            }
        }
        catch (XSLException xSLException) {}
        this.mergeOutput(xSLTStylesheet.getOutput());
        this.copyHashtableInto(this.ids, xSLTStylesheet.getIds(), true);
        this.copyHashtableInto(this.namespaces, xSLTStylesheet.getNamespaces(), false);
        this.copyHashtableInto(this.quotedns, xSLTStylesheet.getQuotedNamespaces(), false);
        this.copyListInto(this.gScripts, xSLTStylesheet.getScripts());
    }

    private void copyHashtableInto(Hashtable hashtable, Hashtable hashtable2, boolean bl) {
        if (hashtable == null || hashtable2 == null) {
            return;
        }
        Enumeration enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            if (!bl && hashtable.get(k) != null) continue;
            hashtable.put(k, hashtable2.get(k));
        }
    }

    private void copyListInto(List list, List list2) {
        if (list == null || list2 == null) {
            return;
        }
        int n = 0;
        while (n < list2.size()) {
            list.add(list2.get(n));
            ++n;
        }
    }

    private void copyListInto(List list, Object[] objectArray) {
        if (list == null || objectArray == null) {
            return;
        }
        int n = 0;
        while (n < objectArray.length) {
            list.add(objectArray[n]);
            ++n;
        }
    }

    public int countTemplates() {
        int n = this.templates.size();
        int n2 = 0;
        while (n2 < this.imports.size()) {
            n += ((XSLTStylesheet)this.imports.get(n2)).countTemplates();
            ++n2;
        }
        return n;
    }

    public AttributeSet getAttributeSet(String string) {
        return (AttributeSet)this.attributeSets.get(string);
    }

    public Hashtable getAttributeSets() {
        return (Hashtable)this.attributeSets.clone();
    }

    public String getDocumentBase() {
        if (this.uriLocation == null) {
            return "";
        }
        return this.uriLocation.getBaseURI();
    }

    public List getExtensionElementPrefixes() {
        return this.extElementPrefixes;
    }

    public String getHref() {
        if (this.uriLocation == null) {
            return null;
        }
        return this.uriLocation.getAbsoluteURI();
    }

    public Hashtable getIds() {
        return this.ids;
    }

    public List getLocalTemplates() {
        return (List)this.templates.clone();
    }

    public TemplateRule getNamedTemplate(String string) {
        if (string == null) {
            return null;
        }
        TemplateRule templateRule = (TemplateRule)this.namedTemplates.get(string);
        if (templateRule == null) {
            int n = this.imports.size() - 1;
            while (n >= 0) {
                XSLTStylesheet xSLTStylesheet = (XSLTStylesheet)this.imports.get(n);
                templateRule = xSLTStylesheet.getNamedTemplate(string);
                if (templateRule != null) break;
                --n;
            }
        }
        return templateRule;
    }

    public Enumeration getNamedTemplates() {
        return this.namedTemplates.elements();
    }

    protected Hashtable getNamespaces() {
        return this.namespaces;
    }

    public XSLOutput getOutput() {
        return this.output;
    }

    public Param getParameter(String string) {
        if (this.parameters == null || string == null) {
            return null;
        }
        return (Param)this.parameters.get(string);
    }

    public Enumeration getParameters() {
        if (this.parameters == null) {
            return _emptyHash.elements();
        }
        return this.parameters.elements();
    }

    public String getQuotedNamespace(String string) {
        if (string == null) {
            return null;
        }
        String string2 = (String)this.quotedns.get(string);
        if (string2 != null) {
            Enumeration enumeration = this.namespaces.keys();
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                if (!string2.equals(this.namespaces.get(string3))) continue;
                return string3;
            }
        }
        return string;
    }

    protected Hashtable getQuotedNamespaces() {
        return this.quotedns;
    }

    public String getResultDocType() {
        return this.resultDocType;
    }

    public String getResultNamespace() {
        return this.getAttribute("result-ns");
    }

    public List getScripts() {
        return (List)this.gScripts.clone();
    }

    public TemplateRule[] getTemplates() {
        List list = new List(this.countTemplates());
        int n = 0;
        while (n < this.imports.size()) {
            this.copyListInto(list, ((XSLTStylesheet)this.imports.get(n)).getTemplates());
            ++n;
        }
        this.copyListInto(list, this.templates);
        return (TemplateRule[])list.toArray(new TemplateRule[list.size()]);
    }

    public URILocation getURILocation() {
        return this.uriLocation;
    }

    public Variable getVariable(String string) {
        if (this.variables == null || string == null) {
            return null;
        }
        return (Variable)this.variables.get(string);
    }

    public Enumeration getVariables() {
        if (this.variables == null) {
            return _emptyHash.elements();
        }
        return this.variables.elements();
    }

    public String getXSLNSPrefix() {
        return this.xslNSPrefix;
    }

    public void importFrom(XSLImport xSLImport) throws XSLException {
        if (xSLImport == null) {
            return;
        }
        XSLTStylesheet xSLTStylesheet = xSLImport.getStylesheet();
        String string = xSLTStylesheet.getHref();
        if (string != null) {
            if (this.isAllowableImport(string)) {
                this.importWithoutVerify(xSLImport);
            } else {
                throw new XSLException("Stylesheet " + string + " has already been directly or indirectly imported.");
            }
        }
    }

    public void importFrom(XSLTStylesheet xSLTStylesheet) throws XSLException {
        this.importFrom(new XSLImport(xSLTStylesheet));
    }

    protected void importWithoutVerify(XSLImport xSLImport) throws XSLException {
        if (xSLImport == null) {
            return;
        }
        if (!this.allowImports) {
            throw new XSLException("Imports must occur before all other elements of the stylesheet.");
        }
        XSLTStylesheet xSLTStylesheet = xSLImport.getStylesheet();
        if (xSLTStylesheet == null) {
            return;
        }
        this.imports.add(xSLTStylesheet);
        this.copyFromXSLStylesheet(xSLTStylesheet);
    }

    protected void importWithoutVerify(XSLTStylesheet xSLTStylesheet) throws XSLException {
        this.importWithoutVerify(new XSLImport(xSLTStylesheet));
    }

    public void includeFrom(XSLTStylesheet xSLTStylesheet) throws XSLException {
        if (xSLTStylesheet == null) {
            return;
        }
        String string = xSLTStylesheet.getHref();
        if (string != null) {
            if (!this.isAllowableImport(string)) {
                throw new XSLException("Stylesheet '" + string + "' has already been directly or indirectly included.");
            }
        } else {
            throw new XSLException("Stylesheet missing URI Location.");
        }
        this.includeWithoutVerify(xSLTStylesheet);
    }

    protected void includeWithoutVerify(XSLTStylesheet xSLTStylesheet) throws XSLException {
        if (xSLTStylesheet == null) {
            return;
        }
        this.allowImports = false;
        this.copyFromXSLStylesheet(xSLTStylesheet);
        TemplateRule[] templateRuleArray = xSLTStylesheet.getTemplates();
        int n = 0;
        while (n < templateRuleArray.length) {
            this.addTemplate(templateRuleArray[n], true);
            ++n;
        }
    }

    public boolean isAllowableImport(String string) {
        Object object;
        if (this.uriLocation != null && string.equals(object = this.uriLocation.getAbsoluteURI())) {
            return false;
        }
        int n = 0;
        while (n < this.imports.size()) {
            object = (XSLTStylesheet)this.imports.get(n);
            if (!((XSLTStylesheet)object).isAllowableImport(string)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean isStripSpaceAllowed(String string) {
        if (this.preserveSpaceByDefault) {
            return this.whitespaceElements.contains(string);
        }
        return this.whitespaceElements.contains(string) ^ true;
    }

    private void mergeOutput(XSLOutput xSLOutput) {
        String string = null;
        if (xSLOutput.getAttribute("indent") != null) {
            this.output.setIndent(xSLOutput.getIndent());
        }
        if ((string = xSLOutput.getMethod()) != null) {
            this.output.setMethod(xSLOutput.getMethod());
        }
        if ((string = xSLOutput.getDoctypePublicId()) != null) {
            this.output.setDoctypePublicId(string);
        }
        if ((string = xSLOutput.getDoctypeSystemId()) != null) {
            this.output.setDoctypeSystemId(string);
        }
        if ((string = xSLOutput.getVersion()) != null) {
            this.output.setVersion(string);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void preserveSpace(String var1_1) {
        block3: {
            if (var1_1 == null) {
                return;
            }
            var2_2 = new Tokenizer(var1_1);
            if (this.preserveSpaceByDefault) ** GOTO lbl12
            while (var2_2.hasMoreTokens()) {
                this.whitespaceElements.add(var2_2.nextToken());
            }
            break block3;
lbl-1000:
            // 1 sources

            {
                this.whitespaceElements.remove(var2_2.nextToken());
lbl12:
                // 2 sources

                ** while (var2_2.hasMoreTokens())
            }
        }
    }

    public void setAttribute(String string, String string2) throws XSLException {
        if (string.indexOf(XMLNS_DECL) == 0) {
            String string3 = string.substring(XMLNS_DECL.length());
            this.namespaces.put(string3, string2);
            if (string2.indexOf(QUOTE) == 0) {
                this.quotedns.put(string3, string2.substring(QUOTE.length()));
            }
            if (string2.startsWith(XSLT_NAMESPACE)) {
                this.xslNSPrefix = string3;
            }
        } else if ((string = string.intern()) == "default-space") {
            this.preserveSpaceByDefault = "preserve".equals(string2);
        } else if (string == "indent-result") {
            this.output.setIndent("yes".equals(string2));
        } else if (string == "result-ns") {
            this.output.setMethod(string2);
        }
        super.setAttribute(string, string2);
    }

    public void setURILocation(URILocation uRILocation) {
        this.uriLocation = uRILocation;
    }

    /*
     * Unable to fully structure code
     */
    public void stripSpace(String var1_1) {
        block3: {
            if (var1_1 == null) {
                return;
            }
            var2_2 = new Tokenizer(var1_1);
            if (!this.preserveSpaceByDefault) ** GOTO lbl12
            while (var2_2.hasMoreTokens()) {
                this.whitespaceElements.add(var2_2.nextToken());
            }
            break block3;
lbl-1000:
            // 1 sources

            {
                this.whitespaceElements.remove(var2_2.nextToken());
lbl12:
                // 2 sources

                ** while (var2_2.hasMoreTokens())
            }
        }
    }
}

