;;;; -*- Mode: LISP; Syntax: ANSI-Common-Lisp; Base: 10 -*-
;;;;
;;;; CMUCL 19d Patch 001:  Support forward-referenced classes
;;;;

(in-package "PCL")

#+(and :cmu19d (not cmucl-19d-patch-002))
(ext:without-package-locks 
(defun update-class (class finalizep)
  ;;
  ;; Calling UPDATE-SLOTS below sets the class wrapper of CLASS, which
  ;; makes the class finalized.  When UPDATE-CLASS isn't called from
  ;; FINALIZE-INHERITANCE, make sure that this finalization invokes
  ;; FINALIZE-INHERITANCE as per AMOP.  Note that we can't simply
  ;; delay the finalization when CLASS has no forward referenced
  ;; superclasses because that causes bootstrap problems.
  (when (and (not (or finalizep (class-finalized-p class)))
	     (not (class-has-a-forward-referenced-superclass-p class)))
    (finalize-inheritance class)
    (dolist (sub (class-direct-subclasses class))
      (update-class sub nil))
    (return-from update-class))
  ;;
  (when (or finalizep
	    (class-finalized-p class)
	    (not (class-has-a-forward-referenced-superclass-p class)))
    (setf (find-class (class-name class)) class)
    (let ((*allow-forward-referenced-classes-in-cpl-p*
	   (class-has-a-forward-referenced-superclass-p class)))
      (update-cpl class (compute-class-precedence-list class)))
    (update-slots class (compute-slots class))
    (update-gfs-of-class class)
    (update-inits class (compute-default-initargs class))
    (update-shared-slot-values class)
    (update-ctors 'finalize-inheritance :class class))
  ;;
  (unless finalizep
    (dolist (sub (class-direct-subclasses class))
      (update-class sub nil))))
)

(pushnew :cmucl-19d-patch-002 *features*)

