/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <compiz.h>

#define _CUBECAPS_OPTIONS_INTERNAL
#include "cubecaps_options.h"

static int displayPrivateIndex;

static CompMetadata cubecapsOptionsMetadata;

static CompPluginVTable *cubecapsPluginVTable = NULL;
CompPluginVTable cubecapsOptionsVTable;

#define GET_CUBECAPS_OPTIONS_DISPLAY(d) \
        ((CubecapsOptionsDisplay *) (d)->privates[displayPrivateIndex].ptr)

#define CUBECAPS_OPTIONS_DISPLAY(d) \
        CubecapsOptionsDisplay *od = GET_CUBECAPS_OPTIONS_DISPLAY (d)

#define GET_CUBECAPS_OPTIONS_SCREEN(s, od) \
        ((CubecapsOptionsScreen *) (s)->privates[(od)->screenPrivateIndex].ptr)

#define CUBECAPS_OPTIONS_SCREEN(s) \
        CubecapsOptionsScreen *os = GET_CUBECAPS_OPTIONS_SCREEN (s, GET_CUBECAPS_OPTIONS_DISPLAY (s->display))

typedef struct _CubecapsOptionsDisplay
{
    int screenPrivateIndex;

    CompOption opt[CubecapsDisplayOptionNum];
    cubecapsDisplayOptionChangeNotifyProc notify[CubecapsDisplayOptionNum];
} CubecapsOptionsDisplay;

typedef struct _CubecapsOptionsScreen
{
    CompOption opt[CubecapsScreenOptionNum];
    cubecapsScreenOptionChangeNotifyProc notify[CubecapsScreenOptionNum];
} CubecapsOptionsScreen;

CompAction * cubecapsGetTopNext (CompDisplay *d)
{
    CUBECAPS_OPTIONS_DISPLAY(d);
    return &od->opt[CubecapsDisplayOptionTopNext].value.action;
}

void cubecapsSetTopNextInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    CUBECAPS_OPTIONS_DISPLAY(d);
    od->opt[CubecapsDisplayOptionTopNext].value.action.initiate = init;
}

void cubecapsSetTopNextTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    CUBECAPS_OPTIONS_DISPLAY(d);
    od->opt[CubecapsDisplayOptionTopNext].value.action.terminate = term;
}

CompOption * cubecapsGetTopNextOption (CompDisplay *d)
{
    CUBECAPS_OPTIONS_DISPLAY(d);
    return &od->opt[CubecapsDisplayOptionTopNext];
}

void cubecapsSetTopNextNotify (CompDisplay *d, cubecapsDisplayOptionChangeNotifyProc notify)
{
    CUBECAPS_OPTIONS_DISPLAY(d);
    od->notify[CubecapsDisplayOptionTopNext] = notify;
}

CompAction * cubecapsGetTopPrev (CompDisplay *d)
{
    CUBECAPS_OPTIONS_DISPLAY(d);
    return &od->opt[CubecapsDisplayOptionTopPrev].value.action;
}

void cubecapsSetTopPrevInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    CUBECAPS_OPTIONS_DISPLAY(d);
    od->opt[CubecapsDisplayOptionTopPrev].value.action.initiate = init;
}

void cubecapsSetTopPrevTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    CUBECAPS_OPTIONS_DISPLAY(d);
    od->opt[CubecapsDisplayOptionTopPrev].value.action.terminate = term;
}

CompOption * cubecapsGetTopPrevOption (CompDisplay *d)
{
    CUBECAPS_OPTIONS_DISPLAY(d);
    return &od->opt[CubecapsDisplayOptionTopPrev];
}

void cubecapsSetTopPrevNotify (CompDisplay *d, cubecapsDisplayOptionChangeNotifyProc notify)
{
    CUBECAPS_OPTIONS_DISPLAY(d);
    od->notify[CubecapsDisplayOptionTopPrev] = notify;
}

CompAction * cubecapsGetBottomNext (CompDisplay *d)
{
    CUBECAPS_OPTIONS_DISPLAY(d);
    return &od->opt[CubecapsDisplayOptionBottomNext].value.action;
}

void cubecapsSetBottomNextInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    CUBECAPS_OPTIONS_DISPLAY(d);
    od->opt[CubecapsDisplayOptionBottomNext].value.action.initiate = init;
}

void cubecapsSetBottomNextTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    CUBECAPS_OPTIONS_DISPLAY(d);
    od->opt[CubecapsDisplayOptionBottomNext].value.action.terminate = term;
}

CompOption * cubecapsGetBottomNextOption (CompDisplay *d)
{
    CUBECAPS_OPTIONS_DISPLAY(d);
    return &od->opt[CubecapsDisplayOptionBottomNext];
}

void cubecapsSetBottomNextNotify (CompDisplay *d, cubecapsDisplayOptionChangeNotifyProc notify)
{
    CUBECAPS_OPTIONS_DISPLAY(d);
    od->notify[CubecapsDisplayOptionBottomNext] = notify;
}

CompAction * cubecapsGetBottomPrev (CompDisplay *d)
{
    CUBECAPS_OPTIONS_DISPLAY(d);
    return &od->opt[CubecapsDisplayOptionBottomPrev].value.action;
}

void cubecapsSetBottomPrevInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    CUBECAPS_OPTIONS_DISPLAY(d);
    od->opt[CubecapsDisplayOptionBottomPrev].value.action.initiate = init;
}

void cubecapsSetBottomPrevTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    CUBECAPS_OPTIONS_DISPLAY(d);
    od->opt[CubecapsDisplayOptionBottomPrev].value.action.terminate = term;
}

CompOption * cubecapsGetBottomPrevOption (CompDisplay *d)
{
    CUBECAPS_OPTIONS_DISPLAY(d);
    return &od->opt[CubecapsDisplayOptionBottomPrev];
}

void cubecapsSetBottomPrevNotify (CompDisplay *d, cubecapsDisplayOptionChangeNotifyProc notify)
{
    CUBECAPS_OPTIONS_DISPLAY(d);
    od->notify[CubecapsDisplayOptionBottomPrev] = notify;
}

Bool cubecapsGetDrawTop (CompScreen *s)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    return os->opt[CubecapsScreenOptionDrawTop].value.b;
}

CompOption * cubecapsGetDrawTopOption (CompScreen *s)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    return &os->opt[CubecapsScreenOptionDrawTop];
}

void cubecapsSetDrawTopNotify (CompScreen *s, cubecapsScreenOptionChangeNotifyProc notify)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    os->notify[CubecapsScreenOptionDrawTop] = notify;
}

Bool cubecapsGetDrawBottom (CompScreen *s)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    return os->opt[CubecapsScreenOptionDrawBottom].value.b;
}

CompOption * cubecapsGetDrawBottomOption (CompScreen *s)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    return &os->opt[CubecapsScreenOptionDrawBottom];
}

void cubecapsSetDrawBottomNotify (CompScreen *s, cubecapsScreenOptionChangeNotifyProc notify)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    os->notify[CubecapsScreenOptionDrawBottom] = notify;
}

Bool cubecapsGetAdjustTop (CompScreen *s)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    return os->opt[CubecapsScreenOptionAdjustTop].value.b;
}

CompOption * cubecapsGetAdjustTopOption (CompScreen *s)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    return &os->opt[CubecapsScreenOptionAdjustTop];
}

void cubecapsSetAdjustTopNotify (CompScreen *s, cubecapsScreenOptionChangeNotifyProc notify)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    os->notify[CubecapsScreenOptionAdjustTop] = notify;
}

Bool cubecapsGetAdjustBottom (CompScreen *s)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    return os->opt[CubecapsScreenOptionAdjustBottom].value.b;
}

CompOption * cubecapsGetAdjustBottomOption (CompScreen *s)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    return &os->opt[CubecapsScreenOptionAdjustBottom];
}

void cubecapsSetAdjustBottomNotify (CompScreen *s, cubecapsScreenOptionChangeNotifyProc notify)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    os->notify[CubecapsScreenOptionAdjustBottom] = notify;
}

Bool cubecapsGetScaleTopImage (CompScreen *s)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    return os->opt[CubecapsScreenOptionScaleTopImage].value.b;
}

CompOption * cubecapsGetScaleTopImageOption (CompScreen *s)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    return &os->opt[CubecapsScreenOptionScaleTopImage];
}

void cubecapsSetScaleTopImageNotify (CompScreen *s, cubecapsScreenOptionChangeNotifyProc notify)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    os->notify[CubecapsScreenOptionScaleTopImage] = notify;
}

Bool cubecapsGetScaleBottomImage (CompScreen *s)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    return os->opt[CubecapsScreenOptionScaleBottomImage].value.b;
}

CompOption * cubecapsGetScaleBottomImageOption (CompScreen *s)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    return &os->opt[CubecapsScreenOptionScaleBottomImage];
}

void cubecapsSetScaleBottomImageNotify (CompScreen *s, cubecapsScreenOptionChangeNotifyProc notify)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    os->notify[CubecapsScreenOptionScaleBottomImage] = notify;
}

Bool cubecapsGetClampTopToBorder (CompScreen *s)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    return os->opt[CubecapsScreenOptionClampTopToBorder].value.b;
}

CompOption * cubecapsGetClampTopToBorderOption (CompScreen *s)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    return &os->opt[CubecapsScreenOptionClampTopToBorder];
}

void cubecapsSetClampTopToBorderNotify (CompScreen *s, cubecapsScreenOptionChangeNotifyProc notify)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    os->notify[CubecapsScreenOptionClampTopToBorder] = notify;
}

Bool cubecapsGetClampBottomToBorder (CompScreen *s)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    return os->opt[CubecapsScreenOptionClampBottomToBorder].value.b;
}

CompOption * cubecapsGetClampBottomToBorderOption (CompScreen *s)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    return &os->opt[CubecapsScreenOptionClampBottomToBorder];
}

void cubecapsSetClampBottomToBorderNotify (CompScreen *s, cubecapsScreenOptionChangeNotifyProc notify)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    os->notify[CubecapsScreenOptionClampBottomToBorder] = notify;
}

unsigned short * cubecapsGetTopColor (CompScreen *s)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    return os->opt[CubecapsScreenOptionTopColor].value.c;
}

unsigned short cubecapsGetTopColorRed (CompScreen *s)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    return os->opt[CubecapsScreenOptionTopColor].value.c[0];
}

unsigned short cubecapsGetTopColorGreen (CompScreen *s)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    return os->opt[CubecapsScreenOptionTopColor].value.c[1];
}

unsigned short cubecapsGetTopColorBlue (CompScreen *s)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    return os->opt[CubecapsScreenOptionTopColor].value.c[2];
}

unsigned short cubecapsGetTopColorAlpha (CompScreen *s)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    return os->opt[CubecapsScreenOptionTopColor].value.c[3];
}

CompOption * cubecapsGetTopColorOption (CompScreen *s)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    return &os->opt[CubecapsScreenOptionTopColor];
}

void cubecapsSetTopColorNotify (CompScreen *s, cubecapsScreenOptionChangeNotifyProc notify)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    os->notify[CubecapsScreenOptionTopColor] = notify;
}

unsigned short * cubecapsGetBottomColor (CompScreen *s)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    return os->opt[CubecapsScreenOptionBottomColor].value.c;
}

unsigned short cubecapsGetBottomColorRed (CompScreen *s)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    return os->opt[CubecapsScreenOptionBottomColor].value.c[0];
}

unsigned short cubecapsGetBottomColorGreen (CompScreen *s)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    return os->opt[CubecapsScreenOptionBottomColor].value.c[1];
}

unsigned short cubecapsGetBottomColorBlue (CompScreen *s)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    return os->opt[CubecapsScreenOptionBottomColor].value.c[2];
}

unsigned short cubecapsGetBottomColorAlpha (CompScreen *s)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    return os->opt[CubecapsScreenOptionBottomColor].value.c[3];
}

CompOption * cubecapsGetBottomColorOption (CompScreen *s)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    return &os->opt[CubecapsScreenOptionBottomColor];
}

void cubecapsSetBottomColorNotify (CompScreen *s, cubecapsScreenOptionChangeNotifyProc notify)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    os->notify[CubecapsScreenOptionBottomColor] = notify;
}

CompListValue * cubecapsGetTopImages (CompScreen *s)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    return &os->opt[CubecapsScreenOptionTopImages].value.list;
}

CompOption * cubecapsGetTopImagesOption (CompScreen *s)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    return &os->opt[CubecapsScreenOptionTopImages];
}

void cubecapsSetTopImagesNotify (CompScreen *s, cubecapsScreenOptionChangeNotifyProc notify)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    os->notify[CubecapsScreenOptionTopImages] = notify;
}

CompListValue * cubecapsGetBottomImages (CompScreen *s)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    return &os->opt[CubecapsScreenOptionBottomImages].value.list;
}

CompOption * cubecapsGetBottomImagesOption (CompScreen *s)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    return &os->opt[CubecapsScreenOptionBottomImages];
}

void cubecapsSetBottomImagesNotify (CompScreen *s, cubecapsScreenOptionChangeNotifyProc notify)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    os->notify[CubecapsScreenOptionBottomImages] = notify;
}

CompOption * cubecapsGetDisplayOption (CompDisplay *d, CubecapsDisplayOptions num)
{
    CUBECAPS_OPTIONS_DISPLAY(d);
    return &od->opt[num];
}

CompOption * cubecapsGetScreenOption (CompScreen *s, CubecapsScreenOptions num)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    return &os->opt[num];
}

static const CompMetadataOptionInfo cubecapsOptionsDisplayOptionInfo[] = {
    { "top_next", "action", 0, 0, 0 },
    { "top_prev", "action", 0, 0, 0 },
    { "bottom_next", "action", 0, 0, 0 },
    { "bottom_prev", "action", 0, 0, 0 },
};

static Bool cubecapsOptionsSetDisplayOption (CompPlugin *plugin, CompDisplay *d, char *name, CompOptionValue *value)
{
    CUBECAPS_OPTIONS_DISPLAY(d);
    CompOption *o;
    int        index;

    o = compFindOption (od->opt, CubecapsDisplayOptionNum, name, &index);

    if (!o)
        return FALSE;

    switch (index)
    {
     case CubecapsDisplayOptionTopNext:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[CubecapsDisplayOptionTopNext])
                (*od->notify[CubecapsDisplayOptionTopNext]) (d, o, CubecapsDisplayOptionTopNext);
            return TRUE;
        }
        break;
     case CubecapsDisplayOptionTopPrev:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[CubecapsDisplayOptionTopPrev])
                (*od->notify[CubecapsDisplayOptionTopPrev]) (d, o, CubecapsDisplayOptionTopPrev);
            return TRUE;
        }
        break;
     case CubecapsDisplayOptionBottomNext:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[CubecapsDisplayOptionBottomNext])
                (*od->notify[CubecapsDisplayOptionBottomNext]) (d, o, CubecapsDisplayOptionBottomNext);
            return TRUE;
        }
        break;
     case CubecapsDisplayOptionBottomPrev:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[CubecapsDisplayOptionBottomPrev])
                (*od->notify[CubecapsDisplayOptionBottomPrev]) (d, o, CubecapsDisplayOptionBottomPrev);
            return TRUE;
        }
        break;
    default:
        break;
    }
    return FALSE;
}

static CompOption * cubecapsOptionsGetDisplayOptions (CompPlugin *plugin, CompDisplay *d, int *count)
{
    CUBECAPS_OPTIONS_DISPLAY(d);
    *count = CubecapsDisplayOptionNum;
    return od->opt;
}

static const CompMetadataOptionInfo cubecapsOptionsScreenOptionInfo[] = {
    { "draw_top", "bool", 0, 0, 0 },
    { "draw_bottom", "bool", 0, 0, 0 },
    { "adjust_top", "bool", 0, 0, 0 },
    { "adjust_bottom", "bool", 0, 0, 0 },
    { "scale_top_image", "bool", 0, 0, 0 },
    { "scale_bottom_image", "bool", 0, 0, 0 },
    { "clamp_top_to_border", "bool", 0, 0, 0 },
    { "clamp_bottom_to_border", "bool", 0, 0, 0 },
    { "top_color", "color", 0, 0, 0 },
    { "bottom_color", "color", 0, 0, 0 },
    { "top_images", "list", "<type>string</type>", 0, 0 },
    { "bottom_images", "list", "<type>string</type>", 0, 0 },
};

static Bool cubecapsOptionsSetScreenOption (CompPlugin *plugin, CompScreen *s, char *name, CompOptionValue *value)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    CompOption *o;
    int        index;

    o = compFindOption (os->opt, CubecapsScreenOptionNum, name, &index);

    if (!o)
        return FALSE;

    switch (index)
    {
     case CubecapsScreenOptionDrawTop:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[CubecapsScreenOptionDrawTop])
                (*os->notify[CubecapsScreenOptionDrawTop]) (s, o, CubecapsScreenOptionDrawTop);
            return TRUE;
        }
        break;
     case CubecapsScreenOptionDrawBottom:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[CubecapsScreenOptionDrawBottom])
                (*os->notify[CubecapsScreenOptionDrawBottom]) (s, o, CubecapsScreenOptionDrawBottom);
            return TRUE;
        }
        break;
     case CubecapsScreenOptionAdjustTop:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[CubecapsScreenOptionAdjustTop])
                (*os->notify[CubecapsScreenOptionAdjustTop]) (s, o, CubecapsScreenOptionAdjustTop);
            return TRUE;
        }
        break;
     case CubecapsScreenOptionAdjustBottom:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[CubecapsScreenOptionAdjustBottom])
                (*os->notify[CubecapsScreenOptionAdjustBottom]) (s, o, CubecapsScreenOptionAdjustBottom);
            return TRUE;
        }
        break;
     case CubecapsScreenOptionScaleTopImage:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[CubecapsScreenOptionScaleTopImage])
                (*os->notify[CubecapsScreenOptionScaleTopImage]) (s, o, CubecapsScreenOptionScaleTopImage);
            return TRUE;
        }
        break;
     case CubecapsScreenOptionScaleBottomImage:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[CubecapsScreenOptionScaleBottomImage])
                (*os->notify[CubecapsScreenOptionScaleBottomImage]) (s, o, CubecapsScreenOptionScaleBottomImage);
            return TRUE;
        }
        break;
     case CubecapsScreenOptionClampTopToBorder:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[CubecapsScreenOptionClampTopToBorder])
                (*os->notify[CubecapsScreenOptionClampTopToBorder]) (s, o, CubecapsScreenOptionClampTopToBorder);
            return TRUE;
        }
        break;
     case CubecapsScreenOptionClampBottomToBorder:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[CubecapsScreenOptionClampBottomToBorder])
                (*os->notify[CubecapsScreenOptionClampBottomToBorder]) (s, o, CubecapsScreenOptionClampBottomToBorder);
            return TRUE;
        }
        break;
     case CubecapsScreenOptionTopColor:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[CubecapsScreenOptionTopColor])
                (*os->notify[CubecapsScreenOptionTopColor]) (s, o, CubecapsScreenOptionTopColor);
            return TRUE;
        }
        break;
     case CubecapsScreenOptionBottomColor:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[CubecapsScreenOptionBottomColor])
                (*os->notify[CubecapsScreenOptionBottomColor]) (s, o, CubecapsScreenOptionBottomColor);
            return TRUE;
        }
        break;
     case CubecapsScreenOptionTopImages:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[CubecapsScreenOptionTopImages])
                (*os->notify[CubecapsScreenOptionTopImages]) (s, o, CubecapsScreenOptionTopImages);
            return TRUE;
        }
        break;
     case CubecapsScreenOptionBottomImages:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[CubecapsScreenOptionBottomImages])
                (*os->notify[CubecapsScreenOptionBottomImages]) (s, o, CubecapsScreenOptionBottomImages);
            return TRUE;
        }
        break;
    default:
        break;
    }
    return FALSE;
}

static CompOption * cubecapsOptionsGetScreenOptions (CompPlugin *plugin, CompScreen *s, int *count)
{
    CUBECAPS_OPTIONS_SCREEN(s);
    *count = CubecapsScreenOptionNum;
    return os->opt;
}

static Bool cubecapsOptionsInitScreen (CompPlugin *p, CompScreen *s)
{
    CubecapsOptionsScreen *os;
    
    CUBECAPS_OPTIONS_DISPLAY (s->display);

    os = calloc (1, sizeof(CubecapsOptionsScreen));
    if (!os)
        return FALSE;

    s->privates[od->screenPrivateIndex].ptr = os;

    if (!compInitScreenOptionsFromMetadata (s, &cubecapsOptionsMetadata, cubecapsOptionsScreenOptionInfo, os->opt, CubecapsScreenOptionNum))
    {
        free (os);
        return FALSE;
    }
    if (cubecapsPluginVTable && cubecapsPluginVTable->initScreen)
        return cubecapsPluginVTable->initScreen (p, s);
    return TRUE;
}

static void cubecapsOptionsFiniScreen (CompPlugin *p, CompScreen *s)
{
    if (cubecapsPluginVTable && cubecapsPluginVTable->finiScreen)
        return cubecapsPluginVTable->finiScreen (p, s);

    CUBECAPS_OPTIONS_SCREEN (s);


    compFiniScreenOptions (s, os->opt, CubecapsScreenOptionNum);

    free (os);
}

static Bool cubecapsOptionsInitDisplay (CompPlugin *p, CompDisplay *d)
{
    CubecapsOptionsDisplay *od;
   
    
    od = calloc (1, sizeof(CubecapsOptionsDisplay));
    if (!od)
        return FALSE;

    od->screenPrivateIndex = allocateScreenPrivateIndex(d);
    if (od->screenPrivateIndex < 0)
    {
        free(od);
        return FALSE;
    }

    d->privates[displayPrivateIndex].ptr = od;

    if (!compInitDisplayOptionsFromMetadata (d, &cubecapsOptionsMetadata, cubecapsOptionsDisplayOptionInfo, od->opt, CubecapsDisplayOptionNum))
    {
        free (od);
        return FALSE;
    }
    if (cubecapsPluginVTable && cubecapsPluginVTable->initDisplay)
        return cubecapsPluginVTable->initDisplay (p, d);
    return TRUE;
}

static void cubecapsOptionsFiniDisplay (CompPlugin *p, CompDisplay *d)
{
    if (cubecapsPluginVTable && cubecapsPluginVTable->finiDisplay)
        return cubecapsPluginVTable->finiDisplay (p, d);

    CUBECAPS_OPTIONS_DISPLAY (d);

    freeScreenPrivateIndex(d, od->screenPrivateIndex);

    compFiniDisplayOptions (d, od->opt, CubecapsDisplayOptionNum);

    free (od);
}

static Bool cubecapsOptionsInit (CompPlugin *p)
{
    displayPrivateIndex = allocateDisplayPrivateIndex();
    if (displayPrivateIndex < 0)
        return FALSE;

    if (!compInitPluginMetadataFromInfo (&cubecapsOptionsMetadata, "cubecaps",cubecapsOptionsDisplayOptionInfo, CubecapsDisplayOptionNum, cubecapsOptionsScreenOptionInfo, CubecapsScreenOptionNum))
        return FALSE;

    compAddMetadataFromFile (&cubecapsOptionsMetadata, "cubecaps");
    if (cubecapsPluginVTable && cubecapsPluginVTable->init)
        return cubecapsPluginVTable->init (p);
    return TRUE;
}

static void cubecapsOptionsFini (CompPlugin *p)
{
    if (cubecapsPluginVTable && cubecapsPluginVTable->fini)
        return cubecapsPluginVTable->fini (p);

    if (displayPrivateIndex >= 0)
        freeDisplayPrivateIndex(displayPrivateIndex);

    compFiniMetadata (&cubecapsOptionsMetadata);
}

static CompMetadata *
cubecapsOptionsGetMetadata (CompPlugin *plugin)
{
    return &cubecapsOptionsMetadata;
}

CompPluginVTable *getCompPluginInfo (void)
{
    if (!cubecapsPluginVTable)
    {
        cubecapsPluginVTable = cubecapsOptionsGetCompPluginInfo ();
        memcpy(&cubecapsOptionsVTable, cubecapsPluginVTable, sizeof(CompPluginVTable));
        cubecapsOptionsVTable.getMetadata = cubecapsOptionsGetMetadata;
        cubecapsOptionsVTable.init = cubecapsOptionsInit;
        cubecapsOptionsVTable.fini = cubecapsOptionsFini;
        cubecapsOptionsVTable.initDisplay = cubecapsOptionsInitDisplay;
        cubecapsOptionsVTable.finiDisplay = cubecapsOptionsFiniDisplay;
        cubecapsOptionsVTable.initScreen = cubecapsOptionsInitScreen;
        cubecapsOptionsVTable.finiScreen = cubecapsOptionsFiniScreen;
        cubecapsOptionsVTable.getDisplayOptions = cubecapsOptionsGetDisplayOptions;
	cubecapsOptionsVTable.setDisplayOption = cubecapsOptionsSetDisplayOption;
	cubecapsOptionsVTable.getScreenOptions = cubecapsOptionsGetScreenOptions;
	cubecapsOptionsVTable.setScreenOption = cubecapsOptionsSetScreenOption;
	
    }
    return &cubecapsOptionsVTable;
}

