/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <compiz.h>

#define _SHOWDESKTOP_OPTIONS_INTERNAL
#include "showdesktop_options.h"

static int displayPrivateIndex;

static CompMetadata showdesktopOptionsMetadata;

static CompPluginVTable *showdesktopPluginVTable = NULL;
CompPluginVTable showdesktopOptionsVTable;

#define GET_SHOWDESKTOP_OPTIONS_DISPLAY(d) \
        ((ShowdesktopOptionsDisplay *) (d)->privates[displayPrivateIndex].ptr)

#define SHOWDESKTOP_OPTIONS_DISPLAY(d) \
        ShowdesktopOptionsDisplay *od = GET_SHOWDESKTOP_OPTIONS_DISPLAY (d)

#define GET_SHOWDESKTOP_OPTIONS_SCREEN(s, od) \
        ((ShowdesktopOptionsScreen *) (s)->privates[(od)->screenPrivateIndex].ptr)

#define SHOWDESKTOP_OPTIONS_SCREEN(s) \
        ShowdesktopOptionsScreen *os = GET_SHOWDESKTOP_OPTIONS_SCREEN (s, GET_SHOWDESKTOP_OPTIONS_DISPLAY (s->display))

typedef struct _ShowdesktopOptionsDisplay
{
    int screenPrivateIndex;

} ShowdesktopOptionsDisplay;

typedef struct _ShowdesktopOptionsScreen
{
    CompOption opt[ShowdesktopScreenOptionNum];
    showdesktopScreenOptionChangeNotifyProc notify[ShowdesktopScreenOptionNum];
} ShowdesktopOptionsScreen;

float showdesktopGetSpeed (CompScreen *s)
{
    SHOWDESKTOP_OPTIONS_SCREEN(s);
    return os->opt[ShowdesktopScreenOptionSpeed].value.f;
}

CompOption * showdesktopGetSpeedOption (CompScreen *s)
{
    SHOWDESKTOP_OPTIONS_SCREEN(s);
    return &os->opt[ShowdesktopScreenOptionSpeed];
}

void showdesktopSetSpeedNotify (CompScreen *s, showdesktopScreenOptionChangeNotifyProc notify)
{
    SHOWDESKTOP_OPTIONS_SCREEN(s);
    os->notify[ShowdesktopScreenOptionSpeed] = notify;
}

float showdesktopGetTimestep (CompScreen *s)
{
    SHOWDESKTOP_OPTIONS_SCREEN(s);
    return os->opt[ShowdesktopScreenOptionTimestep].value.f;
}

CompOption * showdesktopGetTimestepOption (CompScreen *s)
{
    SHOWDESKTOP_OPTIONS_SCREEN(s);
    return &os->opt[ShowdesktopScreenOptionTimestep];
}

void showdesktopSetTimestepNotify (CompScreen *s, showdesktopScreenOptionChangeNotifyProc notify)
{
    SHOWDESKTOP_OPTIONS_SCREEN(s);
    os->notify[ShowdesktopScreenOptionTimestep] = notify;
}

int showdesktopGetDirection (CompScreen *s)
{
    SHOWDESKTOP_OPTIONS_SCREEN(s);
    return os->opt[ShowdesktopScreenOptionDirection].value.i;
}

CompOption * showdesktopGetDirectionOption (CompScreen *s)
{
    SHOWDESKTOP_OPTIONS_SCREEN(s);
    return &os->opt[ShowdesktopScreenOptionDirection];
}

void showdesktopSetDirectionNotify (CompScreen *s, showdesktopScreenOptionChangeNotifyProc notify)
{
    SHOWDESKTOP_OPTIONS_SCREEN(s);
    os->notify[ShowdesktopScreenOptionDirection] = notify;
}

CompMatch * showdesktopGetWindowMatch (CompScreen *s)
{
    SHOWDESKTOP_OPTIONS_SCREEN(s);
    return &os->opt[ShowdesktopScreenOptionWindowMatch].value.match;
}

CompOption * showdesktopGetWindowMatchOption (CompScreen *s)
{
    SHOWDESKTOP_OPTIONS_SCREEN(s);
    return &os->opt[ShowdesktopScreenOptionWindowMatch];
}

void showdesktopSetWindowMatchNotify (CompScreen *s, showdesktopScreenOptionChangeNotifyProc notify)
{
    SHOWDESKTOP_OPTIONS_SCREEN(s);
    os->notify[ShowdesktopScreenOptionWindowMatch] = notify;
}

float showdesktopGetWindowOpacity (CompScreen *s)
{
    SHOWDESKTOP_OPTIONS_SCREEN(s);
    return os->opt[ShowdesktopScreenOptionWindowOpacity].value.f;
}

CompOption * showdesktopGetWindowOpacityOption (CompScreen *s)
{
    SHOWDESKTOP_OPTIONS_SCREEN(s);
    return &os->opt[ShowdesktopScreenOptionWindowOpacity];
}

void showdesktopSetWindowOpacityNotify (CompScreen *s, showdesktopScreenOptionChangeNotifyProc notify)
{
    SHOWDESKTOP_OPTIONS_SCREEN(s);
    os->notify[ShowdesktopScreenOptionWindowOpacity] = notify;
}

int showdesktopGetWindowPartSize (CompScreen *s)
{
    SHOWDESKTOP_OPTIONS_SCREEN(s);
    return os->opt[ShowdesktopScreenOptionWindowPartSize].value.i;
}

CompOption * showdesktopGetWindowPartSizeOption (CompScreen *s)
{
    SHOWDESKTOP_OPTIONS_SCREEN(s);
    return &os->opt[ShowdesktopScreenOptionWindowPartSize];
}

void showdesktopSetWindowPartSizeNotify (CompScreen *s, showdesktopScreenOptionChangeNotifyProc notify)
{
    SHOWDESKTOP_OPTIONS_SCREEN(s);
    os->notify[ShowdesktopScreenOptionWindowPartSize] = notify;
}

CompOption * showdesktopGetScreenOption (CompScreen *s, ShowdesktopScreenOptions num)
{
    SHOWDESKTOP_OPTIONS_SCREEN(s);
    return &os->opt[num];
}

static const CompMetadataOptionInfo showdesktopOptionsScreenOptionInfo[] = {
    { "speed", "float", "<min>0.1</min><max>50.0</max>", 0, 0 },
    { "timestep", "float", "<min>0.1</min><max>50.0</max>", 0, 0 },
    { "direction", "int", "<min>0</min><max>6</max>", 0, 0 },
    { "window_match", "match", 0, 0, 0 },
    { "window_opacity", "float", "<min>0.1</min><max>1.0</max>", 0, 0 },
    { "window_part_size", "int", "<min>0</min><max>300</max>", 0, 0 },
};

static Bool showdesktopOptionsSetScreenOption (CompPlugin *plugin, CompScreen *s, char *name, CompOptionValue *value)
{
    SHOWDESKTOP_OPTIONS_SCREEN(s);
    CompOption *o;
    int        index;

    o = compFindOption (os->opt, ShowdesktopScreenOptionNum, name, &index);

    if (!o)
        return FALSE;

    switch (index)
    {
     case ShowdesktopScreenOptionSpeed:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[ShowdesktopScreenOptionSpeed])
                (*os->notify[ShowdesktopScreenOptionSpeed]) (s, o, ShowdesktopScreenOptionSpeed);
            return TRUE;
        }
        break;
     case ShowdesktopScreenOptionTimestep:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[ShowdesktopScreenOptionTimestep])
                (*os->notify[ShowdesktopScreenOptionTimestep]) (s, o, ShowdesktopScreenOptionTimestep);
            return TRUE;
        }
        break;
     case ShowdesktopScreenOptionDirection:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[ShowdesktopScreenOptionDirection])
                (*os->notify[ShowdesktopScreenOptionDirection]) (s, o, ShowdesktopScreenOptionDirection);
            return TRUE;
        }
        break;
     case ShowdesktopScreenOptionWindowMatch:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[ShowdesktopScreenOptionWindowMatch])
                (*os->notify[ShowdesktopScreenOptionWindowMatch]) (s, o, ShowdesktopScreenOptionWindowMatch);
            return TRUE;
        }
        break;
     case ShowdesktopScreenOptionWindowOpacity:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[ShowdesktopScreenOptionWindowOpacity])
                (*os->notify[ShowdesktopScreenOptionWindowOpacity]) (s, o, ShowdesktopScreenOptionWindowOpacity);
            return TRUE;
        }
        break;
     case ShowdesktopScreenOptionWindowPartSize:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[ShowdesktopScreenOptionWindowPartSize])
                (*os->notify[ShowdesktopScreenOptionWindowPartSize]) (s, o, ShowdesktopScreenOptionWindowPartSize);
            return TRUE;
        }
        break;
    default:
        break;
    }
    return FALSE;
}

static CompOption * showdesktopOptionsGetScreenOptions (CompPlugin *plugin, CompScreen *s, int *count)
{
    SHOWDESKTOP_OPTIONS_SCREEN(s);
    *count = ShowdesktopScreenOptionNum;
    return os->opt;
}

static Bool showdesktopOptionsInitScreen (CompPlugin *p, CompScreen *s)
{
    ShowdesktopOptionsScreen *os;
    
    SHOWDESKTOP_OPTIONS_DISPLAY (s->display);

    os = calloc (1, sizeof(ShowdesktopOptionsScreen));
    if (!os)
        return FALSE;

    s->privates[od->screenPrivateIndex].ptr = os;

    if (!compInitScreenOptionsFromMetadata (s, &showdesktopOptionsMetadata, showdesktopOptionsScreenOptionInfo, os->opt, ShowdesktopScreenOptionNum))
    {
        free (os);
        return FALSE;
    }
    if (showdesktopPluginVTable && showdesktopPluginVTable->initScreen)
        return showdesktopPluginVTable->initScreen (p, s);
    return TRUE;
}

static void showdesktopOptionsFiniScreen (CompPlugin *p, CompScreen *s)
{
    if (showdesktopPluginVTable && showdesktopPluginVTable->finiScreen)
        return showdesktopPluginVTable->finiScreen (p, s);

    SHOWDESKTOP_OPTIONS_SCREEN (s);


    compFiniScreenOptions (s, os->opt, ShowdesktopScreenOptionNum);

    free (os);
}

static Bool showdesktopOptionsInitDisplay (CompPlugin *p, CompDisplay *d)
{
    ShowdesktopOptionsDisplay *od;
   
    
    od = calloc (1, sizeof(ShowdesktopOptionsDisplay));
    if (!od)
        return FALSE;

    od->screenPrivateIndex = allocateScreenPrivateIndex(d);
    if (od->screenPrivateIndex < 0)
    {
        free(od);
        return FALSE;
    }

    d->privates[displayPrivateIndex].ptr = od;

        if (showdesktopPluginVTable && showdesktopPluginVTable->initDisplay)
        return showdesktopPluginVTable->initDisplay (p, d);
    return TRUE;
}

static void showdesktopOptionsFiniDisplay (CompPlugin *p, CompDisplay *d)
{
    if (showdesktopPluginVTable && showdesktopPluginVTable->finiDisplay)
        return showdesktopPluginVTable->finiDisplay (p, d);

    SHOWDESKTOP_OPTIONS_DISPLAY (d);

    freeScreenPrivateIndex(d, od->screenPrivateIndex);
    free (od);
}

static Bool showdesktopOptionsInit (CompPlugin *p)
{
    displayPrivateIndex = allocateDisplayPrivateIndex();
    if (displayPrivateIndex < 0)
        return FALSE;

    if (!compInitPluginMetadataFromInfo (&showdesktopOptionsMetadata, "showdesktop",0, 0, showdesktopOptionsScreenOptionInfo, ShowdesktopScreenOptionNum))
        return FALSE;

    compAddMetadataFromFile (&showdesktopOptionsMetadata, "showdesktop");
    if (showdesktopPluginVTable && showdesktopPluginVTable->init)
        return showdesktopPluginVTable->init (p);
    return TRUE;
}

static void showdesktopOptionsFini (CompPlugin *p)
{
    if (showdesktopPluginVTable && showdesktopPluginVTable->fini)
        return showdesktopPluginVTable->fini (p);

    if (displayPrivateIndex >= 0)
        freeDisplayPrivateIndex(displayPrivateIndex);

    compFiniMetadata (&showdesktopOptionsMetadata);
}

static CompMetadata *
showdesktopOptionsGetMetadata (CompPlugin *plugin)
{
    return &showdesktopOptionsMetadata;
}

CompPluginVTable *getCompPluginInfo (void)
{
    if (!showdesktopPluginVTable)
    {
        showdesktopPluginVTable = showdesktopOptionsGetCompPluginInfo ();
        memcpy(&showdesktopOptionsVTable, showdesktopPluginVTable, sizeof(CompPluginVTable));
        showdesktopOptionsVTable.getMetadata = showdesktopOptionsGetMetadata;
        showdesktopOptionsVTable.init = showdesktopOptionsInit;
        showdesktopOptionsVTable.fini = showdesktopOptionsFini;
        showdesktopOptionsVTable.initDisplay = showdesktopOptionsInitDisplay;
        showdesktopOptionsVTable.finiDisplay = showdesktopOptionsFiniDisplay;
        showdesktopOptionsVTable.initScreen = showdesktopOptionsInitScreen;
        showdesktopOptionsVTable.finiScreen = showdesktopOptionsFiniScreen;
        showdesktopOptionsVTable.getScreenOptions = showdesktopOptionsGetScreenOptions;
	showdesktopOptionsVTable.setScreenOption = showdesktopOptionsSetScreenOption;
	
    }
    return &showdesktopOptionsVTable;
}

