/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <compiz.h>

#define _WIDGET_OPTIONS_INTERNAL
#include "widget_options.h"

static int displayPrivateIndex;

static CompMetadata widgetOptionsMetadata;

static CompPluginVTable *widgetPluginVTable = NULL;
CompPluginVTable widgetOptionsVTable;

#define GET_WIDGET_OPTIONS_DISPLAY(d) \
        ((WidgetOptionsDisplay *) (d)->privates[displayPrivateIndex].ptr)

#define WIDGET_OPTIONS_DISPLAY(d) \
        WidgetOptionsDisplay *od = GET_WIDGET_OPTIONS_DISPLAY (d)

#define GET_WIDGET_OPTIONS_SCREEN(s, od) \
        ((WidgetOptionsScreen *) (s)->privates[(od)->screenPrivateIndex].ptr)

#define WIDGET_OPTIONS_SCREEN(s) \
        WidgetOptionsScreen *os = GET_WIDGET_OPTIONS_SCREEN (s, GET_WIDGET_OPTIONS_DISPLAY (s->display))

typedef struct _WidgetOptionsDisplay
{
    int screenPrivateIndex;

    CompOption opt[WidgetDisplayOptionNum];
    widgetDisplayOptionChangeNotifyProc notify[WidgetDisplayOptionNum];
} WidgetOptionsDisplay;

typedef struct _WidgetOptionsScreen
{
    CompOption opt[WidgetScreenOptionNum];
    widgetScreenOptionChangeNotifyProc notify[WidgetScreenOptionNum];
} WidgetOptionsScreen;

CompAction * widgetGetToggle (CompDisplay *d)
{
    WIDGET_OPTIONS_DISPLAY(d);
    return &od->opt[WidgetDisplayOptionToggle].value.action;
}

void widgetSetToggleInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    WIDGET_OPTIONS_DISPLAY(d);
    od->opt[WidgetDisplayOptionToggle].value.action.initiate = init;
}

void widgetSetToggleTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    WIDGET_OPTIONS_DISPLAY(d);
    od->opt[WidgetDisplayOptionToggle].value.action.terminate = term;
}

CompOption * widgetGetToggleOption (CompDisplay *d)
{
    WIDGET_OPTIONS_DISPLAY(d);
    return &od->opt[WidgetDisplayOptionToggle];
}

void widgetSetToggleNotify (CompDisplay *d, widgetDisplayOptionChangeNotifyProc notify)
{
    WIDGET_OPTIONS_DISPLAY(d);
    od->notify[WidgetDisplayOptionToggle] = notify;
}

CompMatch * widgetGetMatch (CompScreen *s)
{
    WIDGET_OPTIONS_SCREEN(s);
    return &os->opt[WidgetScreenOptionMatch].value.match;
}

CompOption * widgetGetMatchOption (CompScreen *s)
{
    WIDGET_OPTIONS_SCREEN(s);
    return &os->opt[WidgetScreenOptionMatch];
}

void widgetSetMatchNotify (CompScreen *s, widgetScreenOptionChangeNotifyProc notify)
{
    WIDGET_OPTIONS_SCREEN(s);
    os->notify[WidgetScreenOptionMatch] = notify;
}

Bool widgetGetEndOnClick (CompScreen *s)
{
    WIDGET_OPTIONS_SCREEN(s);
    return os->opt[WidgetScreenOptionEndOnClick].value.b;
}

CompOption * widgetGetEndOnClickOption (CompScreen *s)
{
    WIDGET_OPTIONS_SCREEN(s);
    return &os->opt[WidgetScreenOptionEndOnClick];
}

void widgetSetEndOnClickNotify (CompScreen *s, widgetScreenOptionChangeNotifyProc notify)
{
    WIDGET_OPTIONS_SCREEN(s);
    os->notify[WidgetScreenOptionEndOnClick] = notify;
}

float widgetGetFadeTime (CompScreen *s)
{
    WIDGET_OPTIONS_SCREEN(s);
    return os->opt[WidgetScreenOptionFadeTime].value.f;
}

CompOption * widgetGetFadeTimeOption (CompScreen *s)
{
    WIDGET_OPTIONS_SCREEN(s);
    return &os->opt[WidgetScreenOptionFadeTime];
}

void widgetSetFadeTimeNotify (CompScreen *s, widgetScreenOptionChangeNotifyProc notify)
{
    WIDGET_OPTIONS_SCREEN(s);
    os->notify[WidgetScreenOptionFadeTime] = notify;
}

int widgetGetBgBrightness (CompScreen *s)
{
    WIDGET_OPTIONS_SCREEN(s);
    return os->opt[WidgetScreenOptionBgBrightness].value.i;
}

CompOption * widgetGetBgBrightnessOption (CompScreen *s)
{
    WIDGET_OPTIONS_SCREEN(s);
    return &os->opt[WidgetScreenOptionBgBrightness];
}

void widgetSetBgBrightnessNotify (CompScreen *s, widgetScreenOptionChangeNotifyProc notify)
{
    WIDGET_OPTIONS_SCREEN(s);
    os->notify[WidgetScreenOptionBgBrightness] = notify;
}

int widgetGetBgSaturation (CompScreen *s)
{
    WIDGET_OPTIONS_SCREEN(s);
    return os->opt[WidgetScreenOptionBgSaturation].value.i;
}

CompOption * widgetGetBgSaturationOption (CompScreen *s)
{
    WIDGET_OPTIONS_SCREEN(s);
    return &os->opt[WidgetScreenOptionBgSaturation];
}

void widgetSetBgSaturationNotify (CompScreen *s, widgetScreenOptionChangeNotifyProc notify)
{
    WIDGET_OPTIONS_SCREEN(s);
    os->notify[WidgetScreenOptionBgSaturation] = notify;
}

CompOption * widgetGetDisplayOption (CompDisplay *d, WidgetDisplayOptions num)
{
    WIDGET_OPTIONS_DISPLAY(d);
    return &od->opt[num];
}

CompOption * widgetGetScreenOption (CompScreen *s, WidgetScreenOptions num)
{
    WIDGET_OPTIONS_SCREEN(s);
    return &os->opt[num];
}

static const CompMetadataOptionInfo widgetOptionsDisplayOptionInfo[] = {
    { "toggle", "action", 0, 0, 0 },
};

static Bool widgetOptionsSetDisplayOption (CompPlugin *plugin, CompDisplay *d, char *name, CompOptionValue *value)
{
    WIDGET_OPTIONS_DISPLAY(d);
    CompOption *o;
    int        index;

    o = compFindOption (od->opt, WidgetDisplayOptionNum, name, &index);

    if (!o)
        return FALSE;

    switch (index)
    {
     case WidgetDisplayOptionToggle:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[WidgetDisplayOptionToggle])
                (*od->notify[WidgetDisplayOptionToggle]) (d, o, WidgetDisplayOptionToggle);
            return TRUE;
        }
        break;
    default:
        break;
    }
    return FALSE;
}

static CompOption * widgetOptionsGetDisplayOptions (CompPlugin *plugin, CompDisplay *d, int *count)
{
    WIDGET_OPTIONS_DISPLAY(d);
    *count = WidgetDisplayOptionNum;
    return od->opt;
}

static const CompMetadataOptionInfo widgetOptionsScreenOptionInfo[] = {
    { "match", "match", 0, 0, 0 },
    { "end_on_click", "bool", 0, 0, 0 },
    { "fade_time", "float", "<min>0</min><max>10</max>", 0, 0 },
    { "bg_brightness", "int", "<min>0</min><max>100</max>", 0, 0 },
    { "bg_saturation", "int", "<min>0</min><max>100</max>", 0, 0 },
};

static Bool widgetOptionsSetScreenOption (CompPlugin *plugin, CompScreen *s, char *name, CompOptionValue *value)
{
    WIDGET_OPTIONS_SCREEN(s);
    CompOption *o;
    int        index;

    o = compFindOption (os->opt, WidgetScreenOptionNum, name, &index);

    if (!o)
        return FALSE;

    switch (index)
    {
     case WidgetScreenOptionMatch:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[WidgetScreenOptionMatch])
                (*os->notify[WidgetScreenOptionMatch]) (s, o, WidgetScreenOptionMatch);
            return TRUE;
        }
        break;
     case WidgetScreenOptionEndOnClick:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[WidgetScreenOptionEndOnClick])
                (*os->notify[WidgetScreenOptionEndOnClick]) (s, o, WidgetScreenOptionEndOnClick);
            return TRUE;
        }
        break;
     case WidgetScreenOptionFadeTime:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[WidgetScreenOptionFadeTime])
                (*os->notify[WidgetScreenOptionFadeTime]) (s, o, WidgetScreenOptionFadeTime);
            return TRUE;
        }
        break;
     case WidgetScreenOptionBgBrightness:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[WidgetScreenOptionBgBrightness])
                (*os->notify[WidgetScreenOptionBgBrightness]) (s, o, WidgetScreenOptionBgBrightness);
            return TRUE;
        }
        break;
     case WidgetScreenOptionBgSaturation:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[WidgetScreenOptionBgSaturation])
                (*os->notify[WidgetScreenOptionBgSaturation]) (s, o, WidgetScreenOptionBgSaturation);
            return TRUE;
        }
        break;
    default:
        break;
    }
    return FALSE;
}

static CompOption * widgetOptionsGetScreenOptions (CompPlugin *plugin, CompScreen *s, int *count)
{
    WIDGET_OPTIONS_SCREEN(s);
    *count = WidgetScreenOptionNum;
    return os->opt;
}

static Bool widgetOptionsInitScreen (CompPlugin *p, CompScreen *s)
{
    WidgetOptionsScreen *os;
    
    WIDGET_OPTIONS_DISPLAY (s->display);

    os = calloc (1, sizeof(WidgetOptionsScreen));
    if (!os)
        return FALSE;

    s->privates[od->screenPrivateIndex].ptr = os;

    if (!compInitScreenOptionsFromMetadata (s, &widgetOptionsMetadata, widgetOptionsScreenOptionInfo, os->opt, WidgetScreenOptionNum))
    {
        free (os);
        return FALSE;
    }
    if (widgetPluginVTable && widgetPluginVTable->initScreen)
        return widgetPluginVTable->initScreen (p, s);
    return TRUE;
}

static void widgetOptionsFiniScreen (CompPlugin *p, CompScreen *s)
{
    if (widgetPluginVTable && widgetPluginVTable->finiScreen)
        return widgetPluginVTable->finiScreen (p, s);

    WIDGET_OPTIONS_SCREEN (s);


    compFiniScreenOptions (s, os->opt, WidgetScreenOptionNum);

    free (os);
}

static Bool widgetOptionsInitDisplay (CompPlugin *p, CompDisplay *d)
{
    WidgetOptionsDisplay *od;
   
    
    od = calloc (1, sizeof(WidgetOptionsDisplay));
    if (!od)
        return FALSE;

    od->screenPrivateIndex = allocateScreenPrivateIndex(d);
    if (od->screenPrivateIndex < 0)
    {
        free(od);
        return FALSE;
    }

    d->privates[displayPrivateIndex].ptr = od;

    if (!compInitDisplayOptionsFromMetadata (d, &widgetOptionsMetadata, widgetOptionsDisplayOptionInfo, od->opt, WidgetDisplayOptionNum))
    {
        free (od);
        return FALSE;
    }
    if (widgetPluginVTable && widgetPluginVTable->initDisplay)
        return widgetPluginVTable->initDisplay (p, d);
    return TRUE;
}

static void widgetOptionsFiniDisplay (CompPlugin *p, CompDisplay *d)
{
    if (widgetPluginVTable && widgetPluginVTable->finiDisplay)
        return widgetPluginVTable->finiDisplay (p, d);

    WIDGET_OPTIONS_DISPLAY (d);

    freeScreenPrivateIndex(d, od->screenPrivateIndex);

    compFiniDisplayOptions (d, od->opt, WidgetDisplayOptionNum);

    free (od);
}

static Bool widgetOptionsInit (CompPlugin *p)
{
    displayPrivateIndex = allocateDisplayPrivateIndex();
    if (displayPrivateIndex < 0)
        return FALSE;

    if (!compInitPluginMetadataFromInfo (&widgetOptionsMetadata, "widget",widgetOptionsDisplayOptionInfo, WidgetDisplayOptionNum, widgetOptionsScreenOptionInfo, WidgetScreenOptionNum))
        return FALSE;

    compAddMetadataFromFile (&widgetOptionsMetadata, "widget");
    if (widgetPluginVTable && widgetPluginVTable->init)
        return widgetPluginVTable->init (p);
    return TRUE;
}

static void widgetOptionsFini (CompPlugin *p)
{
    if (widgetPluginVTable && widgetPluginVTable->fini)
        return widgetPluginVTable->fini (p);

    if (displayPrivateIndex >= 0)
        freeDisplayPrivateIndex(displayPrivateIndex);

    compFiniMetadata (&widgetOptionsMetadata);
}

static CompMetadata *
widgetOptionsGetMetadata (CompPlugin *plugin)
{
    return &widgetOptionsMetadata;
}

CompPluginVTable *getCompPluginInfo (void)
{
    if (!widgetPluginVTable)
    {
        widgetPluginVTable = widgetOptionsGetCompPluginInfo ();
        memcpy(&widgetOptionsVTable, widgetPluginVTable, sizeof(CompPluginVTable));
        widgetOptionsVTable.getMetadata = widgetOptionsGetMetadata;
        widgetOptionsVTable.init = widgetOptionsInit;
        widgetOptionsVTable.fini = widgetOptionsFini;
        widgetOptionsVTable.initDisplay = widgetOptionsInitDisplay;
        widgetOptionsVTable.finiDisplay = widgetOptionsFiniDisplay;
        widgetOptionsVTable.initScreen = widgetOptionsInitScreen;
        widgetOptionsVTable.finiScreen = widgetOptionsFiniScreen;
        widgetOptionsVTable.getDisplayOptions = widgetOptionsGetDisplayOptions;
	widgetOptionsVTable.setDisplayOption = widgetOptionsSetDisplayOption;
	widgetOptionsVTable.getScreenOptions = widgetOptionsGetScreenOptions;
	widgetOptionsVTable.setScreenOption = widgetOptionsSetScreenOption;
	
    }
    return &widgetOptionsVTable;
}

