/***************************************************************************
 $RCSfile$
                             -------------------
    cvs         : $Id: gwenhywfarapi.h 1048 2006-05-17 17:15:35Z martin $
    begin       : Mon Aug 14 2006
    copyright   : (C) 2006 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CYBERJACKAPI_H
#define CYBERJACKAPI_H

#include <ctapi.h>


#define CYBERJACK_SYS_IS_WINDOWS  0

#ifdef BUILDING_CYBERJACK
  /* building Cyberjack */
# if CYBERJACK_SYS_IS_WINDOWS
    /* for windows */
#   ifdef __declspec
#     define CYBERJACK_API __declspec (dllexport)
#   else /* if __declspec */
#     define CYBERJACK_API
#   endif /* if NOT __declspec */
# else
    /* for non-win32 */
#   ifdef GCC_WITH_VISIBILITY_ATTRIBUTE
#     define CYBERJACK_API __attribute__((visibility("default")))
#   else
#     define CYBERJACK_API
#   endif
# endif
#else
  /* not building Cyberjack */
# if CYBERJACK_SYS_IS_WINDOWS
    /* for windows */
#   ifdef __declspec
#     define CYBERJACK_API __declspec (dllimport)
#   else /* if __declspec */
#     define CYBERJACK_API
#   endif /* if NOT __declspec */
# else
    /* for non-win32 */
#   define CYBERJACK_API
# endif
#endif


#ifdef GCC_WITH_VISIBILITY_ATTRIBUTE
# define CYBERJACK_EXPORT __attribute__((visibility("default")))
# define CYBERJACK_NOEXPORT __attribute__((visibility("hidden")))
#else
# define CYBERJACK_EXPORT
# define CYBERJACK_NOEXPORT
#endif



/* Convenience macros to test the versions of glibc and gcc. Taken
   from <features.h> which does not contain this on MinGW systems.  */
#ifndef __GNUC_PREREQ
# if defined __GNUC__ && defined __GNUC_MINOR__
#  define __GNUC_PREREQ(maj, min) \
        ((__GNUC__ << 16) + __GNUC_MINOR__ >= ((maj) << 16) + (min))
# else
#  define __GNUC_PREREQ(maj, min) 0
# endif
#endif /* __GNUC_PREREQ */


/* Taken from <sys/cdefs.h> which does not contain this on MinGW
   systems.  */
#ifndef __STRING
# define __STRING(x)     #x
#endif /* __STRING */


#define CT_MAX_DEVICES 256

/**
 * @return <0 on error, 0 if reader should beep, 1 if this has been handled
 * by the callback function
 */
typedef int (*CT_KEY_CB)(IU16 ctn, void *user_data);

IS8 CT_init(IU16 ctn, IU16 pn);
IS8 CT_data(IU16 ctn, IU8 *dad, IU8 *sad,
            IU16 lenc, IU8 *command,
            IU16 *lenr, IU8 *response);
IS8 CT_close(IU16 ctn);

IS8 CT_setkeycb(IU16 ctn, CT_KEY_CB cb, void *user_data);

IS8 rsct_setkeycb(IU16 ctn, CT_KEY_CB cb, void *user_data);
IS8 rsct_init_name(IU16 ctn, const char *devName);
void rsct_version(IU8 *vmajor,
		  IU8 *vminor,
		  IU8 *vpatchlevel,
		  IU16 *vbuild);

unsigned int config_get_flags();
const char *config_get_debug_filename();


#define cjctapi_log(format, args...) \
  rsct_log(CT_FLAGS_DEBUG_CTAPI, __FILE__, __LINE__, __FUNCTION__, format, ## args)


void rsct_log(unsigned int what, char *file, int line, const char *function,
	      const char *format, ...);

void rsct_log_bytes(unsigned int what, char *file, int line,
		    const char *function,
		    const char *hdr,
		    int datalen, const unsigned char *data);


#endif


