#!/bin/bash

BINDIR=/usr/local/bin
CONFDIR=~/.dvdwizard
SCRIPTS="chaptercheck dvdcpics dvdtguess dvdwizard dvdwizardrc mk_vmgm mk_vtsm mk_vtsm_info mk_vtsm_lang mpgprobe txt2png"

echo "Installing dvdwizard"

if [ ! -e $BINDIR ]; then
	echo "Target directory $BINDIR does not exist. Please create it manually"
	exit 1
fi

if  [ ! -w $BINDIR ]; then
	echo "Target directory $BINDIR is not writable. Please make sure you have sufficient access rights"
	exit 1
fi

echo -n "Copying dvdwizard scripts to $BINDIR"

for SCRIPT in $SCRIPTS; do
	[ "$SCRIPT" != dvdwizardrc ] && chmod a+x $SCRIPT
	cp $SCRIPT $BINDIR
	echo -n '.'
done

echo "done"
echo "Make sure, $BINDIR is inside your PATH"
echo "Installing config file to $CONFDIR..."

if  test -f $CONFDIR/dvdwizard.conf
then
	echo "You already have a $CONFDIR/dvdwizard.conf!!"
	echo "do you want to overwrite it?(y/n)"

	read user_reply

	if [ "$user_reply" = "y" ]
	then
		cp $CONFDIR/dvdwizard.conf $CONFDIR/dvdwizard.conf.save
		echo "Saved existing config to $CONFDIR/dvdwizard.conf.save"
		cp dvdwizard.conf.sample $CONFDIR/dvdwizard.conf	
		echo "Installed new config as $CONFDIR/dvdwizard.conf"
 		echo "Please edit the new config to your preferences"	
	else
		echo "Ok, keeping old config"
		echo "Refer to dvdwizard.conf.sample for new/changed options"
	fi
else
	[ ! -e $CONFDIR ] && mkdir -p $CONFDIR
	cp dvdwizard.conf.sample $CONFDIR/dvdwizard.conf	
	echo "Installed new config as $CONFDIR/dvdwizard.conf"
	echo "Please edit the new config to your preferences"	
fi  

echo "dvdwizard install ready"

exit