// -*- C++ -*-
/*
#
# This Program is part of Dictionary Reader
# Copyright (C) 1999 Takashi Nemoto
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details. 
#
#    Send bugs and comments to tnemoto@mvi.biglobe.ne.jp
#
*/

#include "gui.h"

GtkWidget* openButton;
GtkWidget* enterButton;
GtkWidget* upButton;
GtkWidget* downButton;
GtkWidget* pageUpButton;
GtkWidget* pageDownButton;

extern int scroll_callback(GtkWidget* w,gpointer x);


void CreateInvisibleButtons(void) {
  // ******** Create Short Cut Buttons (INVISIBLE) ********

  // *** Open Config ***
  openButton = gtk_button_new_with_label (_("Open Config"));
  gtk_signal_connect (GTK_OBJECT (openButton), "clicked",
		      GTK_SIGNAL_FUNC (FileSelect), NULL);
  gtk_widget_add_accelerator(openButton,"clicked",accelGroup,GDK_o,
			     GDK_CONTROL_MASK,GTK_ACCEL_VISIBLE);

  // *** Enter Word ***
  /*
  enterButton = gtk_button_new_with_label (_("Enter Word"));
  gtk_signal_connect (GTK_OBJECT (enterButton), "clicked",
		      GTK_SIGNAL_FUNC (enter_callback), NULL);
  gtk_widget_add_accelerator(enterButton,"clicked",accelGroup,GDK_m,
			     GDK_CONTROL_MASK,GTK_ACCEL_VISIBLE);
  gtk_widget_add_accelerator(enterButton,"clicked",accelGroup,GDK_Return,
			     GDK_CONTROL_MASK,GTK_ACCEL_VISIBLE);
  */
  // *** Upper Word ***
  upButton = gtk_button_new_with_label (_("Upper Word"));
  gtk_signal_connect (GTK_OBJECT (upButton), "clicked",
		      GTK_SIGNAL_FUNC (up_callback), NULL);
  gtk_widget_add_accelerator(upButton,"clicked",accelGroup,GDK_p,
			     GDK_CONTROL_MASK,GTK_ACCEL_VISIBLE);
  // *** Lower Word ***
  downButton = gtk_button_new_with_label (_("Lower Word"));
  gtk_signal_connect (GTK_OBJECT (downButton), "clicked",
		      GTK_SIGNAL_FUNC (down_callback), NULL);
  gtk_widget_add_accelerator(downButton,"clicked",accelGroup,GDK_n,
			     GDK_CONTROL_MASK,GTK_ACCEL_VISIBLE);
  // *** Page Up ***
  pageUpButton = gtk_button_new_with_label (_("Page Up"));
  gtk_signal_connect (GTK_OBJECT (pageUpButton), "clicked",
		      GTK_SIGNAL_FUNC (scroll_callback), (gpointer)-1);
  gtk_widget_add_accelerator(downButton,"clicked",accelGroup,GDK_Page_Up,
			     GDK_CONTROL_MASK,GTK_ACCEL_VISIBLE);
  // *** Page Down ***
  pageDownButton = gtk_button_new_with_label (_("Page Down"));
  gtk_signal_connect (GTK_OBJECT (pageDownButton), "clicked",
		      GTK_SIGNAL_FUNC (scroll_callback), (gpointer)1);
  gtk_widget_add_accelerator(downButton,"clicked",accelGroup,GDK_Page_Down,
			     GDK_CONTROL_MASK,GTK_ACCEL_VISIBLE);

  // *** Focus Button ***
  GtkWidget* focusButton = gtk_button_new_with_label (_("Focus Button"));
  gtk_signal_connect (GTK_OBJECT (focusButton), "clicked",
		      GTK_SIGNAL_FUNC (focus_callback), NULL);
  gtk_widget_add_accelerator(focusButton,"clicked",accelGroup,GDK_r,
			     GDK_CONTROL_MASK,GTK_ACCEL_VISIBLE);

  // *** Quit Button ***
  GtkWidget* quitButton = gtk_button_new_with_label (_("Quit"));
  gtk_signal_connect (GTK_OBJECT (quitButton), "clicked",
		      GTK_SIGNAL_FUNC (winDestroy), NULL);
  gtk_widget_add_accelerator(quitButton,"clicked",accelGroup,GDK_q,
			     GDK_CONTROL_MASK,GTK_ACCEL_VISIBLE);

  // *** History Button ***
  GtkWidget* histPrevButton=gtk_button_new_with_label(_("Prev"));
  gtk_signal_connect (GTK_OBJECT(histPrevButton), "clicked",
		      GTK_SIGNAL_FUNC (hist_prev), NULL);
  gtk_widget_add_accelerator(histPrevButton,"clicked",accelGroup,GDK_u,
			     GDK_CONTROL_MASK,GTK_ACCEL_VISIBLE);

  /*
  GtkWidget* histNextButton=gtk_button_new_with_label(_("Next"));
  gtk_signal_connect (GTK_OBJECT(histNextButton), "clicked",
		      GTK_SIGNAL_FUNC (hist_next), NULL);
  gtk_toolbar_append_widget(GTK_TOOLBAR(toolbar),histNextButton,
			    _("History"),"");
  */
}
