// -*- C++ -*-
/*
#
# This Program is part of Dictionary Reader
# Copyright (C) 1999 Takashi Nemoto
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details. 
#
#    Send bugs and comments to tnemoto@mvi.biglobe.ne.jp
#
*/

#include "def.h"
#include "global.h"
#include "honmon.h"
#include "codeconv.h"
#include "gui.h"
#include "mm.h"

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

extern bool PutRDWord(dword d,FILE *fp);

extern void CreateMessageBox(GtkWidget* parent,
			     GtkWidget* child1,GtkWidget* child2);
extern void CreateModelessMessageBox(GtkWidget* parent,
				     GtkWidget* child1,GtkWidget* child2);

GdkPixmap* MakePixmapFromHonmon(const TAG& t){
  char buf[2048];
  byte* ubuf=reinterpret_cast<byte*>(buf);
  const char* gPath=catalogs.Dic(preference.currentDictNum)->GraphicsPath();
  BlockIO* npf;
  if (gPath!=NULL){
    npf=OpenDict(gPath);
    if (!npf->Initialized()) {  // honmong not exists.
      delete npf;
      return NULL;
    }
  } else {
    npf=currentDict->BlockFile();
  }
  npf->Seek(t);
  Debug::DebugOut(Debug::WARNINGS,"Bitmap At %d:%d\n",t.Block(),t.Offset());
  if (npf->Read(ubuf,4));
  GdkPixmap* pix=NULL;
  if (strncmp(buf,"data",4)==0){
    int length=npf->GetRDWord();
    char* fileName=DupToTempFile(npf,TAG(-1,-1),length);
    if (fileName!=NULL){
      pix=MakePixmapFromFile(fileName);
      unlink(fileName);
      free(fileName);
    }
  }
  if (npf!=currentDict->BlockFile()) delete npf;
  return pix;
}

/*
static void DisplayImageFile(const char* message,char* fileName){
  #ifdef USE_INTERNAL_GRAPHICS
  GdkPixmap* pix=MakePixmapFromFile(fileName);
  if (pix!=NULL){
    CreateModelessMessageBox(mainWindow,gtk_label_new(message),
			     gtk_pixmap_new(pix,NULL));
    gdk_pixmap_unref(pix);
  }
  #else
  #ifdef ALT_GRAPHICS_PROGRAM
  char buf[1024];
  sprintf(buf,"%s %s",ALT_GRAPHICS_PROGRAM,fileName);
  system(buf);
  #else
  CreateModalMessageBox(mainWindow,gtk_label_new(_("Can't display image.")),
			gtk_label_new(_("Ignored.")));
  #endif
  #endif
}
*/

static GdkPixmap* MakeBitmap44Sub(const byte* bitmap,int width,int height){
  int bwidth;
  bwidth=((width-1)>>3)+1;
  GdkPixmap* pix=gdk_pixmap_new(mainWindow->window,width,height,-1);
  char* buf=(char*)malloc(bwidth*height);
  memcpy(buf,bitmap,bwidth*height);
  GdkImage *img=
    gdk_image_new_bitmap(gtk_widget_get_visual(mainWindow),
			 (void*) buf,width,height);
  gdk_gc_set_background(gc,&mainWindow->style->white);
  gdk_gc_set_function (gc,GDK_COPY);
  gdk_draw_image(pix,gc,img,0,0,0,0,width,height);
  gdk_image_destroy(img);
  return pix;
}


bool MMColorSample(const TAG& tag) {
  char buf[32],buf2[32],buf3[256];
  byte* ubuf=reinterpret_cast<byte*>(buf);
  BlockIO *pf=currentDict->BlockFile();
  pf->Seek(TAG(tag.Block(),20));
  pf->Read(ubuf,32);
  sprintf(buf3,"%s:",_EC(_JE(JIS_STRING(buf))).c_str());
  pf->Seek(TAG(tag));
  pf->Read(ubuf,20);
  for(int i=0;i<20;i++){ 
    sprintf(buf2,"%02X ",ubuf[i]); 
    strcat(buf3,buf2);
  };
  CreateMessageBox(mainWindow,
		   gtk_label_new(_("Color Sample (Not supported yet)")),
		   gtk_label_new(buf3));
  return true;
}

static GdkPixmap* MakePixmap31(const TAG& t){
  int w,h;
  BlockIO *pf=currentDict->BlockFile();
  pf->Seek(t);
  Debug::DebugOut(Debug::MULTIMEDIA,"MakePixmap31 %d:%d\n",
		  t.Block(),t.Offset());
  int bitmaptype=pf->GetWord();
  w=pf->GetBCD(4);
  h=pf->GetBCD(4);
  do {
    while(pf->GetByte()!=0x1f);
  } while(pf->GetByte()!=0x51);
  switch(bitmaptype){
  case 0:  // B/W bitmap
    {
      TAG tag=pf->GetBCDTag();
      Debug::DebugOut(Debug::MULTIMEDIA,"Tag=%d:%d\n",
		      tag.Block(),tag.Offset());
      int len=(((w-1)>>3)+1)*h;
      byte* bitmap=new byte[len];
      pf->Seek(tag);
      pf->Read(bitmap,len);
      GdkPixmap* pix=MakeBitmap44Sub(bitmap,w,h);
      delete [] bitmap;
      return pix;
    }
  case 1:  // JPEG??
    {
      TAG tag=pf->GetBCDTag();
      int len=w*h;  // ??? may be shorter than len..
      len*=2;
      char* fname=DupToTempFile(pf,tag,len);
      if (fname!=NULL){
	GdkPixmap* pix=MakePixmapFromFile(fname);
	unlink(fname);
	free(fname);
	return pix;
      } else {
	return NULL;
      }
    }
  default:
    break;
  }
  return NULL;
}

static bool MMDisplayBitmap31(const TAG& t){
  GdkPixmap* pix=MakePixmap31(t);
  if (pix==NULL) return false;
  CreateModelessMessageBox(mainWindow,gtk_label_new(_("Bitmap 0x31")),
			   gtk_pixmap_new(pix,NULL));
  gdk_pixmap_unref(pix);
  return true;
}

bool MMPlayVoice33(const TAG& tag){  // EB-XA Sound
  char buf0[3000];
  char* tmpfile;
  BlockIO *pf=currentDict->BlockFile();
  Debug::DebugOut(Debug::MULTIMEDIA,"MM=0x33: Start = %d:%d\n",
		  tag.Block(),tag.Offset());
  pf->Seek(tag);
  pf->GetWord();  // File Type ?
  int s_min=pf->GetBCD();
  int s_sec=pf->GetBCD();
  int s_frame=pf->GetBCD();
  int s_lba=((s_min*60)+s_sec)*75+s_frame-1;
  int e_min=pf->GetBCD();
  int e_sec=pf->GetBCD();
  int e_frame=pf->GetBCD();
  int e_lba=((e_min*60)+e_sec)*75+e_frame;

  Debug::DebugOut(Debug::MULTIMEDIA,"MM=0x33: %d:%d:%d - %d:%d:%d\n",
		  s_min,s_sec,s_frame,e_min,e_sec,e_frame);

  Debug::DebugOut(Debug::MULTIMEDIA,"MM=0x33: A3 '%s'\n",
		  catalogs.Dic(preference.currentDictNum)->DicPath());
  if (strncmp(catalogs.Dic(preference.currentDictNum)->DicPath(),
	      "ndtp:",5)==0){
    CreateMessageBox(mainWindow,gtk_label_new(_("EB-XA open error.")),
		     gtk_label_new(_("Can't play audio data through ndtp")));
    return false;
  }
  const char* soundfile=catalogs.Dic(preference.currentDictNum)->SoundPath();
  if (soundfile==NULL) {
    CreateMessageBox(mainWindow,gtk_label_new(_("EB-XA open error.")),
		     gtk_label_new(_("Sound file is not defined")));
    return false;
  }
  FILE* ifp=fopen(soundfile,"r");
  Debug::DebugOut(Debug::MULTIMEDIA,"MM=0x33: A2\n");
  if (ifp==NULL) {
    CreateMessageBox(mainWindow,gtk_label_new(_("EB-XA open error.")),
		     gtk_label_new(_("File not found ?")));
    return false;
  }
  tmpfile=strdup("DCTXXXXXX");
  int tmpfd;
  if ((tmpfd=mkstemp(tmpfile))<0) {
    fclose(ifp);
    return false;
  }
  close(tmpfd);
  Debug::DebugOut(Debug::MULTIMEDIA,"MM=0x33: A1\n");



  FILE* ofp=fopen(tmpfile,"w");
  if (ofp==NULL) {
    free(tmpfile);
    fclose(ifp);
    return false;
  }
  bool feb=Ebxa2wav(ifp,ofp,s_lba,e_lba);
  fclose(ofp);
  fclose(ifp);
  if (feb){
#ifdef SOUND_PROGRAM
    sprintf(buf0,"%s %s &",SOUND_PROGRAM,tmpfile);
#else
    sprintf(buf0,"splay %s &",tmpfile);
#endif
    system(buf0);
    sleep(1);
  } else {
    CreateMessageBox(mainWindow,gtk_label_new(_("EB-XA read error.")),
     gtk_label_new(_("This program has not support direct CD access yet.")));
  }
  //  unlink(tmpfile);
  free(tmpfile);
  return feb;
}



bool MMPlayMovie39(const TAG& tag){
  char buf[25];
  byte* ubuf=reinterpret_cast<byte*>(buf);
  BlockIO *pf=currentDict->BlockFile();
  pf->Seek(tag);
  pf->Read(ubuf,24);
  ubuf[24]=0;
  NATIVE_STRING basedir=catalogs.Dic(preference.currentDictNum)->BaseDir();
  NATIVE_STRING moviefile=
    basedir+"/movie/"+CODECONV::Jis2Euc2(JIS_STRING(buf));
  NATIVE_STRING cmd=NATIVE_STRING(MOVIE_PROGRAM)+" "+moviefile+" &";
  system(cmd.c_str());
  return true;
}

GdkPixmap* MakePixmap44(const TAG& t){
  int w,h;
  BlockIO *pf=currentDict->BlockFile();
  pf->Seek(t);
  int bitmaptype=pf->GetWord();
  switch(bitmaptype){
  case 1:
    h=pf->GetBCD(8);
    w=pf->GetBCD(8);
    do {
      while(pf->GetByte()!=0x1f);
    } while(pf->GetByte()!=0x64);
    TAG tag=pf->GetBCDTag();
    int len=(((w-1)>>3)+1)*h;
    byte* bitmap=new byte[len];
    pf->Seek(tag);
    pf->Read(bitmap,len);
    GdkPixmap* pix=MakeBitmap44Sub(bitmap,w,h);
    delete [] bitmap;
    return pix;
  }
  return NULL;
}

bool MMDisplayBitmap44(const TAG& t){
  GdkPixmap* pix=MakePixmap44(t);
  if (pix!=NULL){
    CreateModelessMessageBox(mainWindow,gtk_label_new(_("Bitmap 0x44")),
			     gtk_pixmap_new(pix,NULL));
    gdk_pixmap_unref(pix);
    return true;
  }
  return false;
}

bool MMPlayPCM4A(const TAG& t){
  BlockIO *pf=currentDict->BlockFile();
  char header[32];
  char* fName=NULL;

  pf->Seek(t);
  pf->Read(NULL,2);
  int type=pf->GetByte();
  pf->Read(NULL,1);
  TAG tag1=pf->GetBCDTag();
  TAG tag2=pf->GetBCDTag();
  int length=(tag2.Block()-tag1.Block())*2048+tag2.Offset()-tag1.Offset();
  const char* soundfile=catalogs.Dic(preference.currentDictNum)->SoundPath();
  BlockIO* npf;
  if (soundfile!=NULL){
    npf=OpenDict(soundfile);
    if (!npf->Initialized()) {
      delete npf;
      return false;
    }
  } else {
    npf=pf;
  }

  if (type==0){
    npf->Seek(tag1);
  } else if (npf==pf){ // "honmon"
    npf->Seek(TAG(currentDict->IndexStart(0xd8).Block(),32));
  } else { // "honmons"
    npf->Seek(TAG(1,32));
  }

  npf->Read(reinterpret_cast<byte*>(header),32);
  
  if (type==0) {
    length=GetRDWord(reinterpret_cast<byte*>(header)+28);
  } else {
    npf->Seek(tag1);
  }

  if (strncmp(header,"fmt ",4)!=0) {
    Debug::DebugOut(Debug::MULTIMEDIA,
		    "File format error or NDTP error\n");
    if (npf!=pf) delete npf;
    return false;
  }

  Debug::DebugOut(Debug::MULTIMEDIA,
		  "Start=%d:%d Len=%d\n",npf->Tell().Block(),
		  npf->Tell().Offset(),length);
  fName=strdup("DCTXXXXXX");
  int tmpfd=mkstemp(fName);
  if (tmpfd<0) return false;
  close(tmpfd);
  FILE* fp=fopen(fName,"w");
  if (fp==NULL) {
    free(fName);
    if (npf!=pf) delete npf;
    return false;
  }
  fwrite("RIFF",1,4,fp);
  PutRDWord(length+36,fp);
  fwrite("WAVE",1,4,fp);
  PutRDWord(length,reinterpret_cast<byte*>(header)+28);
  fwrite(header,1,32,fp);

  DupToFile(npf,TAG(-1,-1),length,fp);

  fclose(fp);

  if (npf!=pf) delete npf;
  if (fName!=NULL){
    char cmd[256];
    sprintf(cmd,"%s %s &",SOUND_PROGRAM,fName);
    system(cmd);
    sleep(1);
    unlink(fName);
    free(fName);
    return true;
  }
  return false;
}

static bool MMDisplayBitmap4D(const TAG& t){
  GdkPixmap* pix=MakePixmapFromHonmon(t);
  if (pix==NULL) {
    Debug::DebugOut(Debug::WARNINGS,
		    "Bitmap Error %d:%d\n",t.Block(),t.Offset());
    return false;
  }
  CreateModelessMessageBox(mainWindow,gtk_label_new(_("Bitmap 0x4D")),
			   gtk_pixmap_new(pix,NULL));
  gdk_pixmap_unref(pix);
  return true;
}

bool DispatchMultiMedia(DICCHAR* pch){
  ATTR at=pch->Attr();
  TAG tag=pch->Tag();
  int id=at.id;
  if (pch->Code() & 0xff00==0x1f00) {
    id=pch->Code() & 0xff;
  }
  Debug::DebugOut(Debug::TEMP,"MultiMedia ID=%02x\n",0xff & id);
  switch(id){
  case 0x14: // Color Sample
    return MMColorSample(tag);
  case 0x31:
    return MMDisplayBitmap31(tag);
  case 0x33:
    return MMPlayVoice33(tag);
  case 0x39:
    return MMPlayMovie39(tag);
  case 0x44:
    return MMDisplayBitmap44(tag);
  case 0x4A:
    return MMPlayPCM4A(tag);
  case 0x4D:
    return MMDisplayBitmap4D(tag);
  default: 
    return false;
  }
}

GdkPixmap* MakeInlinePixmap(const DICCHAR& ch,int& w,int& h){
  TAG tag=ch.Tag();
  GdkPixmap* pix=NULL;
  BlockIO* pf=currentDict->BlockFile();
  TAG current=pf->Tell();
  switch(ch.Attr().id){
  case 0x14: // Color Sample
    break;   // ToDo
  case 0x31:
    pix=MakePixmap31(tag);
    break;
  case 0x33:
  case 0x39:
    break; // Not for inline
  case 0x3c:
    pix=MakePixmapFromHonmon(tag);
    break;
  case 0x44:
    pix=MakePixmap44(tag);
    break;
  case 0x4A:
    break; // Not for inline
  case 0x4D:
    pix=MakePixmapFromHonmon(tag);
  default: 
    break;
  }
  if (pix!=NULL) gdk_window_get_size(pix,&w,&h);
  pf->Seek(current);
  return pix;
}
