#include <cstdio>
#include <cstdlib>
#include <cstring>
#include <unistd.h>
#include <limits.h>

extern bool Ebxa2wav(FILE* soundfp,FILE* wavfp,int startLBA,int endLBA);

void PutByte(int c,FILE* fp){
  unsigned int ch=static_cast<unsigned int>(c);
  putc(ch,fp);
};

void PutWord(int c,FILE* fp){
  unsigned int ch=static_cast<unsigned int>(c);
  putc(ch>>8,fp);
  putc(ch,fp);
}

void PutDWord(int c,FILE* fp){
  unsigned int ch=static_cast<unsigned int>(c);
  putc(ch>>24,fp);
  putc(ch>>16,fp);
  putc(ch>>8,fp);
  putc(ch,fp);
}

struct INDEX {
  int type;
  int start;
  int end;
  int adrs;
  bool operator==(const INDEX& idx) const {
    return type==idx.type && start==idx.start && end==idx.end;
  };
};

int compareIndex(const void* a,const void* b){
  return (static_cast<const INDEX*>(a)->start
	  -static_cast<const INDEX*>(b)->start);
};

int main(int argc,char** argv){
  char buf[2048],buf2[1024];
  INDEX* idx=new INDEX [100*60*75];
  int* idxmap=new int [100*60*75];
  int nFiles=0;
  FILE* ifp;
  if (argv[1][0]=='-' && argv[1][1]==0) {
    ifp=stdin;
  } else {
    ifp=fopen(argv[1],"r");
  }
  FILE* ofp=fopen(argv[2],"w");
  FILE* sfp=fopen(argv[3],"r");
  if (ifp==NULL || ofp==NULL || sfp==NULL) exit(1);
  int maxSect=0;
  fprintf(stderr,"Reading Index\n");
  while(fgets(buf2,1024,ifp)!=NULL){
    if (strncmp(buf2,"S:EB:",5)==0){
      idx[nFiles].type=atoi(buf2+5);
      idx[nFiles].start=atoi(buf2+12);
      idx[nFiles].end=atoi(buf2+19);
      if (idx[nFiles].end>maxSect) maxSect=idx[nFiles].end;
      nFiles++;
    }
  }
  fprintf(stderr,"Sorting Index\n");
  qsort(reinterpret_cast<void*>(idx),nFiles,sizeof(INDEX),compareIndex);

  for(int i=0;i<maxSect;i++){
    idxmap[maxSect]=0;
  }

  fprintf(stderr,"Merging Index\n");
  idx[nFiles].start=-1;
  int pointer0=0;
  int pointer1=1;
  while(pointer1<=nFiles){
    if (idx[pointer0]==idx[pointer1]) {
      pointer1++;
    } else {
      pointer0++;
      idx[pointer0]=idx[pointer1];
    }
  }

  PutDWord(0,ofp);
  for(int i=0;i<=pointer0;i++){
    PutDWord(0,ofp);
    PutDWord(0,ofp);
  }
  for(int i=0;i<pointer0;i++){
    int adrs=ftell(ofp);
    idx[i].adrs=adrs;
    char tmpfile[PATH_MAX+1];
    char tmpfile2[PATH_MAX+1];
    strcpy(tmpfile,"/tmp/EBXA1_XXXXXX");
    strcpy(tmpfile2,"/tmp/EBXA2_XXXXXX");
    int tfd=mkstemp(tmpfile);
    int tfd2=mkstemp(tmpfile2);
    close(tfd2);
    FILE* tfp=fdopen(tfd,"w");
    Ebxa2wav(sfp,tfp,idx[i].start,idx[i].end);
    fclose(tfp);
    char cmd[1024];
    sprintf(cmd,"mp3encdemo -br 64000 -if %s -of %s -v ",tmpfile,tmpfile2);
    system(cmd);
    unlink(tmpfile);
    tfp=fopen(tmpfile2,"r");
    while(int rsize=fread(buf,1,1024,tfp)>0){
      fwrite(buf,1,rsize,ofp);
    }
    fclose(tfp);
  }
}
