/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tools.internal;

import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.swt.tools.internal.ClassData;
import org.eclipse.swt.tools.internal.FieldData;
import org.eclipse.swt.tools.internal.JNIGenerator;

public class StructsGenerator
extends JNIGenerator {
    boolean header;
    static final boolean GLOBAL_REF = false;
    static /* synthetic */ Class class$0;

    public StructsGenerator(boolean header) {
        this.header = header;
    }

    public void generateCopyright() {
        this.generateMetaData("swt_copyright");
    }

    public void generateIncludes() {
        if (this.header) {
            this.output("#include \"");
            this.output(this.getOutputName());
            this.outputln(".h\"");
        } else {
            this.outputln("#include \"swt.h\"");
            this.output("#include \"");
            this.output(this.getOutputName());
            this.outputln("_structs.h\"");
        }
        this.outputln();
    }

    public void generate(Class clazz) {
        int j = 0;
        Field[] fields = clazz.getDeclaredFields();
        while (j < fields.length) {
            Field field = fields[j];
            int mods = field.getModifiers();
            if ((mods & 1) != 0 && (mods & 8) == 0) break;
            ++j;
        }
        if (j == fields.length) {
            return;
        }
        if (this.header) {
            this.generateHeaderFile(clazz);
        } else {
            this.generateSourceFile(clazz);
        }
    }

    public void generate() {
        if (!this.header && this.getClasses().length == 0) {
            return;
        }
        super.generate();
    }

    public String getExtension() {
        return this.header ? ".h" : super.getExtension();
    }

    public String getSuffix() {
        return "_structs";
    }

    void generateExcludes(Class[] classes) {
        HashSet<String> excludes = new HashSet<String>();
        int i = 0;
        while (i < classes.length) {
            Class clazz = classes[i];
            ClassData classData = this.getMetaData().getMetaData(clazz);
            String exclude = classData.getExclude();
            if (exclude.length() != 0) {
                excludes.add(exclude);
            }
            ++i;
        }
        Iterator iter = excludes.iterator();
        while (iter.hasNext()) {
            String exclude = (String)iter.next();
            this.outputln(exclude);
            int i2 = 0;
            while (i2 < classes.length) {
                Class clazz = classes[i2];
                ClassData classData = this.getMetaData().getMetaData(clazz);
                String classExclude = classData.getExclude();
                if (exclude.equals(classExclude)) {
                    this.output("#define NO_");
                    this.outputln(StructsGenerator.getClassName(clazz));
                }
                ++i2;
            }
            this.outputln("#endif");
            this.outputln();
        }
    }

    void generateHeaderFile(Class clazz) {
        this.generateSourceStart(clazz);
        this.generatePrototypes(clazz);
        this.generateBlankMacros(clazz);
        this.generateSourceEnd(clazz);
        this.outputln();
    }

    void generateSourceFile(Class clazz) {
        this.generateSourceStart(clazz);
        this.generateFIDsStructure(clazz);
        this.outputln();
        this.generateGlobalVar(clazz);
        this.outputln();
        this.generateFunctions(clazz);
        this.generateSourceEnd(clazz);
        this.outputln();
    }

    void generateSourceStart(Class clazz) {
        String clazzName = StructsGenerator.getClassName(clazz);
        this.output("#ifndef NO_");
        this.outputln(clazzName);
    }

    void generateSourceEnd(Class clazz) {
        this.outputln("#endif");
    }

    void generateGlobalVar(Class clazz) {
        String clazzName = StructsGenerator.getClassName(clazz);
        this.output(clazzName);
        this.output("_FID_CACHE ");
        this.output(clazzName);
        this.outputln("Fc;");
    }

    void generateBlankMacros(Class clazz) {
        String clazzName = StructsGenerator.getClassName(clazz);
        this.outputln("#else");
        this.output("#define cache");
        this.output(clazzName);
        this.outputln("Fields(a,b)");
        this.output("#define get");
        this.output(clazzName);
        this.outputln("Fields(a,b,c) NULL");
        this.output("#define set");
        this.output(clazzName);
        this.outputln("Fields(a,b,c)");
        this.output("#define ");
        this.output(clazzName);
        this.outputln("_sizeof() 0");
    }

    void generatePrototypes(Class clazz) {
        String clazzName = StructsGenerator.getClassName(clazz);
        this.output("void cache");
        this.output(clazzName);
        this.outputln("Fields(JNIEnv *env, jobject lpObject);");
        this.output(clazzName);
        this.output(" *get");
        this.output(clazzName);
        this.output("Fields(JNIEnv *env, jobject lpObject, ");
        this.output(clazzName);
        this.outputln(" *lpStruct);");
        this.output("void set");
        this.output(clazzName);
        this.output("Fields(JNIEnv *env, jobject lpObject, ");
        this.output(clazzName);
        this.outputln(" *lpStruct);");
        this.output("#define ");
        this.output(clazzName);
        this.output("_sizeof() sizeof(");
        this.output(clazzName);
        this.outputln(")");
    }

    void generateFIDsStructure(Class clazz) {
        String clazzName = StructsGenerator.getClassName(clazz);
        this.output("typedef struct ");
        this.output(clazzName);
        this.outputln("_FID_CACHE {");
        this.outputln("\tint cached;");
        this.outputln("\tjclass clazz;");
        this.output("\tjfieldID ");
        Field[] fields = clazz.getDeclaredFields();
        boolean first = true;
        int i = 0;
        while (i < fields.length) {
            Field field = fields[i];
            if (!this.ignoreField(field)) {
                if (!first) {
                    this.output(", ");
                }
                this.output(field.getName());
                first = false;
            }
            ++i;
        }
        this.outputln(";");
        this.output("} ");
        this.output(clazzName);
        this.outputln("_FID_CACHE;");
    }

    void generateCacheFunction(Class clazz) {
        String clazzName = StructsGenerator.getClassName(clazz);
        this.output("void cache");
        this.output(clazzName);
        this.outputln("Fields(JNIEnv *env, jobject lpObject)");
        this.outputln("{");
        this.output("\tif (");
        this.output(clazzName);
        this.outputln("Fc.cached) return;");
        Class superclazz = clazz.getSuperclass();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (superclazz != clazz2) {
            String superName = StructsGenerator.getClassName(superclazz);
            this.output("\tcache");
            this.output(superName);
            this.outputln("Fields(env, lpObject);");
        }
        this.output("\t");
        this.output(clazzName);
        if (this.isCPP) {
            this.output("Fc.clazz = env->GetObjectClass(lpObject);");
        } else {
            this.output("Fc.clazz = (*env)->GetObjectClass(env, lpObject);");
        }
        this.outputln();
        Field[] fields = clazz.getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            Field field = fields[i];
            if (!this.ignoreField(field)) {
                this.output("\t");
                this.output(clazzName);
                this.output("Fc.");
                this.output(field.getName());
                if (this.isCPP) {
                    this.output(" = env->GetFieldID(");
                } else {
                    this.output(" = (*env)->GetFieldID(env, ");
                }
                this.output(clazzName);
                this.output("Fc.clazz, \"");
                this.output(field.getName());
                this.output("\", \"");
                this.output(StructsGenerator.getTypeSignature(field.getType()));
                this.outputln("\");");
            }
            ++i;
        }
        this.output("\t");
        this.output(clazzName);
        this.outputln("Fc.cached = 1;");
        this.outputln("}");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void generateGetFields(Class clazz) {
        Class superclazz = clazz.getSuperclass();
        String clazzName = StructsGenerator.getClassName(clazz);
        String superName = StructsGenerator.getClassName(superclazz);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (superclazz != clazz2) {
            if (!clazzName.equals(String.valueOf(superName) + "A") && !clazzName.equals(String.valueOf(superName) + "W")) {
                this.output("\tget");
                this.output(superName);
                this.output("Fields(env, lpObject, (");
                this.output(superName);
                this.outputln(" *)lpStruct);");
            } else {
                this.generateGetFields(superclazz);
            }
        }
        Field[] fields = clazz.getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            Field field = fields[i];
            if (!this.ignoreField(field)) {
                boolean noWinCE;
                FieldData fieldData = this.getMetaData().getMetaData(field);
                String exclude = fieldData.getExclude();
                if (exclude.length() != 0) {
                    this.outputln(exclude);
                }
                if (noWinCE = fieldData.getFlag("no_wince")) {
                    this.outputln("#ifndef _WIN32_WCE");
                }
                Class<?> type = field.getType();
                String typeName = StructsGenerator.getClassName(type);
                String accessor = fieldData.getAccessor();
                if (accessor == null || accessor.length() == 0) {
                    accessor = field.getName();
                }
                if (type.isPrimitive()) {
                    this.output("\tlpStruct->");
                    this.output(accessor);
                    this.output(" = ");
                    this.output(fieldData.getCast());
                    if (this.isCPP) {
                        this.output("env->Get");
                    } else {
                        this.output("(*env)->Get");
                    }
                    this.output(StructsGenerator.getTypeSignature1(field.getType()));
                    if (this.isCPP) {
                        this.output("Field(lpObject, ");
                    } else {
                        this.output("Field(env, lpObject, ");
                    }
                    this.output(StructsGenerator.getClassName(field.getDeclaringClass()));
                    this.output("Fc.");
                    this.output(field.getName());
                    this.output(");");
                } else if (type.isArray()) {
                    Class<?> componentType = type.getComponentType();
                    if (!componentType.isPrimitive()) throw new Error("not done");
                    this.outputln("\t{");
                    this.output("\t");
                    this.output(StructsGenerator.getTypeSignature2(field.getType()));
                    this.output(" lpObject1 = (");
                    this.output(StructsGenerator.getTypeSignature2(field.getType()));
                    if (this.isCPP) {
                        this.output(")env->GetObjectField(lpObject, ");
                    } else {
                        this.output(")(*env)->GetObjectField(env, lpObject, ");
                    }
                    this.output(StructsGenerator.getClassName(field.getDeclaringClass()));
                    this.output("Fc.");
                    this.output(field.getName());
                    this.outputln(");");
                    if (this.isCPP) {
                        this.output("\tenv->Get");
                    } else {
                        this.output("\t(*env)->Get");
                    }
                    this.output(StructsGenerator.getTypeSignature1(componentType));
                    if (this.isCPP) {
                        this.output("ArrayRegion(lpObject1, 0, sizeof(lpStruct->");
                    } else {
                        this.output("ArrayRegion(env, lpObject1, 0, sizeof(lpStruct->");
                    }
                    this.output(accessor);
                    this.output(")");
                    int byteCount = StructsGenerator.getByteCount(componentType);
                    if (byteCount > 1) {
                        this.output(" / ");
                        this.output(String.valueOf(byteCount));
                    }
                    this.output(", (");
                    this.output(StructsGenerator.getTypeSignature4(type));
                    this.output(")lpStruct->");
                    this.output(accessor);
                    this.outputln(");");
                    this.output("\t}");
                } else {
                    this.outputln("\t{");
                    if (this.isCPP) {
                        this.output("\tjobject lpObject1 = env->GetObjectField(lpObject, ");
                    } else {
                        this.output("\tjobject lpObject1 = (*env)->GetObjectField(env, lpObject, ");
                    }
                    this.output(StructsGenerator.getClassName(field.getDeclaringClass()));
                    this.output("Fc.");
                    this.output(field.getName());
                    this.outputln(");");
                    this.output("\tif (lpObject1 != NULL) get");
                    this.output(typeName);
                    this.output("Fields(env, lpObject1, &lpStruct->");
                    this.output(accessor);
                    this.outputln(");");
                    this.output("\t}");
                }
                this.outputln();
                if (noWinCE) {
                    this.outputln("#endif");
                }
                if (exclude.length() != 0) {
                    this.outputln("#endif");
                }
            }
            ++i;
        }
    }

    void generateGetFunction(Class clazz) {
        String clazzName = StructsGenerator.getClassName(clazz);
        this.output(clazzName);
        this.output(" *get");
        this.output(clazzName);
        this.output("Fields(JNIEnv *env, jobject lpObject, ");
        this.output(clazzName);
        this.outputln(" *lpStruct)");
        this.outputln("{");
        this.output("\tif (!");
        this.output(clazzName);
        this.output("Fc.cached) cache");
        this.output(clazzName);
        this.outputln("Fields(env, lpObject);");
        this.generateGetFields(clazz);
        this.outputln("\treturn lpStruct;");
        this.outputln("}");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void generateSetFields(Class clazz) {
        Class superclazz = clazz.getSuperclass();
        String clazzName = StructsGenerator.getClassName(clazz);
        String superName = StructsGenerator.getClassName(superclazz);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (superclazz != clazz2) {
            if (!clazzName.equals(String.valueOf(superName) + "A") && !clazzName.equals(String.valueOf(superName) + "W")) {
                this.output("\tset");
                this.output(superName);
                this.output("Fields(env, lpObject, (");
                this.output(superName);
                this.outputln(" *)lpStruct);");
            } else {
                this.generateSetFields(superclazz);
            }
        }
        Field[] fields = clazz.getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            Field field = fields[i];
            if (!this.ignoreField(field)) {
                boolean noWinCE;
                FieldData fieldData = this.getMetaData().getMetaData(field);
                String exclude = fieldData.getExclude();
                if (exclude.length() != 0) {
                    this.outputln(exclude);
                }
                if (noWinCE = fieldData.getFlag("no_wince")) {
                    this.outputln("#ifndef _WIN32_WCE");
                }
                Class<?> type = field.getType();
                String typeName = StructsGenerator.getClassName(type);
                String accessor = fieldData.getAccessor();
                if (accessor == null || accessor.length() == 0) {
                    accessor = field.getName();
                }
                if (type.isPrimitive()) {
                    if (this.isCPP) {
                        this.output("\tenv->Set");
                    } else {
                        this.output("\t(*env)->Set");
                    }
                    this.output(StructsGenerator.getTypeSignature1(field.getType()));
                    if (this.isCPP) {
                        this.output("Field(lpObject, ");
                    } else {
                        this.output("Field(env, lpObject, ");
                    }
                    this.output(StructsGenerator.getClassName(field.getDeclaringClass()));
                    this.output("Fc.");
                    this.output(field.getName());
                    this.output(", (");
                    this.output(StructsGenerator.getTypeSignature2(field.getType()));
                    this.output(")lpStruct->");
                    this.output(accessor);
                    this.output(");");
                } else if (type.isArray()) {
                    Class<?> componentType = type.getComponentType();
                    if (!componentType.isPrimitive()) throw new Error("not done");
                    this.outputln("\t{");
                    this.output("\t");
                    this.output(StructsGenerator.getTypeSignature2(field.getType()));
                    this.output(" lpObject1 = (");
                    this.output(StructsGenerator.getTypeSignature2(field.getType()));
                    if (this.isCPP) {
                        this.output(")env->GetObjectField(lpObject, ");
                    } else {
                        this.output(")(*env)->GetObjectField(env, lpObject, ");
                    }
                    this.output(StructsGenerator.getClassName(field.getDeclaringClass()));
                    this.output("Fc.");
                    this.output(field.getName());
                    this.outputln(");");
                    if (this.isCPP) {
                        this.output("\tenv->Set");
                    } else {
                        this.output("\t(*env)->Set");
                    }
                    this.output(StructsGenerator.getTypeSignature1(componentType));
                    if (this.isCPP) {
                        this.output("ArrayRegion(lpObject1, 0, sizeof(lpStruct->");
                    } else {
                        this.output("ArrayRegion(env, lpObject1, 0, sizeof(lpStruct->");
                    }
                    this.output(accessor);
                    this.output(")");
                    int byteCount = StructsGenerator.getByteCount(componentType);
                    if (byteCount > 1) {
                        this.output(" / ");
                        this.output(String.valueOf(byteCount));
                    }
                    this.output(", (");
                    this.output(StructsGenerator.getTypeSignature4(type));
                    this.output(")lpStruct->");
                    this.output(accessor);
                    this.outputln(");");
                    this.output("\t}");
                } else {
                    this.outputln("\t{");
                    this.output("\tjobject lpObject1 = (*env)->GetObjectField(env, lpObject, ");
                    this.output(StructsGenerator.getClassName(field.getDeclaringClass()));
                    this.output("Fc.");
                    this.output(field.getName());
                    this.outputln(");");
                    this.output("\tif (lpObject1 != NULL) set");
                    this.output(typeName);
                    this.output("Fields(env, lpObject1, &lpStruct->");
                    this.output(accessor);
                    this.outputln(");");
                    this.output("\t}");
                }
                this.outputln();
                if (noWinCE) {
                    this.outputln("#endif");
                }
                if (exclude.length() != 0) {
                    this.outputln("#endif");
                }
            }
            ++i;
        }
    }

    void generateSetFunction(Class clazz) {
        String clazzName = StructsGenerator.getClassName(clazz);
        this.output("void set");
        this.output(clazzName);
        this.output("Fields(JNIEnv *env, jobject lpObject, ");
        this.output(clazzName);
        this.outputln(" *lpStruct)");
        this.outputln("{");
        this.output("\tif (!");
        this.output(clazzName);
        this.output("Fc.cached) cache");
        this.output(clazzName);
        this.outputln("Fields(env, lpObject);");
        this.generateSetFields(clazz);
        this.outputln("}");
    }

    void generateFunctions(Class clazz) {
        this.generateCacheFunction(clazz);
        this.outputln();
        this.generateGetFunction(clazz);
        this.outputln();
        this.generateSetFunction(clazz);
    }

    boolean ignoreField(Field field) {
        int mods = field.getModifiers();
        return (mods & 1) == 0 || (mods & 0x10) != 0 || (mods & 8) != 0;
    }
}

