#! /bin/sh

#================================================================
# shcgitest.cgi
# CGI script to test CGI features of the SI utility
#================================================================


# set variables
progname="shcgitest.cgi"
tmpdir="/tmp"
tmpfile="$tmpdir/$progname.$$"
PATH="$PATH:/usr/local/bin:." ; export PATH
LD_LIBRARY_PATH="$LD_LIBRARY_PATH:/usr/local/lib:." ; export LD_LIBRARY_PATH


# function to remove the temporary file
tmpclean(){
  rm -f "$tmpfile"
}


# set the exit trap
trap tmpclean 1 2 3 13 15


# parse the CGI parameters
if [ "$REQUEST_METHOD" = "POST" ] && [ -n "$CONTENT_LENGTH" ]
then
  head -c "$CONTENT_LENGTH" > "$tmpfile"
elif [ "$REQUEST_METHOD" = "GET" ] && [ -n "$QUERY_STRING" ]
then
  printf '%s' "$QUERY_STRING" > "$tmpfile"
else
  touch "$tmpfile"
fi


# output the result
printf 'Content-Type: text/html; charset=UTF-8\r\n\r\n'
cat <<__EOF__
<html>
<head>
<title>TEST FOR PARSING CGI PARAMETERS</title>
</head>
<body>
<h1>TEST FOR PARSING CGI PARAMETERS</h1>
<form method="post" action="$progname">
<div>p1: <input type="text" name="p1"></div>
<div>p2: <input type="text" name="p2"></div>
<div><input type="submit" value="submit"></div>
</form>
__EOF__
p1=`estsiutil cgiparam p1 < "$tmpfile"`
p2=`estsiutil cgiparam p2 < "$tmpfile"`
printf '<div>p1: %s</div>' `estsiutil htmlesc "$p1"`
printf '<div>p2: %s</div>' `estsiutil htmlesc "$p2"`
cat <<__EOF__
</body>
</html>
__EOF__


# clean up the temporary directory
tmpclean


# exit normally
exit 0



# END OF FILE
