#ifndef KMLISTVIEW_H
#define KMLISTVIEW_H

#include <qdragobject.h>

#include <klistview.h>

class KMListView : public KListView
{
	Q_OBJECT

	public:
		KMListView(QWidget * parent = 0, const char * name = 0);
		~KMListView();

		void setSelected(QListViewItem * item, bool selected);
		void clearSelection();
		QListViewItem * selectedItem() const;

	public slots:
		void selectAll();

	signals:
		void mouseButtonReleased(const QPoint &);
		void keyPressed(QKeyEvent * e);
		void rightMouseButtonClicked(const QPoint &);
		void dragging();

	protected:
		bool acceptDrag(QDropEvent * event) const;
		void contentsMousePressEvent(QMouseEvent * e);
		void contentsMouseReleaseEvent(QMouseEvent * e);
		void contentsMouseMoveEvent(QMouseEvent * e);
		void keyPressEvent(QKeyEvent * e);

	private:
		bool dndPerm;
};

#endif
