/**

	lyrics.h

	Lyrics' engine header file

**/

#ifndef LYRICS_H
#define LYRICS_H

#include <qbuffer.h>
#include <qstring.h>

class Lyrics
{
	public:
		Lyrics();
		~Lyrics();

		void setTitle(const QString & t);
		void setArtist(const QString & a);

		void setPath(const QString & p);
		
		QString getFromLocal();
		QString getFromBuffer(QBuffer * buffer);
		
	private:
		QString title;
		QString artist;
		QString lyrics;
		QString path;

		void makeLyricsDir() const;
		void saveAsLocal() const;
};

#endif
