/*
 *  Copyright (C) 2005 Kouji TAKAO <kouji@netlab.jp>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <string.h>

#include "util.h"

gint
gpass_strcmp(const gchar *s1, const gchar *s2)
{
    if (s1 == NULL) {
        if (s2 == NULL) {
            return 0;
        }
        else {
            return -1;
        }
    }
    else {
        if (s2 == NULL) {
            return 1;
        }
        else {
            return strcmp(s1, s2);
        }
    }
}

GPassAttribute *
gpass_param_spec_to_attribute(GParamSpec *spec, GPassAttributeType type)
{
    return g_object_new(GPASS_TYPE_ATTRIBUTE,
                        "type", type,
                        "name", g_param_spec_get_name(spec),
                        "nick", g_param_spec_get_nick(spec),
                        "blurb", g_param_spec_get_blurb(spec),
                        NULL);
}

