/*
 *  Copyright (C) 2005 Kouji TAKAO <kouji@netlab.jp>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <glib/gi18n.h>
#include <gtk/gtklabel.h>
#include <gtk/gtkentry.h>
#include <gtk/gtkdialog.h>

#include "helper.h"
#include "application.h"
#include "authentication.h"

GType
gpass_authentication_get_type(void)
{
    static GType type = 0;
    if (type == 0) {
        static const GTypeInfo info = {
            sizeof(GPassAuthenticationClass),
            NULL,
            NULL,
            NULL,
            NULL,
            NULL,
            sizeof(GPassAuthentication),
            0,
            NULL,
        };
        type = g_type_register_static(GPASS_TYPE_VIEW,
                                      "GPassAuthenticationType", &info, 0);
    }
    return type;
}

/***********************************************************
 *
 * Signal handlers
 *
 ***********************************************************/
static gboolean
set_master_password(GPassAuthentication *self)
{
    GPassApplication *app;
    GtkWidget *entry;
    const gchar *password;
    GError *error = NULL;

    entry = glade_xml_get_widget(GPASS_VIEW(self)->xml, "password");
    password = gtk_entry_get_text(GTK_ENTRY(entry));
    app = GPASS_APPLICATION(GPASS_VIEW(self)->model);
    error = gpass_file_open(&app->file, app->file_path, password);
    if (error == NULL) {
        return TRUE;
    }
    else {
        g_error_free(error);
        gpass_view_show_error_message(GPASS_VIEW(self),
                                      _("Incorrect password!"), entry);
        return FALSE;
    }
}

void
gpass_authentication_on_response(GtkWidget *widget, gint response_id,
                                 gpointer user_data)
{
    GPassAuthentication *self;
    
    gpass_view_self_from_widget(widget, (gpointer **) &self);
    if (response_id == GTK_RESPONSE_OK) {
        if (set_master_password(self)) {
            GPASS_VIEW(self)->result = GPASS_VIEW_RESULT_SUCCEED;
            gpass_view_shutdown_main_loop(GPASS_VIEW(self));
        }
    }
    else {
        GPASS_VIEW(self)->result = GPASS_VIEW_RESULT_FAILED;
        gpass_view_shutdown_main_loop(GPASS_VIEW(self));
    }
}
