/*
 *  Copyright (C) 2005 Kouji TAKAO <kouji@netlab.jp>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n.h>

#include "assert-macros.h"

#include "gpass/root-entry.h"

/***********************************************************
 *
 * initialize/terminate,  setup/teardown
 *
 ***********************************************************/
static void
initialize(void)
{
    g_type_init();
}

static void
terminate(void)
{
}

static void
setup(void)
{
}

static void
teardown(void)
{
}

/***********************************************************
 *
 * test case
 *
 ***********************************************************/
static GPassEntryClass *
create_root_entry_class(void)
{
    return GPASS_ENTRY_CLASS(g_type_class_ref(gpass_root_entry_get_type()));
}

START_TEST(test_s_nick)
{
    GPassEntryClass *entry_class = create_root_entry_class();
    
    ASSERT_EQUAL_STRING(_("Root"), gpass_entry_class_nick(entry_class));
}
END_TEST

START_TEST(test_s_can_have_child)
{
    GPassEntryClass *entry_class = create_root_entry_class();
    
    ASSERT_TRUE(gpass_entry_class_can_have_child(entry_class));
}
END_TEST

static GPassEntry *
create_root_entry(void)
{
    return GPASS_ENTRY(g_object_new(GPASS_TYPE_ROOT_ENTRY, NULL));
}

START_TEST(test_get)
{
    GPassEntry *entry = create_root_entry();
    gchar *str;

    g_object_get(entry, "type", &str, NULL);
    ASSERT_EQUAL_STRING("root", str);
    
    g_object_unref(entry);
}
END_TEST

/***********************************************************
 *
 * suite / main
 *
 ***********************************************************/
static Suite *
test_suite(void)
{
    Suite *s = suite_create("GPassRootEntry");
    TCase *tc;
    
    tc = tcase_create("functions");
    suite_add_tcase(s, tc);
    tcase_add_checked_fixture(tc, setup, teardown);
    
    tcase_add_test(tc, test_s_nick);
    tcase_add_test(tc, test_s_can_have_child);

    tcase_add_test(tc, test_get);
    return s;
}

int
main(int argc, char *argv[])
{
    Suite *s;
    SRunner *sr;
    int nf;

    initialize();
    
    s = test_suite();
    sr = srunner_create(s);
    srunner_run_all(sr, CK_ENV);
    nf = srunner_ntests_failed(sr);
    srunner_free(sr);
    
    terminate();
    return (nf == 0) ? EXIT_SUCCESS : EXIT_FAILURE;
}
