#include "gis.h"
#include <sys/stat.h>

#define MAX_FILENAME 11

char mapname[MAX_FILENAME + 1];

int
main (int argc, char *argv[])
{
  struct Option *map_opt, *meta_opt;
  struct Flag *flag;
  char path[500], buf[1000];
  struct GModule *module;

  G_gisinit (argv[0]);
  
  /* Set description */
  module              = G_define_module();
  module->description = ""\
  "Installs supplementary metadata file preparatory to creation of an SDTS export dataset.";

  meta_opt = G_define_option ();
  meta_opt->key = "metafile";
  meta_opt->description = "metadata file, usually generated by v.sdts.meta";
  meta_opt->required = YES;
  meta_opt->type = TYPE_STRING;

  map_opt = G_define_option ();
  map_opt->key = "map";
  map_opt->description = "vector file associated with the metadata file";
  map_opt->required = YES;
  map_opt->type = TYPE_STRING;
  map_opt->gisprompt = "old,dig,vector";


  flag = G_define_flag ();
  flag->key             = 'f';
  flag->description     = "force overwriting of existing metadata file";

  if (G_parser (argc, argv))
    exit (1);

  if (G_find_vector (map_opt->answer, "") == NULL)
    {
      fprintf (stderr, "No such vector file %s\n", map_opt->answer);
      exit (2);
    }

  sprintf (path, "dig_misc/%s/sdts_meta", map_opt->answer);
  G__make_mapset_element (path);

  if (valid_meta (meta_opt->answer))
    {
      if (flag->answer || !G_find_file (path, "metafile", G_mapset()))
	{
	   sprintf (buf, "cp %s %s/%s/%s/metafile", meta_opt->answer,
		    G_location_path (), G_mapset (), path);

	   if (!system (buf))
	     fprintf(stderr,"SDTS metadata file for vector map <%s> is installed\n", map_opt->answer);
/*
		     meta_opt->answer, G_location_path (), G_mapset (), path);
*/

	} 
	else 
	{
	/*
           fprintf(stderr,"File %s/%s/%s/metafile already exists.\nUse -f option to overwrite.\n" , G_location_path (), G_mapset (), path);
        */
           fprintf (stderr, "SDTS metadata file for <%s> already exists.\nUse overwrite option.\n", map_opt->answer);
	   exit (3);
        }

    }
    else
    {
      fprintf (stderr, "Invalid meta-data file %s\n", meta_opt->answer);
      exit (4);
    }
  exit (0);
}    

int
valid_meta (fname)
char *fname;
{
  struct stat info;
  FILE *fp;

  if (stat (fname, &info) != 0)
      return 0;

  /* It is a plain file */
  if (S_ISREG (info.st_mode))
    {
      if (fopen (fname, "r") != NULL)
	return 1;
    }
  
  return 0;
}
