#! /usr/bin/ruby -Ke

#==============================================================================#
# $Id: pie2.rb,v 1.3 2004/01/23 00:38:36 yuya Exp $
#==============================================================================#

require 'grb/chart/pie/facade'

#==============================================================================#

data = [
  {:name => 'Field 1', :value => 9, :color => GRb::Color.hex('CC3333') },
  {:name => 'Field 2', :value => 8, :color => GRb::Color.hex('33CC33') },
  {:name => 'Field 3', :value => 6, :color => GRb::Color.hex('3333CC') },
  {:name => 'Field 4', :value => 5, :color => GRb::Color.hex('CCCC33') },
  {:name => 'Field 5', :value => 3, :color => GRb::Color.hex('3399CC') },
  {:name => 'Field 6', :value => 2, :color => GRb::Color.hex('CC33CC') },
]

#==============================================================================#

facade = GRb::Chart::PieChartFacade.create(500, 300)
facade.title.text             = 'Pie Chart Sample 2'          # ȥ ʸ
facade.title.font.color       = GRb::Color.white              # ȥ ե 
facade.frame.picture.visible  = true                          # ط  ɽ
facade.frame.picture.filepath = 'background.png'              # ط  ե̾
facade.frame.border.visible   = false                         # ط  ɽ
facade.frame.shadow.visible   = true                          # ط  ɽ
facade.legend.fill.visible    = true                          #  طʿ ɽ
facade.legend.fill.color      = GRb::Color.white              #  طʿ 
facade.legend.fill.opacity    = 25                            #  طʿ Ʃ
facade.legend.border.visible  = false                         #   ɽ
facade.chart.fill.visible     = true                          # 㡼 طʿ ɽ
facade.chart.fill.color       = GRb::Color.black              # 㡼 طʿ 
facade.chart.fill.opacity     = 30                            # 㡼 طʿ Ʃ
facade.chart.edge.visible     = false                         # 㡼  ɽ
facade.chart.label.visible    = true                          # 㡼 ٥ ɽ
facade.chart.label.font.name  = GRb::Chart::Font::Medium      # 㡼 ٥ ե ̾
facade.chart.label.font.color = GRb::Color.white              # 㡼 ٥ ե 
facade.chart.label.line.color = GRb::Color.white              # 㡼 ٥ Ф 
facade.chart.padding.left     = 20                            # 㡼 ѥǥ 
facade.chart.padding.right    = 20                            # 㡼 ѥǥ 
facade.chart.padding.top      = 20                            # 㡼 ѥǥ 
facade.chart.padding.bottom   = 20                            # 㡼 ѥǥ 
facade.data                   = data
facade.write_png_file('pie2.png')

#==============================================================================#
#==============================================================================#
