
#==============================================================================#
# $Id: gradation.rb,v 1.3 2004/01/23 05:24:11 yuya Exp $
# $Source: /cvsroot/gruby/gruby/lib/grb/chart/base/property/gradation.rb,v $
#==============================================================================#

require 'grb/chart/base/property/base'
require 'grb/chart/base/decorator/gradation'

#==============================================================================#

module GRb

  module Chart

    class GradationProperty < PropertyBase

      def initialize
        @visible     = nil
        @start_color = nil
        @end_color   = nil
        @angle       = nil
        @opacity     = nil
      end

      attr_accessor :visible, :start_color, :end_color, :angle, :opacity

      def create_decorator(child)
        if @visible
          decorator = GradationDecorator.new(child)
          decorator.color_start = @start_color || Color.white
          decorator.color_end   = @end_color   || Color.black
          decorator.direction   = @angle       || 0
          decorator.opacity     = @opacity     || 100
          return decorator
        else
          return child
        end
      end

    end # GradationProperty

  end # Chart

end # GRb

#==============================================================================#
#==============================================================================#
