
#==============================================================================#
# $Id: text.rb,v 1.2 2004/01/23 04:41:17 yuya Exp $
# $Source: /cvsroot/gruby/gruby/lib/grb/chart/base/utility/text.rb,v $
#==============================================================================#

require 'grb/chart/base/utility/box'
require 'grb/chart/base/utility/font'

#==============================================================================#

module GRb

  module Chart

    class Text

      def initialize(font, text, align = GRb::Font::ALIGN_FIT_LEFT, valign = GRb::Font::VALIGN_FIT_TOP)
        @font   = font
        @text   = text
        @align  = align
        @valign = valign
      end

      def draw(image, box)
        @font.draw(image, box.x, box.y, @text, @align, @valign)
      end

      def draw2(image, x, y)
        self.draw(image, Box.new(x, y, 0, 0))
      end

      def dx
        return @font.width(@text)
      end

      def dy
        return @font.height(@text)
      end

    end # Text

  end # Graph

end # GRb

#==============================================================================#

if $0 == __FILE__
  require 'grb/image'

  GRb::Image.create_and_write_png_file(400, 400, false, __FILE__.sub(/\.rb/, '.png')) { |image|
    grid = GRb::Color.red(128)
    image.line(0, 100, 400, 100, grid)
    image.line(0, 200, 400, 200, grid)
    image.line(0, 300, 400, 300, grid)
    image.line(100, 0, 100, 400, grid)
    image.line(200, 0, 200, 400, grid)
    image.line(300, 0, 300, 400, grid)

    text = "Align"
    ttf  = '/cygdrive/c/WINDOWS/Fonts/CENTURY.TTF'
    font = GRb::Chart::Font.truetype(ttf, 26, GRb::Color.blue(128), 30)

    GRb::Chart::Text.new(font, text, GRb::Font::ALIGN_RIGHT,  GRb::Font::VALIGN_BOTTOM).draw2(image, 100, 100)
    GRb::Chart::Text.new(font, text, GRb::Font::ALIGN_CENTER, GRb::Font::VALIGN_BOTTOM).draw2(image, 200, 100)
    GRb::Chart::Text.new(font, text, GRb::Font::ALIGN_LEFT,   GRb::Font::VALIGN_BOTTOM).draw2(image, 300, 100)
    GRb::Chart::Text.new(font, text, GRb::Font::ALIGN_RIGHT,  GRb::Font::VALIGN_MIDDLE).draw2(image, 100, 200)
    GRb::Chart::Text.new(font, text, GRb::Font::ALIGN_CENTER, GRb::Font::VALIGN_MIDDLE).draw2(image, 200, 200)
    GRb::Chart::Text.new(font, text, GRb::Font::ALIGN_LEFT,   GRb::Font::VALIGN_MIDDLE).draw2(image, 300, 200)
    GRb::Chart::Text.new(font, text, GRb::Font::ALIGN_RIGHT,  GRb::Font::VALIGN_TOP).draw2(image, 100, 300)
    GRb::Chart::Text.new(font, text, GRb::Font::ALIGN_CENTER, GRb::Font::VALIGN_TOP).draw2(image, 200, 300)
    GRb::Chart::Text.new(font, text, GRb::Font::ALIGN_LEFT,   GRb::Font::VALIGN_TOP).draw2(image, 300, 300)
  }
end

#==============================================================================#
#==============================================================================#
